/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import org.apache.poi.ss.format.CellFormatter;
import poi.support.POIFormatterUtil;

public class CellGeneralFormatter
extends CellFormatter {
    public CellGeneralFormatter() {
        super("General");
    }

    public void formatValue(StringBuffer toAppendTo, Object value) {
        if (value instanceof Number) {
            String fmt;
            double val = ((Number)value).doubleValue();
            if (val == 0.0) {
                toAppendTo.append('0');
                return;
            }
            double exp = Math.log(Math.abs(val)) / Math.log(10.0);
            boolean stripZeros = true;
            if (exp > 10.0 || exp < -9.0) {
                fmt = "%1.5E";
            } else if ((double)((long)val) != val) {
                fmt = "%1.9f";
            } else {
                fmt = "%1.0f";
                stripZeros = false;
            }
            POIFormatterUtil.format(toAppendTo, fmt, new Object[]{value});
            if (stripZeros) {
                int removeFrom = fmt.endsWith("E") ? toAppendTo.lastIndexOf("E") - 1 : toAppendTo.length() - 1;
                while (toAppendTo.charAt(removeFrom) == '0') {
                    toAppendTo.deleteCharAt(removeFrom--);
                }
                if (toAppendTo.charAt(removeFrom) == '.') {
                    toAppendTo.deleteCharAt(removeFrom--);
                }
            }
        } else {
            toAppendTo.append(value.toString());
        }
    }

    public void simpleValue(StringBuffer toAppendTo, Object value) {
        this.formatValue(toAppendTo, value);
    }
}

