/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.model;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.hpbf.model.HPBFPart;
import org.apache.poi.poifs.filesystem.DirectoryNode;

public abstract class EscherPart
extends HPBFPart {
    private EscherRecord[] records;

    public EscherPart(DirectoryNode baseDir, String[] parts) throws IOException {
        super(baseDir, parts);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        ArrayList<EscherRecord> ec = new ArrayList<EscherRecord>();
        int left = this.data.length;
        while (left > 0) {
            EscherRecord er = erf.createRecord(this.data, 0);
            er.fillFields(this.data, 0, (EscherRecordFactory)erf);
            left -= er.getRecordSize();
            ec.add(er);
        }
        this.records = ec.toArray(new EscherRecord[ec.size()]);
    }

    public EscherRecord[] getEscherRecords() {
        return this.records;
    }

    protected void generateData() {
        int size = 0;
        int i = 0;
        while (i < this.records.length) {
            size += this.records[i].getRecordSize();
            ++i;
        }
        this.data = new byte[size];
        size = 0;
        i = 0;
        while (i < this.records.length) {
            int thisSize = this.records[i].serialize(size, this.data);
            size += thisSize;
            ++i;
        }
    }
}

