/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hwpf.model.CharIndexTranslator;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public class TextPieceTable
implements CharIndexTranslator {
    protected ArrayList _textPieces = new ArrayList();
    protected ArrayList _textPiecesFCOrder = new ArrayList();
    int _cpMin;

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin) {
        PlexOfCps pieceTable = new PlexOfCps(tableStream, offset, size, PieceDescriptor.getSizeInBytes());
        int length = pieceTable.length();
        PieceDescriptor[] pieces = new PieceDescriptor[length];
        int x = 0;
        while (x < length) {
            GenericPropertyNode node = pieceTable.getProperty(x);
            pieces[x] = new PieceDescriptor(node.getBytes(), 0);
            ++x;
        }
        this._cpMin = pieces[0].getFilePosition() - fcMin;
        x = 0;
        while (x < pieces.length) {
            int start = pieces[x].getFilePosition() - fcMin;
            if (start < this._cpMin) {
                this._cpMin = start;
            }
            ++x;
        }
        x = 0;
        while (x < pieces.length) {
            int start = pieces[x].getFilePosition();
            GenericPropertyNode node = pieceTable.getProperty(x);
            int nodeStartChars = node.getStart();
            int nodeEndChars = node.getEnd();
            boolean unicode = pieces[x].isUnicode();
            int multiple = 1;
            if (unicode) {
                multiple = 2;
            }
            int textSizeChars = nodeEndChars - nodeStartChars;
            int textSizeBytes = textSizeChars * multiple;
            byte[] buf = new byte[textSizeBytes];
            System.arraycopy(documentStream, start, buf, 0, textSizeBytes);
            this._textPieces.add(new TextPiece(nodeStartChars, nodeEndChars, buf, pieces[x], node.getStart()));
            ++x;
        }
        Collections.sort(this._textPieces);
        this._textPiecesFCOrder = new ArrayList(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public List getTextPieces() {
        return this._textPieces;
    }

    public void add(TextPiece piece) {
        this._textPieces.add(piece);
        this._textPiecesFCOrder.add(piece);
        Collections.sort(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public byte[] writeTo(HWPFOutputStream docStream) throws IOException {
        PlexOfCps textPlex = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int size = this._textPieces.size();
        int x = 0;
        while (x < size) {
            TextPiece next = (TextPiece)this._textPieces.get(x);
            PieceDescriptor pd = next.getPieceDescriptor();
            int offset = docStream.getOffset();
            int mod = offset % 512;
            if (mod != 0) {
                mod = 512 - mod;
                byte[] buf = new byte[mod];
                docStream.write(buf);
            }
            pd.setFilePosition(docStream.getOffset());
            docStream.write(next.getRawBytes());
            int nodeStart = next.getStart();
            int nodeEnd = next.getEnd();
            textPlex.addProperty(new GenericPropertyNode(nodeStart, nodeEnd, pd.toByteArray()));
            ++x;
        }
        return textPlex.toByteArray();
    }

    public int adjustForInsert(int listIndex, int length) {
        int size = this._textPieces.size();
        TextPiece tp = (TextPiece)this._textPieces.get(listIndex);
        tp.setEnd(tp.getEnd() + length);
        int x = listIndex + 1;
        while (x < size) {
            tp = (TextPiece)this._textPieces.get(x);
            tp.setStart(tp.getStart() + length);
            tp.setEnd(tp.getEnd() + length);
            ++x;
        }
        return length;
    }

    public boolean equals(Object o) {
        TextPieceTable tpt = (TextPieceTable)o;
        int size = tpt._textPieces.size();
        if (size == this._textPieces.size()) {
            int x = 0;
            while (x < size) {
                if (!tpt._textPieces.get(x).equals(this._textPieces.get(x))) {
                    return false;
                }
                ++x;
            }
            return true;
        }
        return false;
    }

    public int getCharIndex(int bytePos) {
        return this.getCharIndex(bytePos, 0);
    }

    public int getCharIndex(int bytePos, int startCP) {
        int charCount = 0;
        bytePos = this.lookIndexForward(bytePos);
        Iterator iterator = this._textPieces.iterator();
        while (iterator.hasNext()) {
            TextPiece tp = (TextPiece)iterator.next();
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            int bytesLength = tp.bytesLength();
            int pieceEnd = pieceStart + bytesLength;
            int toAdd = bytePos < pieceStart || bytePos > pieceEnd ? bytesLength : (bytePos > pieceStart && bytePos < pieceEnd ? bytePos - pieceStart : bytesLength - (pieceEnd - bytePos));
            charCount = tp.isUnicode() ? (charCount += toAdd / 2) : (charCount += toAdd);
            if (bytePos >= pieceStart && bytePos <= pieceEnd && charCount >= startCP) break;
        }
        return charCount;
    }

    public int lookIndexForward(int bytePos) {
        Iterator iterator = this._textPiecesFCOrder.iterator();
        while (iterator.hasNext()) {
            TextPiece tp = (TextPiece)iterator.next();
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos > pieceStart + tp.bytesLength()) continue;
            if (pieceStart <= bytePos) break;
            bytePos = pieceStart;
            break;
        }
        return bytePos;
    }

    public int lookIndexBackward(int bytePos) {
        int lastEnd = 0;
        Iterator iterator = this._textPiecesFCOrder.iterator();
        while (iterator.hasNext()) {
            TextPiece tp = (TextPiece)iterator.next();
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos > pieceStart + tp.bytesLength()) {
                lastEnd = pieceStart + tp.bytesLength();
                continue;
            }
            if (pieceStart <= bytePos) break;
            bytePos = lastEnd;
            break;
        }
        return bytePos;
    }

    public boolean isIndexInTable(int bytePos) {
        Iterator iterator = this._textPiecesFCOrder.iterator();
        while (iterator.hasNext()) {
            TextPiece tp = (TextPiece)iterator.next();
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos > pieceStart + tp.bytesLength()) continue;
            return pieceStart <= bytePos;
        }
        return false;
    }

    private static class FCComparator
    implements Comparator {
        private FCComparator() {
        }

        public int compare(Object itextPiece, Object itextPiece1) {
            TextPiece textPiece = (TextPiece)itextPiece;
            TextPiece textPiece1 = (TextPiece)itextPiece1;
            if (textPiece.getPieceDescriptor().fc > textPiece1.getPieceDescriptor().fc) {
                return 1;
            }
            if (textPiece.getPieceDescriptor().fc < textPiece1.getPieceDescriptor().fc) {
                return -1;
            }
            return 0;
        }
    }
}

