/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.AutoFilterInfoRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFAutoFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SSCellRange;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSSFSheet
implements Sheet {
    private static final POILogger log;
    private static final int DEBUG;
    public static final int INITIAL_CAPACITY = 20;
    private final InternalSheet _sheet;
    private final TreeMap _rows;
    protected final InternalWorkbook _book;
    protected final HSSFWorkbook _workbook;
    private HSSFPatriarch _patriarch;
    private int _firstrow;
    private int _lastrow;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hssf.usermodel.HSSFSheet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger(clazz);
        DEBUG = POILogger.DEBUG;
    }

    protected HSSFSheet(HSSFWorkbook workbook) {
        this._sheet = InternalSheet.createSheet();
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook workbook, InternalSheet sheet) {
        this._sheet = sheet;
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
        this.setPropertiesFromSheet(sheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook workbook) {
        return new HSSFSheet(workbook, this._sheet.cloneSheet());
    }

    public Workbook getWorkbook() {
        return this._workbook;
    }

    private void setPropertiesFromSheet(InternalSheet sheet) {
        RowRecord row = sheet.getNextRow();
        boolean rowRecordsAlreadyPresent = row != null;
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        CellValueRecordInterface[] cvals = sheet.getValueRecords();
        long timestart = System.currentTimeMillis();
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Time at start of cell creating in HSSF sheet = ", new Long(timestart));
        }
        HSSFRow lastrow = null;
        int i = 0;
        while (i < cvals.length) {
            CellValueRecordInterface cval = cvals[i];
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (hrow == null || hrow.getRowNum() != cval.getRow()) {
                lastrow = hrow = (HSSFRow)this.getRow(cval.getRow());
                if (hrow == null) {
                    if (rowRecordsAlreadyPresent) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRec = new RowRecord(cval.getRow());
                    sheet.addRow(rowRec);
                    hrow = this.createRowFromRecord(rowRec);
                }
            }
            if (log.check(POILogger.DEBUG)) {
                log.log(DEBUG, "record id = " + Integer.toHexString(((Record)((Object)cval)).getSid()));
            }
            hrow.createCellFromRecord(cval);
            if (log.check(POILogger.DEBUG)) {
                log.log(DEBUG, (Object)"record took ", new Long(System.currentTimeMillis() - cellstart));
            }
            ++i;
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"total sheet cell creation took ", new Long(System.currentTimeMillis() - timestart));
        }
    }

    public Row createRow(int rownum) {
        HSSFRow row = new HSSFRow(this._workbook, this, rownum);
        this.addRow(row, true);
        return row;
    }

    private HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this._workbook, this, row);
        this.addRow(hrow, false);
        return hrow;
    }

    public void removeRow(Row row) {
        HSSFRow hrow = (HSSFRow)row;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            HSSFCell xcell = (HSSFCell)cell;
            if (!xcell.isPartOfArrayFormulaGroup()) continue;
            String msg = "Row[rownum=" + row.getRowNum() + "] contains cell(s) included in a multi-cell array formula. You cannot change part of an array.";
            xcell.notifyArrayFormulaChanging(msg);
        }
        if (this._rows.size() > 0) {
            Integer key = new Integer(row.getRowNum());
            HSSFRow removedRow = (HSSFRow)this._rows.remove(key);
            if (removedRow != row) {
                throw new IllegalArgumentException("Specified row does not belong to this sheet");
            }
            if (hrow.getRowNum() == this.getLastRowNum()) {
                this._lastrow = this.findLastRow(this._lastrow);
            }
            if (hrow.getRowNum() == this.getFirstRowNum()) {
                this._firstrow = this.findFirstRow(this._firstrow);
            }
            this._sheet.removeRow(hrow.getRowRecord());
        }
    }

    private int findLastRow(int lastrow) {
        if (lastrow < 1) {
            return 0;
        }
        int rownum = lastrow - 1;
        HSSFRow r = (HSSFRow)this.getRow(rownum);
        while (r == null && rownum > 0) {
            r = (HSSFRow)this.getRow(--rownum);
        }
        if (r == null) {
            return 0;
        }
        return rownum;
    }

    private int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r = (HSSFRow)this.getRow(rownum);
        while (r == null && rownum <= this.getLastRowNum()) {
            r = (HSSFRow)this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return 0;
        }
        return rownum;
    }

    private void addRow(HSSFRow row, boolean addLow) {
        boolean firstRow;
        this._rows.put(new Integer(row.getRowNum()), row);
        if (addLow) {
            this._sheet.addRow(row.getRowRecord());
        }
        boolean bl = firstRow = this._rows.size() == 1;
        if (row.getRowNum() > this.getLastRowNum() || firstRow) {
            this._lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum() || firstRow) {
            this._firstrow = row.getRowNum();
        }
    }

    public Row getRow(int rowIndex) {
        return (HSSFRow)this._rows.get(new Integer(rowIndex));
    }

    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    public int getFirstRowNum() {
        return this._firstrow;
    }

    public int getLastRowNum() {
        return this._lastrow;
    }

    public void addValidationData(DataValidation dataValidation) {
        if (dataValidation == null) {
            throw new IllegalArgumentException("objValidation must not be null");
        }
        HSSFDataValidation hssfDataValidation = (HSSFDataValidation)dataValidation;
        DataValidityTable dvt = this._sheet.getOrCreateDataValidityTable();
        DVRecord dvRecord = hssfDataValidation.createDVRecord(this);
        dvt.addDataValidation(dvRecord);
    }

    public void setColumnHidden(short columnIndex, boolean hidden) {
        this.setColumnHidden(columnIndex & 0xFFFF, hidden);
    }

    public boolean isColumnHidden(short columnIndex) {
        return this.isColumnHidden(columnIndex & 0xFFFF);
    }

    public void setColumnWidth(short columnIndex, short width) {
        this.setColumnWidth(columnIndex & 0xFFFF, width & 0xFFFF);
    }

    public short getColumnWidth(short columnIndex) {
        return (short)this.getColumnWidth(columnIndex & 0xFFFF);
    }

    public void setDefaultColumnWidth(short width) {
        this.setDefaultColumnWidth(width & 0xFFFF);
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sheet.setColumnHidden(columnIndex, hidden);
    }

    public boolean isColumnHidden(int columnIndex) {
        return this._sheet.isColumnHidden(columnIndex);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this._sheet.setColumnWidth(columnIndex, width);
    }

    public int getColumnWidth(int columnIndex) {
        return this._sheet.getColumnWidth(columnIndex);
    }

    public int getDefaultColumnWidth() {
        return this._sheet.getDefaultColumnWidth();
    }

    public void setDefaultColumnWidth(int width) {
        this._sheet.setDefaultColumnWidth(width);
    }

    public short getDefaultRowHeight() {
        return this._sheet.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return (float)this._sheet.getDefaultRowHeight() / 20.0f;
    }

    public void setDefaultRowHeight(short height) {
        this._sheet.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this._sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    public CellStyle getColumnStyle(int column) {
        short styleIndex = this._sheet.getXFIndexForColAt((short)column);
        if (styleIndex == 15) {
            return null;
        }
        ExtendedFormatRecord xf = this._book.getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this._book);
    }

    public boolean isGridsPrinted() {
        return this._sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this._sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(org.apache.poi.ss.util.Region region) {
        return this._sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL97);
        this.validateArrayFormulas(region);
        return this._sheet.addMergedRegion(region.getFirstRow(), region.getFirstColumn(), region.getLastRow(), region.getLastColumn());
    }

    private void validateArrayFormulas(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int firstColumn = region.getFirstColumn();
        int lastRow = region.getLastRow();
        int lastColumn = region.getLastColumn();
        int rowIn = firstRow;
        while (rowIn <= lastRow) {
            int colIn = firstColumn;
            while (colIn <= lastColumn) {
                CellRangeAddress arrayRange;
                HSSFCell cell;
                HSSFRow row = (HSSFRow)this.getRow(rowIn);
                if (row != null && (cell = (HSSFCell)row.getCell(colIn)) != null && cell.isPartOfArrayFormulaGroup() && (arrayRange = cell.getArrayFormulaRange()).getNumberOfCells() > 1 && (arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()) || arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()))) {
                    String msg = "The range " + region.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                    throw new IllegalStateException(msg);
                }
                ++colIn;
            }
            ++rowIn;
        }
    }

    public void setForceFormulaRecalculation(boolean value) {
        this._sheet.setUncalced(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this._sheet.getUncalced();
    }

    public void setVerticallyCenter(boolean value) {
        this._sheet.getPageSettings().getVCenter().setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        return this.getVerticallyCenter();
    }

    public boolean getVerticallyCenter() {
        return this._sheet.getPageSettings().getVCenter().getVCenter();
    }

    public void setHorizontallyCenter(boolean value) {
        this._sheet.getPageSettings().getHCenter().setHCenter(value);
    }

    public boolean getHorizontallyCenter() {
        return this._sheet.getPageSettings().getHCenter().getHCenter();
    }

    public void setRightToLeft(boolean value) {
        this._sheet.getWindowTwo().setArabic(value);
    }

    public boolean isRightToLeft() {
        return this._sheet.getWindowTwo().getArabic();
    }

    public void removeMergedRegion(int index) {
        this._sheet.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this._sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        CellRangeAddress cra = this.getMergedRegion(index);
        return new Region(cra.getFirstRow(), (short)cra.getFirstColumn(), cra.getLastRow(), (short)cra.getLastColumn());
    }

    public CellRangeAddress getMergedRegion(int index) {
        return this._sheet.getMergedRegionAt(index);
    }

    public Iterator rowIterator() {
        Iterator result = this._rows.values().iterator();
        return result;
    }

    public Iterator iterator() {
        return this.rowIterator();
    }

    InternalSheet getSheet() {
        return this._sheet;
    }

    public void setAlternativeExpression(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b);
    }

    public void setAlternativeFormula(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b);
    }

    public void setAutobreaks(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b);
    }

    public void setDialog(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDialog(b);
    }

    public void setDisplayGuts(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b);
    }

    public void setFitToPage(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b);
    }

    public void setRowSumsBelow(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b);
        record.setAlternateExpression(b);
    }

    public void setRowSumsRight(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    public boolean getAutobreaks() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    public boolean isDisplayZeros() {
        return this._sheet.getWindowTwo().getDisplayZeros();
    }

    public void setDisplayZeros(boolean value) {
        this._sheet.getWindowTwo().setDisplayZeros(value);
    }

    public boolean getFitToPage() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    public void setPrintGridlines(boolean newPrintGridlines) {
        this.getSheet().getPrintGridlines().setPrintGridlines(newPrintGridlines);
    }

    public PrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this._sheet.getPageSettings().getPrintSetup());
    }

    public Header getHeader() {
        return new HSSFHeader(this._sheet.getPageSettings());
    }

    public Footer getFooter() {
        return new HSSFFooter(this._sheet.getPageSettings());
    }

    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    public void setSelected(boolean sel) {
        this.getSheet().getWindowTwo().setSelected(sel);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean sel) {
        this.getSheet().getWindowTwo().setActive(sel);
    }

    public double getMargin(short margin) {
        return this._sheet.getPageSettings().getMargin(margin);
    }

    public void setMargin(short margin, double size) {
        this._sheet.getPageSettings().setMargin(margin, size);
    }

    private WorksheetProtectionBlock getProtectionBlock() {
        return this._sheet.getProtectionBlock();
    }

    public boolean getProtect() {
        return this.getProtectionBlock().isSheetProtected();
    }

    public short getPassword() {
        return (short)this.getProtectionBlock().getPasswordHash();
    }

    public boolean getObjectProtect() {
        return this.getProtectionBlock().isObjectProtected();
    }

    public boolean getScenarioProtect() {
        return this.getProtectionBlock().isScenarioProtected();
    }

    public void protectSheet(String password) {
        this.getProtectionBlock().protectSheet(password, true, true);
    }

    public void setZoom(int numerator, int denominator) {
        if (numerator < 1 || numerator > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (denominator < 1 || denominator > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sclRecord = new SCLRecord();
        sclRecord.setNumerator((short)numerator);
        sclRecord.setDenominator((short)denominator);
        this.getSheet().setSCLRecord(sclRecord);
    }

    public short getTopRow() {
        return this._sheet.getTopRow();
    }

    public short getLeftCol() {
        return this._sheet.getLeftCol();
    }

    public void showInPane(short toprow, short leftcol) {
        this._sheet.setTopRow(toprow);
        this._sheet.setLeftCol(leftcol);
    }

    protected void shiftMerged(int startRow, int endRow, int n, boolean isRow) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        int i = 0;
        while (i < this.getNumMergedRegions()) {
            boolean inEnd;
            CellRangeAddress merged = this.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (inStart && inEnd && !HSSFSheet.containsCell(merged, startRow - 1, 0) && !HSSFSheet.containsCell(merged, endRow + 1, 0)) {
                merged.setFirstRow(merged.getFirstRow() + n);
                merged.setLastRow(merged.getLastRow() + n);
                shiftedRegions.add(merged);
                this.removeMergedRegion(i);
                --i;
            }
            ++i;
        }
        Iterator iterator = shiftedRegions.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress region = (CellRangeAddress)iterator.next();
            this.addMergedRegion(region);
        }
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight, true);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight, boolean moveComments) {
        int inc;
        int s;
        if (n < 0) {
            s = startRow;
            inc = 1;
        } else {
            s = endRow;
            inc = -1;
        }
        NoteRecord[] noteRecs = moveComments ? this._sheet.getNoteRecords() : NoteRecord.EMPTY_ARRAY;
        this.shiftMerged(startRow, endRow, n, true);
        this._sheet.getPageSettings().shiftRowBreaks(startRow, endRow, n);
        int rowNum = s;
        while (rowNum >= startRow && rowNum <= endRow && rowNum >= 0 && rowNum < 65536) {
            HSSFRow row2Replace;
            HSSFRow row = (HSSFRow)this.getRow(rowNum);
            if (row != null) {
                this.notifyRowShifting(row);
            }
            if ((row2Replace = (HSSFRow)this.getRow(rowNum + n)) == null) {
                row2Replace = (HSSFRow)this.createRow(rowNum + n);
            }
            row2Replace.removeAllCells();
            if (row != null) {
                if (copyRowHeight) {
                    row2Replace.setHeight(row.getHeight());
                }
                if (resetOriginalRowHeight) {
                    row.setHeight((short)255);
                }
                Iterator cells = row.cellIterator();
                while (cells.hasNext()) {
                    HSSFCell cell = (HSSFCell)cells.next();
                    row.removeCell(cell);
                    CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                    cellRecord.setRow(rowNum + n);
                    row2Replace.createCellFromRecord(cellRecord);
                    this._sheet.addValueRecord(rowNum + n, cellRecord);
                    HSSFHyperlink link = (HSSFHyperlink)cell.getHyperlink();
                    if (link == null) continue;
                    link.setFirstRow(link.getFirstRow() + n);
                    link.setLastRow(link.getLastRow() + n);
                }
                row.removeAllCells();
                if (moveComments) {
                    int i = noteRecs.length - 1;
                    while (i >= 0) {
                        HSSFComment comment;
                        NoteRecord nr = noteRecs[i];
                        if (nr.getRow() == rowNum && (comment = (HSSFComment)this.getCellComment(rowNum, nr.getColumn())) != null) {
                            comment.setRow(rowNum + n);
                        }
                        --i;
                    }
                }
            }
            rowNum += inc;
        }
        if (endRow == this._lastrow || endRow + n > this._lastrow) {
            this._lastrow = Math.min(endRow + n, SpreadsheetVersion.EXCEL97.getLastRowIndex());
        }
        if (startRow == this._firstrow || startRow + n < this._firstrow) {
            this._firstrow = Math.max(startRow + n, 0);
        }
        int sheetIndex = this._workbook.getSheetIndex(this);
        short externSheetIndex = this._book.checkExternSheet(sheetIndex);
        FormulaShifter shifter = FormulaShifter.createForRowShift(externSheetIndex, startRow, endRow, n);
        this._sheet.updateFormulasAfterCellShift(shifter, externSheetIndex);
        int nSheets = this._workbook.getNumberOfSheets();
        int i = 0;
        while (i < nSheets) {
            InternalSheet otherSheet = ((HSSFSheet)this._workbook.getSheetAt(i)).getSheet();
            if (otherSheet != this._sheet) {
                short otherExtSheetIx = this._book.checkExternSheet(i);
                otherSheet.updateFormulasAfterCellShift(shifter, otherExtSheetIx);
            }
            ++i;
        }
        this._workbook.getWorkbook().updateNamesAfterCellShift(shifter);
    }

    protected void insertChartRecords(List records) {
        int window2Loc = this._sheet.findFirstRecordLocBySid((short)574);
        this._sheet.getRecords().addAll(window2Loc, records);
    }

    private void notifyRowShifting(HSSFRow row) {
        String msg = "Row[rownum=" + row.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            HSSFCell hcell = (HSSFCell)cell;
            if (!hcell.isPartOfArrayFormulaGroup()) continue;
            hcell.notifyArrayFormulaChanging(msg);
        }
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this.validateColumn(colSplit);
        this.validateRow(rowSplit);
        if (leftmostColumn < colSplit) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (topRow < rowSplit) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(colSplit, rowSplit, topRow, leftmostColumn);
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getSheet().createSplitPane(xSplitPos, ySplitPos, topRow, leftmostColumn, activePane);
    }

    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    public void setDisplayGridlines(boolean show) {
        this._sheet.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this._sheet.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this._sheet.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this._sheet.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this._sheet.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this._sheet.isDisplayRowColHeadings();
    }

    public void setRowBreak(int row) {
        this.validateRow(row);
        this._sheet.getPageSettings().setRowBreak(row, (short)0, (short)255);
    }

    public boolean isRowBroken(int row) {
        return this._sheet.getPageSettings().isRowBroken(row);
    }

    public void removeRowBreak(int row) {
        this._sheet.getPageSettings().removeRowBreak(row);
    }

    public int[] getRowBreaks() {
        return this._sheet.getPageSettings().getRowBreaks();
    }

    public int[] getColumnBreaks() {
        return this._sheet.getPageSettings().getColumnBreaks();
    }

    public void setColumnBreak(int column) {
        this.validateColumn((short)column);
        this._sheet.getPageSettings().setColumnBreak((short)column, (short)0, (short)SpreadsheetVersion.EXCEL97.getLastRowIndex());
    }

    public boolean isColumnBroken(int column) {
        return this._sheet.getPageSettings().isColumnBroken(column);
    }

    public void removeColumnBreak(int column) {
        this._sheet.getPageSettings().removeColumnBreak(column);
    }

    protected void validateRow(int row) {
        int maxrow = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (row > maxrow) {
            throw new IllegalArgumentException("Maximum row number is " + maxrow);
        }
        if (row < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(int column) {
        int maxcol = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        if (column > maxcol) {
            throw new IllegalArgumentException("Maximum column number is " + maxcol);
        }
        if (column < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean fat) {
        this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        EscherAggregate r = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    public Drawing createDrawingPatriarch() {
        if (this._patriarch == null) {
            this._book.createDrawingGroup();
            this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), true);
            EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
            this._patriarch = new HSSFPatriarch(this, agg);
            agg.clear();
            agg.setPatriarch(this._patriarch);
        }
        return this._patriarch;
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this._book.findDrawingGroup();
        if (this._book.getDrawingManager() == null) {
            return null;
        }
        int found = this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        if (found == -1) {
            return null;
        }
        EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
        return agg;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        if (this._patriarch != null) {
            return this._patriarch;
        }
        EscherAggregate agg = this.getDrawingEscherAggregate();
        if (agg == null) {
            return null;
        }
        this._patriarch = new HSSFPatriarch(this, agg);
        agg.setPatriarch(this._patriarch);
        agg.convertRecordsToUserModel();
        return this._patriarch;
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        this.setColumnGroupCollapsed(columnNumber & 0xFFFF, collapsed);
    }

    public void groupColumn(short fromColumn, short toColumn) {
        this.groupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    public void ungroupColumn(short fromColumn, short toColumn) {
        this.ungroupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, true);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, false);
    }

    public void groupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, true);
    }

    public void ungroupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, false);
    }

    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this._sheet.getRowsAggregate().collapseRow(rowIndex);
        } else {
            this._sheet.getRowsAggregate().expandRow(rowIndex);
        }
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sheet.setDefaultColumnStyle(column, ((HSSFCellStyle)style).getIndex());
    }

    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        char defaultChar = '0';
        double fontHeightMultiple = 2.0;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        HSSFWorkbook wb = HSSFWorkbook.create(this._book);
        HSSFDataFormatter formatter = new HSSFDataFormatter();
        HSSFFont defaultFont = (HSSFFont)wb.getFontAt((short)0);
        AttributedString str = new AttributedString("" + defaultChar);
        this.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), frc);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        Iterator it = this.rowIterator();
        block2: while (it.hasNext()) {
            HSSFRow row = (HSSFRow)it.next();
            HSSFCell cell = (HSSFCell)row.getCell(column);
            if (cell == null) continue;
            int colspan = 1;
            int i = 0;
            while (i < this.getNumMergedRegions()) {
                CellRangeAddress region = this.getMergedRegion(i);
                if (HSSFSheet.containsCell(region, row.getRowNum(), column)) {
                    if (!useMergedCells) continue block2;
                    cell = (HSSFCell)row.getCell(region.getFirstColumn());
                    colspan = 1 + region.getLastColumn() - region.getFirstColumn();
                }
                ++i;
            }
            HSSFCellStyle style = (HSSFCellStyle)cell.getCellStyle();
            int cellType = cell.getCellType();
            if (cellType == 2) {
                cellType = cell.getCachedFormulaResultType();
            }
            HSSFFont font = (HSSFFont)wb.getFontAt(style.getFontIndex());
            if (cellType == 1) {
                HSSFRichTextString rt = (HSSFRichTextString)cell.getRichStringCellValue();
                String[] lines = rt.getString().split("\\n");
                int i2 = 0;
                while (i2 < lines.length) {
                    String txt = String.valueOf(lines[i2]) + defaultChar;
                    str = new AttributedString(txt);
                    this.copyAttributes(font, str, 0, txt.length());
                    if (rt.numFormattingRuns() > 0) {
                        int j = 0;
                        while (j < lines[i2].length()) {
                            short idx = rt.getFontAtIndex(j);
                            if (idx != 0) {
                                HSSFFont fnt = (HSSFFont)wb.getFontAt(idx);
                                this.copyAttributes(fnt, str, j, j + 1);
                            }
                            ++j;
                        }
                    }
                    layout = new TextLayout(str.getIterator(), frc);
                    if (style.getRotation() != 0) {
                        AffineTransform trans = new AffineTransform();
                        trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                        trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                        width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    } else {
                        width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    }
                    ++i2;
                }
                continue;
            }
            String sval = null;
            if (cellType == 0) {
                try {
                    sval = formatter.formatCellValue(cell);
                }
                catch (Exception e) {
                    sval = "" + cell.getNumericCellValue();
                }
            } else if (cellType == 4) {
                sval = String.valueOf(cell.getBooleanCellValue());
            }
            if (sval == null) continue;
            String txt = String.valueOf(sval) + defaultChar;
            str = new AttributedString(txt);
            this.copyAttributes(font, str, 0, txt.length());
            layout = new TextLayout(str.getIterator(), frc);
            if (style.getRotation() != 0) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                continue;
            }
            width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
        }
        if (width != -1.0) {
            if ((width *= 256.0) > 32767.0) {
                width = 32767.0;
            }
            this._sheet.setColumnWidth(column, (short)width);
        }
    }

    private void copyAttributes(HSSFFont font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    public Comment getCellComment(int row, int column) {
        HSSFRow r = (HSSFRow)this.getRow(row);
        if (r != null) {
            HSSFCell c = (HSSFCell)r.getCell(column);
            if (c != null) {
                return (HSSFComment)c.getCellComment();
            }
            return HSSFCell.findCellComment(this._sheet, row, column);
        }
        return null;
    }

    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this);
    }

    public String getSheetName() {
        HSSFWorkbook wb = (HSSFWorkbook)this.getWorkbook();
        int idx = wb.getSheetIndex(this);
        return wb.getSheetName(idx);
    }

    private CellRange getCellRange(CellRangeAddress range) {
        int firstRow = range.getFirstRow();
        int firstColumn = range.getFirstColumn();
        int lastRow = range.getLastRow();
        int lastColumn = range.getLastColumn();
        int height = lastRow - firstRow + 1;
        int width = lastColumn - firstColumn + 1;
        ArrayList<HSSFCell> temp = new ArrayList<HSSFCell>(height * width);
        int rowIn = firstRow;
        while (rowIn <= lastRow) {
            int colIn = firstColumn;
            while (colIn <= lastColumn) {
                HSSFCell cell;
                HSSFRow row = (HSSFRow)this.getRow(rowIn);
                if (row == null) {
                    row = (HSSFRow)this.createRow(rowIn);
                }
                if ((cell = (HSSFCell)row.getCell(colIn)) == null) {
                    cell = (HSSFCell)row.createCell(colIn);
                }
                temp.add(cell);
                ++colIn;
            }
            ++rowIn;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.poi.hssf.usermodel.HSSFCell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SSCellRange.create(firstRow, firstColumn, height, width, temp, clazz);
    }

    public CellRange setArrayFormula(String formula, CellRangeAddress range) {
        int sheetIndex = this._workbook.getSheetIndex(this);
        Ptg[] ptgs = HSSFFormulaParser.parse(formula, this._workbook, 2, sheetIndex);
        CellRange cells = this.getCellRange(range);
        Iterator iterator = cells.iterator();
        while (iterator.hasNext()) {
            HSSFCell c = (HSSFCell)iterator.next();
            c.setCellArrayFormula(range);
        }
        HSSFCell mainArrayFormulaCell = (HSSFCell)cells.getTopLeftCell();
        FormulaRecordAggregate agg = (FormulaRecordAggregate)mainArrayFormulaCell.getCellValueRecord();
        agg.setArrayFormula(range, ptgs);
        return cells;
    }

    public CellRange removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        CellValueRecordInterface rec = ((HSSFCell)cell).getCellValueRecord();
        if (!(rec instanceof FormulaRecordAggregate)) {
            String ref = new CellReference(cell).formatAsString();
            throw new IllegalArgumentException("Cell " + ref + " is not part of an array formula.");
        }
        FormulaRecordAggregate fra = (FormulaRecordAggregate)rec;
        CellRangeAddress range = fra.removeArrayFormula(cell.getRowIndex(), cell.getColumnIndex());
        CellRange result = this.getCellRange(range);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            c.setCellType(3);
        }
        return result;
    }

    public DataValidationHelper getDataValidationHelper() {
        return new HSSFDataValidationHelper(this);
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        int sheetIndex;
        InternalWorkbook workbook = this._workbook.getWorkbook();
        NameRecord name = workbook.getSpecificBuiltinRecord((byte)13, (sheetIndex = this._workbook.getSheetIndex(this)) + 1);
        if (name == null) {
            name = workbook.createBuiltInName((byte)13, sheetIndex + 1);
        }
        Area3DPtg ptg = new Area3DPtg(range.getFirstRow(), range.getLastRow(), range.getFirstColumn(), range.getLastColumn(), false, false, false, false, sheetIndex);
        name.setNameDefinition(new Ptg[]{ptg});
        AutoFilterInfoRecord r = new AutoFilterInfoRecord();
        int numcols = 1 + range.getLastColumn() - range.getFirstColumn();
        r.setNumEntries((short)numcols);
        int idx = this._sheet.findFirstRecordLocBySid((short)512);
        this._sheet.getRecords().add(idx, r);
        HSSFPatriarch p = (HSSFPatriarch)this.createDrawingPatriarch();
        int col = range.getFirstColumn();
        while (col <= range.getLastColumn()) {
            p.createComboBox(new HSSFClientAnchor(0, 0, 0, 0, (short)col, range.getFirstRow(), (short)(col + 1), range.getFirstRow() + 1));
            ++col;
        }
        return new HSSFAutoFilter(this);
    }
}

