/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.ss.usermodel;

/**
 * The enumeration value indicating the style of fill pattern being used for a cell format.
 *
 */
public class FillPatternType {

	/** No background */
	public static final FillPatternType NO_FILL = new FillPatternType(0);

	/** Solidly filled */
	public static final FillPatternType SOLID_FOREGROUND = new FillPatternType(1);

	/** Small fine dots */
	public static final FillPatternType FINE_DOTS = new FillPatternType(2);

	/** Wide dots */
	public static final FillPatternType ALT_BARS = new FillPatternType(3);

	/** Sparse dots */
	public static final FillPatternType SPARSE_DOTS = new FillPatternType(4);

	/** Thick horizontal bands */
	public static final FillPatternType THICK_HORZ_BANDS = new FillPatternType(5);

	/** Thick vertical bands */
	public static final FillPatternType THICK_VERT_BANDS = new FillPatternType(6);

	/** Thick backward facing diagonals */
	public static final FillPatternType THICK_BACKWARD_DIAG = new FillPatternType(7);

	/** Thick forward facing diagonals */
	public static final FillPatternType THICK_FORWARD_DIAG = new FillPatternType(8);

	/** Large spots */
	public static final FillPatternType BIG_SPOTS = new FillPatternType(9);

	/** Brick-like layout */
	public static final FillPatternType BRICKS = new FillPatternType(10);

	/** Thin horizontal bands */
	public static final FillPatternType THIN_HORZ_BANDS = new FillPatternType(11);

	/** Thin vertical bands */
	public static final FillPatternType THIN_VERT_BANDS = new FillPatternType(12);

	/** Thin backward diagonal */
	public static final FillPatternType THIN_BACKWARD_DIAG = new FillPatternType(13);

	/** Thin forward diagonal */
	public static final FillPatternType THIN_FORWARD_DIAG = new FillPatternType(14);

	/** Squares */
	public static final FillPatternType SQUARES = new FillPatternType(15);

	/** Diamonds */
	public static final FillPatternType DIAMONDS = new FillPatternType(16);

	/** Less Dots */
	public static final FillPatternType LESS_DOTS = new FillPatternType(17);

	/** Least Dots */
	public static final FillPatternType LEAST_DOTS = new FillPatternType(18);

	public FillPatternType(int i) {
		ordinal = i;
	}

	private int ordinal;

	public int getOrdinal() {
		return ordinal;
	}

	public static FillPatternType[] values() {
		return new FillPatternType[] { NO_FILL, SOLID_FOREGROUND, FINE_DOTS,
				ALT_BARS, SPARSE_DOTS, THICK_HORZ_BANDS, THICK_VERT_BANDS,
				THICK_BACKWARD_DIAG, THICK_FORWARD_DIAG, BIG_SPOTS, BRICKS,
				THIN_HORZ_BANDS, THIN_VERT_BANDS, THIN_BACKWARD_DIAG,
				THIN_FORWARD_DIAG, SQUARES, DIAMONDS, LESS_DOTS, LEAST_DOTS };
	}
}
