#include <gtk/gtk.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>

#include "http.h"
#include "cookie.h"
#include "chrome.h"
#include "playerstatus.h"

#include "nicolive_comment.h"
#include "rtmpstream.h"

GtkWidget *comment_view;

typedef struct {
    gint no;
    gchar *user;
    gboolean premium;
    gchar *comment;
} Comment;

enum
{
    COMMENT_NO,
    USER,
    PREMIUM,
    COMMENT,
    N_COLUMNS
};

CHAT_INFO *info;

int comment_callback(CHAT_COMMENT* cmt, void *data)
{
//    printf("[%d-%s] %s\n",(*cmt).no,(*cmt).user_id,(*cmt).contents);
    GtkListStore *store;
    GtkTreeIter iter;
    
    
    
    store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(comment_view)));
    
    gtk_list_store_append(store, &iter);
    gtk_list_store_set(store, &iter,
                       COMMENT_NO, (*cmt).no,
                       USER, (*cmt).user_id,
                       PREMIUM, TRUE,
                       COMMENT, (*cmt).contents,
                       -1);//例外発生箇所
}

static void
send (GtkWidget *widget,
         gpointer   data)
{
    nicolive_comment_send( info, (char*) gtk_entry_get_text(GTK_ENTRY(data)));
    //printf("[SEND] %s\n", );
}

static void
connect (GtkWidget *widget,
             gpointer   data)
{
    const char* host = "watch.live.nicovideo.jp";
    /*const*/ char path[64] = "/api/getplayerstatus?v="; //34文字かな？余裕を持って６４。

    strcat(path, (char*) gtk_entry_get_text(GTK_ENTRY(data)));

    
    char * user_session = get_user_session(0);
    char usr_s_cookie[128] = "user_session=";
    strcat(usr_s_cookie, user_session);
    
    HTTP *session = http_open(host, path, 80);
    
    http_request(session, HTTP_GET, usr_s_cookie, "Mozilla/5.0", 0);
    
    //http_retrieve(session);
    char* header;
    char* contents;
    
    //領域確保
    header = (char *)malloc(sizeof(char) * 1024);
    contents = (char *)malloc(sizeof(char) * 8192);
    
    http_retrieve_text(session, header, contents);
    
    http_close(session);
    
    //    printf("HTTP done\n");
    
    NICO_LIVE *broadcast = new_nico_live(contents);
    
    //
    
    printf("放送タイトル:%s\n説明:%s\n放送主:%s\n",(*broadcast).title,(*broadcast).description,(*broadcast).owner_name);
    //printf("コメ鯖:%s\nポート:%d\nスレッド:%d\n",(*broadcast).msg_addr,(*broadcast).msg_port,(*broadcast).thread);
    
    /*外部プレーヤー*/
    
    RtmpStream* stream = n_RtmpStream(broadcast->url, broadcast->contents, broadcast->ticket);
    open_Stream(stream);
    
    //一旦クリア
    memset(path, 0, sizeof(char)*64);
    memset(header, 0, malloc_size(header));
    memset(contents, 0, malloc_size(contents));
    //
    
    info = nicolive_comment_open((*broadcast).msg_addr, (*broadcast).msg_port, (*broadcast).thread, comment_callback, broadcast);
    
    
    sprintf(path, "/api/getpostkey?thread=%d&block_no=%d", (*broadcast).thread, 1);
    
    session = http_open("live.nicovideo.jp", path, 80);
    http_request(session, HTTP_GET, usr_s_cookie, "Mozilla/5.0", 0);
    http_retrieve_text(session, header, contents);
    
    printf("%s\n", contents + 8);
    (*info).postkey = contents + 8;
    http_close(session);
    

//    d_RtmpStream(stream);
    
 /*   sleep(1000);
    
    nicolive_comment_close(info);
    
    
    nico_live_close(broadcast);
    
    free(header);
    free(contents);
 */
    //接続後はボタン無効
    gtk_widget_set_sensitive(widget, FALSE);

}


static GtkTreeViewColumn*
create_column(gint column_id, gchar *title, gboolean is_checkbox)
{
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    gchar *data_attrname;
    
    if (is_checkbox) {
        renderer = gtk_cell_renderer_toggle_new();
        data_attrname = "active";
    }
    else {
        renderer = gtk_cell_renderer_text_new();
        data_attrname = "text";
    }
    column = gtk_tree_view_column_new_with_attributes(title, renderer,
                                                      data_attrname, column_id, NULL);
    gtk_tree_view_column_set_sort_indicator(column, TRUE);
    gtk_tree_view_column_set_sort_column_id(column, column_id);
    
    return column;
}

static GtkWidget*
create_comment_list_view(GtkListStore *store)
{
    GtkWidget *list_view;
    GtkTreeViewColumn *column;
    
    list_view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
    
    column = create_column(COMMENT_NO, "コメ番", FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(list_view), column);
    column = create_column(USER, "ユーザ", FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(list_view), column);
    column = create_column(PREMIUM, "P", TRUE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(list_view), column);
    column = create_column(COMMENT, "コメント", FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(list_view), column);
    
    return list_view;
}

int
main(int argc, char *argv[])
{
    GtkWidget *window, *scrolled_win;
    GtkListStore *store;
    
    GtkWidget *hbox_initial_connect;
    GtkWidget *button_connect;
    GtkWidget *textbox_live_id;
    GtkWidget *vbox;
    GtkWidget *hbox_comment;
    GtkWidget *button_send;
    GtkWidget *textbox_comment;
    
    gtk_init(&argc, &argv);
    
    //ignore abort 6
    signal(SIGABRT, SIG_IGN);
    signal(SIGSEGV, SIG_IGN);
    
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "ぱぁりっぢ+遞信機　α1");
    // ウィンドウのx押されたらプログラム終了
    g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);
    
    /* box作成 */
    vbox = gtk_vbox_new(FALSE, 3);
    gtk_container_add(GTK_CONTAINER(window), vbox);

    
//放送ID入力部
    hbox_initial_connect = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox_initial_connect, TRUE, TRUE, 0);

    textbox_live_id = gtk_entry_new ();
    gtk_box_pack_start(GTK_BOX(hbox_initial_connect), textbox_live_id, TRUE, TRUE, 0);

    //接続ボタン
    button_connect = gtk_button_new_with_label ("接続");
    g_signal_connect (button_connect, "clicked", G_CALLBACK (connect), textbox_live_id);
    gtk_box_pack_start(GTK_BOX(hbox_initial_connect), button_connect, TRUE, FALSE, 0);
//放送ID入力部　おしまい
    
//コメビュ部
    scrolled_win = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_AUTOMATIC);
    gtk_widget_set_usize (scrolled_win, 512, 384);
    gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, TRUE, TRUE, 0);

    
    store = gtk_list_store_new(N_COLUMNS, G_TYPE_INT, G_TYPE_STRING,
                               G_TYPE_BOOLEAN, G_TYPE_STRING);
    comment_view = create_comment_list_view(store);
    
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolled_win),
                                           comment_view);
//コメビュ部　おしまい
    
    
    //放送ID入力部
    hbox_comment = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox_comment, TRUE, TRUE, 0);
    
    textbox_comment = gtk_entry_new ();
    gtk_box_pack_start(GTK_BOX(hbox_comment), textbox_comment, TRUE, TRUE, 0);
    
    //接続ボタン
    button_send = gtk_button_new_with_label ("送信");
    g_signal_connect (button_send, "clicked", G_CALLBACK (send), textbox_comment);
    gtk_box_pack_start(GTK_BOX(hbox_comment), button_send, TRUE, FALSE, 0);
    //放送ID入力部　おしまい
    

    gtk_widget_show_all(window);
    gtk_main();
    return 0;
}