<?php
/**
 * ポスター系Ajax通信用コントローラ
 *
 * @author pippine
 *
 */
class AjaxPosterController extends AppController {

	public $uses = array("Poster");
	public $components = array("HtmlTagCheck");

	public function directoryCheck() {
		$message = "";
		$error = false;

		if (empty($this->data['directory'])) {
			$message = "パスを入力してください";
			$error = true;
		} else {
			$member = $this->getMember();
			if ($this->Poster->findByMemberIdAndDirectory($member['Member']['id'], $this->data['directory'])) {
				$message = "ご指定のパスは登録済みです";
				$error = true;
			} else {
				$message = "ご指定のパスは登録可能です</font>";
			}
		}
		$this->set("error", $error);
		$this->set("message", $message);
		$this->render('directory_check','ajax');
	}

	public function upload() {
		if (!$this->data['Poster']['upload_file'] || $this->data['Poster']['upload_file']['error'] == 4) {
			$this->set('error','アップロードするファイルを選択してください');
			$this->render('upload','ajax');
		} else if ($this->data['Poster']['upload_file']['error'] == 1) {
			$this->set('error','ファイルのサイズが大きすぎます');
			$this->render('upload','ajax');
		} else {
			if ($this->data['Poster']['upload_file']['type'] != 'image/jpeg' && $this->data['Poster']['upload_file']['type'] != 'image/pjpeg') {
				$this->set('error','アップロードできる画像は JPEG のみです');
				$this->render('upload','ajax');
			} else {
				$fileName = "";
				$member = $this->getMember();
				$filename = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
				if (copy($this->data['Poster']['upload_file']['tmp_name'], WWW_ROOT.$filename)) {
					unlink($this->data['Poster']['upload_file']['tmp_name']);
				}
				$this->set('filename', $filename.'?'.rand());
				$this->render('upload','ajax');
			}
		}
	}

	public function previewTagCheck($target) {
		$title = $this->data[$target];
		$this->set("cleanHtml", $this->HtmlTagCheck->removeForbiddenTag($title, 1));
		$this->set("cleanHtml", $title);
		$this->render("preview_tag_check", "ajax");
	}

	public function addParts() {
		$html = $this->data["html"];
		$index = $this->data["index"];
		$partsType = $this->data["partsType"];
		$partsHtml = "";

		if ($partsType == "br") {
			$partsHtml = $partsHtml.'<div id="parts_'.$index.'"><br/></div>';
		} else if ($partsType == "hr") {
			$partsHtml = $partsHtml.'<div id="parts_'.$index.'"><hr/></div>';
		} else if ($partsType == "strline") {
			$style = ' style="font-size:'.$this->data["strline_size"].'px; color:'.$this->data["strline_color"].'; text-align:'.$this->data["strline_align"].'; font-weight:'.$this->data["strline_bold"].';" ';
			$partsHtml = $partsHtml.'<div id="parts_'.$index.'"'.$style.'>'.$this->data["strline"].'</div>';
		} else if ($partsType == "header") {
			$style = ' style="font-size:'.$this->data["header_size"].'px; font-weight:'.$this->data["header_bold"].';" ';
			$partsHtml = $partsHtml.
					'<div id="parts_'.$index.'"'.$style.'>'.
					'<table width="100%" border="0" cellspacing="5" cellpadding="0">'.
						'<tr><td width="30%" valign="top">'.
							'<table width="100%" border="0" cellspacing="5" cellpadding="0">'.
								'<tr><td width="5" bgcolor="#0000FF"><br /></td>'.
								'<td>'.$this->data["header_str"].'</td></tr>'.
							'</table>'.
						'</td></tr>'.
					'</table>'.
					'</div>';
		} else if ($partsType == "table") {
			$titleList = $this->data["table_title"];
			$contentList = $this->data["table_content"];
			$rowCount = count($titleList);
			$border = $this->data["border"];
			$tableStyle = '';
			$thStyle = '';
			$tdStyle = '';
			if ($border == "border") {
				$tableStyle = 'border: 1px #E3E3E3 solid; border-collapse: collapse; border-spacing: 0;';
				$thStyle = 'padding: 5px; border: #E3E3E3 solid; border-width: 0 0 1px 1px; background: #F5F5F5; font-weight: bold; line-height: 120%; text-align: center;';
				$tdStyle = 'padding: 5px; border: 1px #E3E3E3 solid; border-width: 0 0 1px 1px;';
			}
			$partsHtml = $partsHtml.'<div id="parts_'.$index.'"><table style="'.$tableStyle.'">';
			for ($i=0; $i<$rowCount; $i++) {
				if ($titleList[$i] == "" && $contentList[$i] == "") {
					continue;
				}
				$partsHtml = $partsHtml.
					'<tr><th style="'.$thStyle.'">'.$titleList[$i].'</th>'.
					'<td style="'.$tdStyle.'">'.$contentList[$i].'</td></tr>';
			}
			$partsHtml = $partsHtml.'</table></div>';
		}

		$this->set("partsHtml", $html.$partsHtml);
		$this->render('parts_html','ajax');
	}

	public function removeParts() {
		$html = $this->data["html"];
		$index = $this->data["index"];
		$this->set("partsHtml", preg_replace('/<div id="parts_'.$index.'".*?<\/div>/', '', $html));
		$this->render('parts_html','ajax');
	}

}