<?php
/**
 * メンバートップ系Ajax通信用コントローラ
 *
 * @author tsuuru
 *
 */
class AjaxTopController extends AppController {

	public $uses = array("Top");

	public function upload() {
		if (!$this->data['Top']['upload_file'] || $this->data['Top']['upload_file']['error'] == 4) {
			$this->set('error','アップロードするファイルを選択してください');
			$this->render('upload','ajax');
		} else if ($this->data['Top']['upload_file']['error'] == 1) {
			$this->set('error','ファイルのサイズが大きすぎます');
			$this->render('upload','ajax');
		} else {
			if ($this->data['Top']['upload_file']['type'] != 'image/jpeg' && $this->data['Top']['upload_file']['type'] != 'image/pjpeg') {
				$this->set('error','アップロードできる画像は JPEG のみです');
				$this->render('upload','ajax');
			} else {
				$fileName = "";
				$member = $this->getMember();
				$filename = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';
				if (copy($this->data['Top']['upload_file']['tmp_name'], WWW_ROOT.$filename)) {
					unlink($this->data['Top']['upload_file']['tmp_name']);
				}
				$this->set('filename', $filename.'?'.rand());
				$this->render('upload','ajax');
			}
		}
	}

}