<?php
App::uses('Controller', 'Controller');

/**
 * primocco基底コントローラ
 *
 * @author pippine
 *
 */
abstract class AppController extends Controller {

	public $uses = array("System");
	public $layout = "main_layout";

	protected $SESSION_KEY_MEMBER = "member";
	protected $SESSION_KEY_MEMBER_INFO = "member_info";
	protected $SESSION_KEY_POSTER = "poster";
	protected $SESSION_KEY_TOP = "top";


	public function badRequestError() {
		$this->redirect("/primoccoError/badRequestError");
	}

	public function notLoginError() {
		$this->redirect("/primoccoError/notLoginError");
	}

	protected function getMember() {
		return $this->Session->read("member");
	}
	protected function getMemberInfo() {
		return $this->Session->read("member_info");
	}
	protected function sessionDestroy() {
		$this->Session->delete($this->SESSION_KEY_MEMBER);
		$this->Session->delete($this->SESSION_KEY_MEMBER_INFO);
		$this->Session->delete($this->SESSION_KEY_POSTER);
		$this->Session->delete($this->SESSION_KEY_TOP);
		$this->Session->destroy();
	}

}
