<?php
require_once(ROOT.DS.APP_DIR.'/Vendor/HTMLPurifier/HTMLPurifier.auto.php');
require_once('simple_html_dom.php');

/**
 * HTMLタグに関する各種機能を提供するクラス
 * HTMLPurifierのラッパークラス
 *
 * @author pippine
 *
 */
class HtmlTagCheckComponent extends Component {

	// 許可タグ一覧
	private $ALLOWED_TAG = array(
		'1' => 'b,br,center,strong,hr[align|noshade|size|width],font[color|face|size],div[id|style],table[align|bgcolor|border|cellpadding|cellspacing|frame|rules|width|style],tr[align|bgcolor|charoff|valign],th[abbr|align|bgcolor|charoff|colspan|height|nowrap|rowspan|valign|width|style],td[abbr|align|bgcolor|charoff|colspan|height|nowrap|rowspan|valign|width|style]',
		'2' => 'b,br,center,strong,hr[align|noshade|size|width],font[color|face|size],table[align|bgcolor|border|cellpadding|cellspacing|frame|rules|width],tr[align|bgcolor|charoff|valign],th[abbr|align|bgcolor|charoff|colspan|height|nowrap|rowspan|valign|width],td[abbr|align|bgcolor|charoff|colspan|height|nowrap|rowspan|valign|width]',
		'3' => 'b,center,strong,font[color|face|size]',
	);

	/**
	 * 指定されたタグレベルで許可されていないタグを除去する
	 * （ホワイトリストチェック）
	 *
	 * @param $input 入力HTML
	 * @param $tagLevel タグレベル
	 */
	public function removeForbiddenTag($input, $tagLevel) {
		$hp_conf = HTMLPurifier_Config::createDefault();
		$hp_conf->set('Core.Encoding', 'UTF-8');
		$hp_conf->set('Core.Language', 'ja');
		$hp_conf->set('HTML.Allowed', $this->ALLOWED_TAG[$tagLevel]);
		$hp_conf->set('Attr.EnableID', true);
		$hp_conf->set('Attr.IDPrefix', 'parts_');
		$hp = new HTMLPurifier($hp_conf);
		return $hp->purify($input);
	}

	/**
	 * キャッチコピー編集コントローラーを浄化する
	 *
	 * @param $input 入力HTML
	 */
	public function purifyCatchCopyCtrl($input) {
		$result='';
		if (empty($input)) {
			return $result;
		}
		$template = file_get_contents(ROOT.DS.APP_DIR."/Template/template_catch_copy_ctrl.txt");
		$dom = str_get_html($input);
		foreach($dom->find('div') as $element) {
			$value=str_replace("div_id" , h($element->id), $template);
			$value=str_replace("plaintext" , h($element->plaintext), $value);
			$result=$result.$value;
		}
		return $result;
	}

	/**
	 * 説明文編集コントローラーを浄化する
	 *
	 * @param $input 入力HTML
	 */
	public function purifyDescriptionCtrl($input) {
		$result='';
		if (empty($input)) {
			return $result;
		}
		$template = file_get_contents(ROOT.DS.APP_DIR."/Template/template_description_ctrl.txt");
		$dom = str_get_html($input);
		foreach($dom->find('div') as $element) {
			$value=str_replace("div_id" , h($element->id), $template);
			$value=str_replace("plaintext" , h($element->plaintext), $value);
			$result=$result.$value;
		}
		return $result;
	}

}