<?php
/**
 * リスト用コントローラ
 *
 * @author pippine
 *
 */
class ListController extends AppController {

	public $uses = array('Category','Poster','Area','Prefecture');
	public $helpers = array('Js');
	var $components = array('RequestHandler');
	var $paginate = array(
			'limit' => 5,
			'fields' => array('title','caption','poster_path','modified'),
			'order' => array('Poster.rank' => 'ASC'),
	);
	public function search() {
		//$category_id = $this->params['pass'][0];
		//$category = $this->Category->findById($category_id);
		//$this->set('category', $category);

		if (!empty($this->params['url']['keyword'])) {
			$keyword = $this->params['url']['keyword'];
			$this->paginate['conditions']['title LIKE']  = "%{$keyword}%";
			$result = $this->paginate('Poster');
			$this->set('viewDataList', $result);
			$this->set('keyword',$keyword);
			//$this->render('search_result');
		} else {
			$this->set('error', '検索キーワードが指定されていません');
			//$this->render('search_result');
		}
		$areaViewList = array();

		$this->set('list',$this->paginate('Poster'));
		$this->set('set_description', $this->params['url']['keyword'] . ' 結果ページ');

        if($this->request->is('ajax')) {
            $this->render('list_pagination');
        }else{
             $this->render('list');
        }

	}

	public function index() {
		if (!array_key_exists(0,$this->params['pass'])){
			$this->set('error', 'categoryが指定されていません');
			$this->render('list');
		}

		$category_id = $this->params['pass'][0];
		$category = $this->Category->findById($category_id);
		$this->set('category', $category);
		$this->paginate['conditions']['category_id'] = $category_id;

		// area系取得
		$areaList = $this->Area->find('all');
		$prefList = $this->Prefecture->find('all');

		$areaViewList = array();
		foreach ($areaList as $area) {
			$areaViewList[$area['Area']['id']]['name'] = $area['Area']['name'];
		}

		foreach ($prefList as $pref) {
			$areaViewList[$pref['Prefecture']['area_id']]['pref'][$pref['Prefecture']['id']] = $pref['Prefecture']['name'];
		}

		$this->set('areaViewList', $areaViewList);

		// area_id
		if(array_key_exists(1,$this->params['pass'])) {
			$area_id = $this->params['pass'][1];
			$this->set('area_id', $area_id);

			// pref_id
			if(array_key_exists(2,$this->params['pass'])) {
				$perf_id = $this->params['pass'][2];
				if (!is_numeric($perf_id)) {
					$this->set('error', '都道府県が正しく指定されていません');
					$this->render('list');
					return;
				}

				if (!preg_match("/^[1-9]$|^[1-3][0-9]$|^[4][0-7]$/",$perf_id)) {
					$this->set('error', '都道府県が正しく指定されていません');
					$this->render('list');
					return;
				}
				$this->paginate['conditions']['prefecture_id'] = $perf_id;
				$this->set('perf_id', $perf_id);
			} else {
				// inで条件を指定するためperf_id取得
				$prefs = array();
				foreach ($prefList as $pref) {
					if ($pref['Prefecture']['area_id'] == $area_id) {
						$prefs[] = $pref['Prefecture']['id'];
					}
				}
				$this->paginate['conditions']['prefecture_id'] = $prefs;
			}
		}


		$categoryDataList = $this->paginate('Poster');

		if (empty($categoryDataList)){
			$this->set('error', 'ポスターが存在しません');
			$this->render('list');
		}

		$this->set('set_keywords', $category['Category']['name']);
		$this->set('set_description', $category['Category']['name'] . ' 一覧ページ');
		$this->set('viewDataList',$categoryDataList);

		//$this->render('list');
		$this->set('list',$this->paginate('Poster'));

        if($this->request->is('ajax')) {
            $this->render('list_pagination');
        }else{
             $this->render('list');
        }

	}

}