<?php
App::uses('Folder', 'Utility');

/**
 * ポスター用コントローラ
 *
 * @author tsuuru
 *
 */
class PosterController extends AppController {

	public $components = array("HtmlCreator", "HtmlTagCheck", "Security" => array("validatePost" => false), "Image", "PrimoccoFacebook");
	public $uses = array("Poster");

	public function beforeFilter() {
		// ログインチェック
		if (!$this->Session->read($this->SESSION_KEY_MEMBER)) {
			$this->notLoginError();
		}
		$this->Security->requireAuth('registerImage', 'registerHtml', 'confirm', 'create', 'editImage', 'editHtml', 'backRegisterImage', 'backRegisterHtml', 'delete');
		$this->Security->requirePost('registerImage', 'registerHtml', 'confirm', 'create', 'editImage', 'editHtml', 'backRegisterImage', 'backRegisterHtml');
		$this->Security->blackHoleCallback = 'badRequestError';
	}

	//とりあえず、動く用に残しておきます。 → こちらを本番で使いますｗ
	public function index($edit_type = null) {

		$this->Session->delete($this->SESSION_KEY_POSTER);
		// 添付画像の削除
		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}
		$count = $this->Poster->find('count', array(
				'conditions' => array('Poster.member_id' => $member['Member']['id'])
		));

		if (($edit_type != 0 && $edit_type != 1) || $count >= 6) {
			if($count >= 6) {
				$this->set("message", "登録数が最大です");
			}
			$this->render("poster_error");
			return;
		}
		$this->set("editType", $edit_type);
		$this->render("image_regist");
	}

	/**
	 * 画像登録画面へ遷移する
	 */
	public function registerImage($edit_type = null) {
		//セッション情報の削除
		$this->Session->delete($this->SESSION_KEY_POSTER);
		// 添付画像の削除
		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}
		$count = $this->Poster->find('count', array(
			'conditions' => array('Poster.member_id' => $member['Member']['id'])
		));

		if (($edit_type != 0 && $edit_type != 1) || $count >= 6) {
			if($count >= 6) {
				$this->set("message", "登録数が最大です");
			}
			$this->render("poster_error");
			return;
		}
		$this->set("editType", $edit_type);
		$this->render("image_regist");
	}

	/**
	 * HTML登録画面へ遷移する
	 */
	public function registerHtml() {

		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';


		$imageFlag = $this->request->data['image_flag'];

		if ($imageFlag == 1) {
			if (!file_exists(WWW_ROOT.$imagePath)) {
				$this->set('errorImage','ファイルをアップロードしてください');
				$this->set("editType", $this->data['Poster']['edit_type']);
				$this->render("image_regist");
				return;
			}
			$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImage($imagePath));
		} else {
			$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImageEmpty());
		}

		$this->set("domain", $member['Member']['domain']);
		$this->set("imageFlag", h($imageFlag));
		$this->set("editType", $this->data['Poster']['edit_type']);
		$this->set("categoryList", $this->Poster->Category->find("list"));
		$this->set("prefectureList", $this->Poster->Prefecture->find("list"));

		if ($this->data['Poster']['edit_type'] == 0) {
			$this->render("html_regist_standard");
		} else {
			$this->render("html_regist_advanced");
		}
	}

	/**
	 * 確認画面へ遷移する
	 */
	public function confirm() {

		if (!empty($this->request->data)) {

			$isError = false;
			$this->set("errorParts", "");
			if ($this->request->data['Poster']['image_flag'] != 1 && empty($this->data["Poster"]["catch_copy"]) && empty($this->data["Poster"]["description"])) {
				$this->set("errorParts", "画像を登録しない場合は、キャッチコピーまたは説明文のどちらかを入力してください");
				$isError = true;
			}

			$this->set("categoryList", $this->Poster->Category->find("list"));
			$this->set("prefectureList", $this->Poster->Prefecture->find("list"));

			$member = $this->getMember();
			if ($this->Poster->saveAll($this->request->data, array('validate' => 'only')) && $isError == false) {

				$input = $this->data;
				$poster_url = "members/".$member['Member']['domain']."/poster/".$this->data["Poster"]["directory"];

				$input["Poster"]["member_id"] = $member['Member']['id'];
				$input["Poster"]["poster_path"] = $poster_url;
				$input["Poster"]["title"] = h($this->data["Poster"]["title"]);
				$input["Poster"]["caption"] = h($this->data["Poster"]["caption"]);
				$input["Poster"]["catch_copy"] = $this->HtmlTagCheck->removeForbiddenTag($this->data["Poster"]["catch_copy"], 1);
				$input["Poster"]["description"] = $this->HtmlTagCheck->removeForbiddenTag($this->data["Poster"]["description"], 1);
				if ($this->data["Poster"]["edit_type"] == 0) {
					$input["Poster"]["catch_copy_ctrl"] = $this->HtmlTagCheck->purifyCatchCopyCtrl($this->data["Poster"]["catch_copy_ctrl"]);
					$input["Poster"]["description_ctrl"] = $this->HtmlTagCheck->purifyDescriptionCtrl($this->data["Poster"]["description_ctrl"]);
				}
				$this->Session->write($this->SESSION_KEY_POSTER, $input);

				$this->set("tmp_url", $poster_url);
				$this->set("tmp_catch_copy", $input["Poster"]["catch_copy"]);
				$this->set("tmp_description", $input["Poster"]["description"]);
				if ($this->request->data['Poster']['image_flag'] == 1) {
					$this->set("tmp_image", '<img src="'.Router::url('/tmp/'.$member['Member']['domain'].'_poster_image.jpg', true).'" width="100%"/>');
				} else {
					$this->set("tmp_image", "");
				}

				$this->render('poster_confirm');
			} else {
				$imageFlag = $this->request->data['Poster']['image_flag'];
				$this->set("domain", $member['Member']['domain']);
				$this->set("imageFlag", h($imageFlag));
				$this->set("editType", $this->data['Poster']['edit_type']);
				$this->set("catch_copy", $this->request->data['Poster']['catch_copy']);
				if ($this->data["Poster"]["edit_type"] == 0) {
					$this->set("catch_copy_ctrl", $this->request->data['Poster']['catch_copy_ctrl']);
					$this->set("description_ctrl", $this->request->data['Poster']['description_ctrl']);
				}
				$this->set("description", $this->request->data['Poster']['description']);
				if ($imageFlag == 1) {
					$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
					$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImage($imagePath));
				} else {
					$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImageEmpty());
				}

				if ($this->data["Poster"]["edit_type"] == 0) {
					$this->render("html_regist_standard");
				} else {
					$this->render("html_regist_advanced");
				}
			}
		}
	}

	/**
	 * ページを生成する
	 */
	public function create() {

		// Poster情報の取得
		$poster = $this->Session->read($this->SESSION_KEY_POSTER);

		// Poster情報有無
		if (!empty($poster)) {

			$member = $this->getMember();
			$this->Poster->save($poster);

			// 本番用ディレクトリを作成する
			if (!is_dir(WWW_ROOT.$poster["Poster"]["poster_path"])) {
				mkdir(WWW_ROOT.$poster["Poster"]["poster_path"], 0775, true);
			}

			// HTMLの作成
			$templateHtml = file_get_contents(ROOT.DS.APP_DIR."/Template/poster_template.txt");
			$templateHtml = str_replace("{primocco:template_parts_index:catch_copy}" , $poster["Poster"]["catch_copy"], $templateHtml);
			$templateHtml = str_replace("{primocco:template_parts_index:description}" , $poster["Poster"]["description"], $templateHtml);
			$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
			// 画像チェック
			if ($this->request->data['Poster']['image_flag'] == 1) {

				$imageTag = '<img src="./poster_image.jpg" width="960" />';
				$templateHtml = str_replace("{primocco:template_parts_index:poster_image}" , $imageTag, $templateHtml);
				// 一時フォルダの中身を移動
				if (file_exists(WWW_ROOT.$imagePath)) {
					// 画像のコピー
					copy(WWW_ROOT.$imagePath, WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image.jpg');
					// サムネイルの作成
					$this->Image->resizeJpegFile(WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image.jpg', WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image_thumb.jpg', 180);
					$this->Image->resizeJpegFile(WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image.jpg', WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image_thumb_small.jpg', 110);
				}

				$imageData = array();
				$imageData["Image"]["member_id"]  = $poster["Poster"]["member_id"];
				$imageData["Image"]["page_type"]  = 1;
				$imageData["Image"]["page_id"]    = $this->Poster->id;
				$imageData["Image"]["area"]       = 1;
				$imageData["Image"]["image_name"] = 'poster_image.jpg';
				$this->Poster->Image->save($imageData);
			} else {
				$templateHtml = str_replace("{primocco:template_parts_index:poster_image}" , "", $templateHtml);
				// 画像のコピー
				copy(WWW_ROOT."img/poster_image_thumb.jpg", WWW_ROOT.$poster["Poster"]["poster_path"].'/poster_image_thumb.jpg');
			}

			copy(WWW_ROOT."members/index.html", WWW_ROOT."members/".$member['Member']['domain']."/index.html");
			copy(WWW_ROOT."members/index.html", WWW_ROOT."members/".$member['Member']['domain']."/poster/index.html");

			// HTML作成
			$header = str_replace("{primocco:template_parts_index:url}" , Router::url("/", true), file_get_contents(ROOT.DS.APP_DIR."/Template/template_header.txt"));
			$header = str_replace("{primocco:template_parts_index:pageTitle}", $poster["Poster"]["title"], $header);
			$header = str_replace("{primocco:template_parts_index:posterKeywords}" , $poster["Poster"]["title"], $header);
			$header = str_replace("{primocco:template_parts_index:posterDescription}" , str_replace(array("\r\n","\r","\n"), '', $poster["Poster"]["caption"]), $header);
			$footer = str_replace("{primocco:template_parts_index:url}" , Router::url("/", true), file_get_contents(ROOT.DS.APP_DIR."/Template/template_footer.txt"));
			$fno = fopen(WWW_ROOT.$poster["Poster"]["poster_path"]."/index.html", 'w');
			mb_language('Japanese');
			fwrite($fno, mb_convert_encoding($header, "UTF-8","AUTO"));
			fwrite($fno, mb_convert_encoding($templateHtml, "UTF-8","AUTO"));
			fwrite($fno, mb_convert_encoding($footer, "UTF-8","AUTO"));
			fclose($fno);

			// 添付画像の削除
			if (file_exists(WWW_ROOT.$imagePath)) {
				unlink(WWW_ROOT.$imagePath);
			}

			// facebookへフィード
			$this->PrimoccoFacebook->feedNewPoster(
				$poster["Poster"]["title"],
				$poster["Poster"]["caption"],
				Router::url('/'.$poster["Poster"]["poster_path"].'/', true),
				Router::url('/'.$poster["Poster"]["poster_path"].'/poster_image_thumb.jpg', true)
			);

			// セッションポスター情報削除
			$this->Session->delete($this->SESSION_KEY_POSTER);

			$this->set("poster_url", $poster["Poster"]["poster_path"]);
			$this->render("complete");
		}
	}

	public function editImage($id) {
	}
	public function editHtml($id) {
	}

	/*
	 * 削除確認画面へ遷移する
	 */
	public function delete($id) {

		$member = $this->getMember();
		$posterData = $this->Poster->findByIdAndMemberId($id, $member['Member']['id']);
		if (empty($posterData)) {
			$this->set("message", "ポスター情報を取得できませんでした");
			$this->render("poster_error");
			return;
		}

		if($this->request->isDelete()) {

			$folder = new Folder();
			$folder->delete(WWW_ROOT.$posterData["Poster"]["poster_path"]);
			if(is_dir(WWW_ROOT.$posterData["Poster"]["poster_path"])) {
				if(!@rmdir(WWW_ROOT.$posterData["Poster"]["poster_path"])) {
					$this->set("message", "削除中にエラーが発生しました");
					$this->render("poster_error");
					return;
				}
			}
			if (!empty($posterData['Image'])) {
				$this->Poster->Image->deleteAll(array('Image.page_id' => $id, 'Image.page_type' => 1, 'Image.member_id' => $member['Member']['id']));
			}
			$this->Poster->delete($id);
			$this->redirect(array('controller' => 'Mypage'));
		}

		$this->set("categoryList", $this->Poster->Category->find("list"));
		$this->set("prefectureList", $this->Poster->Prefecture->find("list"));
		$this->set("tmp_catch_copy", $posterData["Poster"]["catch_copy"]);
		$this->set("tmp_description", $posterData["Poster"]["description"]);
		if (empty($posterData['Image'])) {
			$this->set("tmp_image", "");
		} else {
			$this->set("tmp_image", '<img src="'.Router::url('/'.$posterData['Poster']['poster_path'].'/poster_image.jpg', true).'" width="100%"/>');
		}
		$this->request->data = $posterData;
	}

	public function backRegisterImage($editType) {

		$this->Session->delete($this->SESSION_KEY_POSTER);
		// 添付画像の削除
		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}
		if ($editType != 0 && $editType != 1) {
			$this->render("poster_error");
			return;
		}
		$this->set("editType", $editType);
		$this->render("image_regist");
	}

	public function backRegisterHtml() {

		$member = $this->getMember();
		// Poster情報の取得
		$this->request->data = $this->Session->read($this->SESSION_KEY_POSTER);

		$this->set("categoryList", $this->Poster->Category->find("list"));
		$this->set("prefectureList", $this->Poster->Prefecture->find("list"));

		$imageFlag = $this->request->data['Poster']['image_flag'];
		$this->set("domain", $member['Member']['domain']);
		$this->set("imageFlag", h($imageFlag));
		$this->set("catch_copy", $this->request->data['Poster']['catch_copy']);
		$this->set("description", $this->request->data['Poster']['description']);
		$this->set("editType", $this->request->data["Poster"]["edit_type"]);
		if ($imageFlag == 1) {
			$imagePath = '/tmp/'.$member['Member']['domain'].'_poster_image.jpg';
			$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImage($imagePath));
		} else {
			$this->set("templateHtml", $this->HtmlCreator->getPreviewPosterImageEmpty());
		}
		if ($this->request->data["Poster"]["edit_type"] == 0) {
			$this->set("catch_copy_ctrl", $this->request->data['Poster']['catch_copy_ctrl']);
			$this->set("description_ctrl", $this->request->data['Poster']['description_ctrl']);
			$this->render("html_regist_standard");
		} else {
			$this->render("html_regist_advanced");
		}
	}
}