<?php
App::uses('Folder', 'Utility');

/**
 * メンバートップ用コントローラ
 *
 * @author tsuuru
 *
 */
class TopController extends AppController {

	public $components = array('HtmlCreator', 'HtmlTagCheck', 'Security' => array('validatePost' => false), "Image");
	public $uses = array('Top', 'Poster');

	public function beforeFilter() {
		// ログインチェック
		if (!$this->Session->read($this->SESSION_KEY_MEMBER)) {
			$this->notLoginError();
		}
		$this->Security->requireAuth('registerImage', 'registerHtml', 'confirm', 'create', 'editImage', 'editHtml', 'delete', 'backRegisterImage', 'backRegisterHtml');
		$this->Security->requirePost('registerImage', 'registerHtml', 'create', 'editImage', 'backRegisterImage', 'backRegisterHtml');
		$this->Security->blackHoleCallback = 'badRequestError';
	}

	/**
	 * 画像登録へ遷移する
	 * @return unknown_type
	 */
	public function index($type) {

		$this->Session->delete($this->SESSION_KEY_TOP);
		// 添付画像の削除
		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}

		$count = $this->Top->find('count', array(
				'conditions' => array('Top.member_id' => $member['Member']['id'])
		));
		if ($type == 0) {
			if($count >= 1) {
					$this->set("message", "メンバートップは作成済みです");
				$this->render("top_info");
				return;
			}
			$this->render('image_regist');
			return;
		}

		if ($count == 0) {
			$this->set('message', '情報を取得できませんでした');
			$this->render('top_error');
			return;
		}

		if ($type == 1) {
			$this->render('image_edit');
			return;
		}
		if ($type == 2) {
			$this->redirect(array('action' => 'editHtml'));
		}
		if ($type == 3) {
			$this->redirect(array('action' => 'delete'));
		}
		$this->render('top_error');

	}

	/**
	 * HTML登録画面へ遷移する
	 */
	public function registerImage() {

		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';


		$imageFlag = $this->request->data['image_flag'];

		if ($imageFlag == 1) {
			if (!file_exists(WWW_ROOT.$imagePath)) {
				$this->set('errorImage','ファイルをアップロードしてください');
				$this->render('image_regist');
				return;
			}
		}

		$topData = $this->Top->findByMemberId($member['Member']['id']);
		$this->Top->Image->deleteAll(array('Image.page_id' => $topData['Top']['id'], 'Image.page_type' => 2, 'Image.member_id' => $member['Member']['id']));

		// HTML作成
		$templateHtml = file_get_contents(ROOT.DS.APP_DIR.'/Template/top_template.txt');
		if ($imageFlag == 1) {

			$imageTag = '<img src="./top_image.jpg" width="950" />';
			$templateHtml = str_replace('{primocco:template_top:image}' , $imageTag, $templateHtml);
			// 一時フォルダの中身を移動
			if (file_exists(WWW_ROOT.$imagePath)) {
				// 画像のコピー
				copy(WWW_ROOT.$imagePath, WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image.jpg');
				// サムネイルの作成
				$this->Image->resizeJpegFile(WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image.jpg', WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image_thumb.jpg', 180);
			}

			$imageData = array();
			$imageData['Image']['member_id']  = $topData['Top']['member_id'];
			$imageData['Image']['page_id']    = $topData['Top']['id'];
			$imageData['Image']['page_type']  = 2;
			$imageData['Image']['area']       = 1;
			$imageData['Image']['image_name'] = 'top_image.jpg';
			$this->Top->Image->save($imageData);
		} else {
			$templateHtml = str_replace('{primocco:template_top:image}' , '', $templateHtml);
			// 画像のコピー
			copy(WWW_ROOT.'img/top_image_thumb.jpg', WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image_thumb.jpg');
		}

		// リンク処理
		$linkFlag = 0;
		if (!empty($topData['Link'])) {
			foreach ($topData['Link'] as $link) {
				$area = $link['area'];
				$poster = $this->Poster->findByIdAndMemberId($link['link_id'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link'.$area.'}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'/'.'">'.$link['title'].'</a></li>', $templateHtml);
				$linkFlag = 1;
			}
		}
		if ($linkFlag == 1) {
			$templateHtml = str_replace('{primocco:template_top:linkStart}' , '<div id="linkArea"><ul id="bxslider">', $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:linkEnd}' , '</ul></div>', $templateHtml);
		} else {
			$templateHtml = str_replace('{primocco:template_top:linkStart}' , '', $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:linkEnd}' , '', $templateHtml);
		}

		// ボックス処理
		if (!empty($topData['Box'])) {
			foreach ($topData['Box'] as $box) {
				$area = $box['area'];
				if ($area == 1 || $area == 2) {
					if (!empty($box['title'])) {
						$templateHtml = str_replace('{primocco:template_top:mainBoxTitle'.$area.'}' , '<h2>'.$box['title'].'</h2>', $templateHtml);
					}
					$templateHtml = str_replace('{primocco:template_top:mainBoxText'.$area.'}' , nl2br($box['text']), $templateHtml);
				}
				if ($area == 3) {
					$templateHtml = str_replace('{primocco:template_top:subBoxTitle1}' , $box['title'], $templateHtml);
					$templateHtml = str_replace('{primocco:template_top:subBoxText1}' , nl2br($box['text']), $templateHtml);
				}
				if ($area == 4) {
					$templateHtml = str_replace('{primocco:template_top:subBoxTitle2}' , $box['title'], $templateHtml);
					$templateHtml = str_replace('{primocco:template_top:subBoxText2}' , nl2br($box['text']), $templateHtml);
									}
				if ($area == 5) {
					$templateHtml = str_replace('{primocco:template_top:subBoxTitle3}' , $box['title'], $templateHtml);
					$templateHtml = str_replace('{primocco:template_top:subBoxText3}' , nl2br($box['text']), $templateHtml);
									}
				if ($area == 6) {
					$templateHtml = str_replace('{primocco:template_top:subBoxTitle4}' , $box['title'], $templateHtml);
					$templateHtml = str_replace('{primocco:template_top:subBoxText4}' , nl2br($box['text']), $templateHtml);
									}
			}
		}

		$templateHtml = str_replace('{primocco:template_top:link1}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:link2}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:link3}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:link4}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:link5}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:link6}' , '', $templateHtml);

		$templateHtml = str_replace('{primocco:template_top:mainBoxTitle1}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:mainBoxTitle2}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:mainBoxText1}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:mainBoxText2}' , '', $templateHtml);

		$templateHtml = str_replace('{primocco:template_top:subBoxTitle1}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxTitle2}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxTitle3}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxTitle4}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxText1}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxText2}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxText3}' , '', $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:subBoxText4}' , '', $templateHtml);

		$templateHtml = str_replace('{primocco:template_top:url}' , Router::url('/', true), $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:title}', $topData['Top']['title'], $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:keywords}' , $topData['Top']['keywords'], $templateHtml);
		$templateHtml = str_replace('{primocco:template_top:description}' , $topData['Top']['description'], $templateHtml);
		$fno = fopen(WWW_ROOT.'members/'.$member['Member']['domain'].'/index.html', 'w');
		mb_language('Japanese');
		fwrite($fno, mb_convert_encoding($templateHtml, 'UTF-8','AUTO'));
		fclose($fno);

		// 添付画像の削除
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}

		$this->set('top_url', 'members/'.$member['Member']['domain']);
		$this->render('complete');
	}

	/**
	 * HTML登録画面へ遷移する
	 */
	public function registerHtml() {

		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';


		$imageFlag = $this->request->data['image_flag'];

		if ($imageFlag == 1) {
			if (!file_exists(WWW_ROOT.$imagePath)) {
				$this->set('errorImage','ファイルをアップロードしてください');
				$this->render('image_regist');
				return;
			}
		}
		$this->set('posterList', $this->Poster->find('list', array('conditions' => array('Poster.member_id' => $member['Member']['id']))));
		$this->set('imageFlag', h($imageFlag));
		$this->set('editFlag', 0);

		$this->render('html_regist');
	}

	/**
	 * 確認画面へ遷移する
	 */
	public function confirm() {

		if (!empty($this->request->data)) {

			$member = $this->getMember();
			if ($this->Top->saveAll($this->request->data, array('validate' => 'only'))) {

				$input = $this->data;

				$input['Top']['member_id'] = $member['Member']['id'];
				$input['Top']['keywords'] = h($this->data['Top']['keywords']);
				$input['Top']['description'] = h($this->data['Top']['description']);
				$input['Top']['title'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['title'], 3);

				$input['Top']['link_title1'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title1'], 3);
				$input['Top']['link_title2'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title2'], 3);
				$input['Top']['link_title3'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title3'], 3);
				$input['Top']['link_title4'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title4'], 3);
				$input['Top']['link_title5'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title5'], 3);
				$input['Top']['link_title6'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['link_title6'], 3);

				$input['Top']['link_id1'] = h($this->data['Top']['link_id1']);
				$input['Top']['link_id2'] = h($this->data['Top']['link_id2']);
				$input['Top']['link_id3'] = h($this->data['Top']['link_id3']);
				$input['Top']['link_id4'] = h($this->data['Top']['link_id4']);
				$input['Top']['link_id5'] = h($this->data['Top']['link_id5']);
				$input['Top']['link_id6'] = h($this->data['Top']['link_id6']);

				$input['Top']['main_box_title1'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['main_box_title1'], 3);
				$input['Top']['main_box_title2'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['main_box_title2'], 3);

				$input['Top']['main_box_text1'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['main_box_text1'], 2);
				$input['Top']['main_box_text2'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['main_box_text2'], 2);

				$input['Top']['sub_box_title1'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_title1'], 3);
				$input['Top']['sub_box_title2'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_title2'], 3);
				$input['Top']['sub_box_title3'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_title3'], 3);
				$input['Top']['sub_box_title4'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_title4'], 3);

				$input['Top']['sub_box_text1'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_text1'], 2);
				$input['Top']['sub_box_text2'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_text2'], 2);
				$input['Top']['sub_box_text3'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_text3'], 2);
				$input['Top']['sub_box_text4'] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Top']['sub_box_text4'], 2);

				$this->Session->write($this->SESSION_KEY_TOP, $input);

				$this->set('tmp_keywords', $input['Top']['keywords']);
				$this->set('tmp_description', $input['Top']['description']);
				$this->set('tmp_title', $input['Top']['title']);

				if ($this->request->data['Top']['image_flag'] == 1) {
					$this->set('tmp_image', '<img src="'.Router::url('/tmp/'.$member['Member']['domain'].'_top_image.jpg', true).'" width="100%"/>');
				}

				$linkFlag = 0;
				if (!empty($input['Top']['link_title1']) && !empty($input['Top']['link_id1'])) {
					$this->set('tmp_link_title1', '<li><a class="poster" href="#">'.$input['Top']['link_title1'].'</a></li>');
					$linkFlag = 1;
				}
				if (!empty($input['Top']['link_title2']) && !empty($input['Top']['link_id2'])) {
					$this->set('tmp_link_title2', '<li><a class="poster" href="#">'.$input['Top']['link_title2'].'</a></li>');
					$linkFlag = 1;
				}
				if (!empty($input['Top']['link_title3']) && !empty($input['Top']['link_id3'])) {
					$this->set('tmp_link_title3', '<li><a class="poster" href="#">'.$input['Top']['link_title3'].'</a></li>');
					$linkFlag = 1;
				}
				if (!empty($input['Top']['link_title4']) && !empty($input['Top']['link_id4'])) {
					$this->set('tmp_link_title4', '<li><a class="poster" href="#">'.$input['Top']['link_title4'].'</a></li>');
					$linkFlag = 1;
				}
				if (!empty($input['Top']['link_title5']) && !empty($input['Top']['link_id5'])) {
					$this->set('tmp_link_title5', '<li><a class="poster" href="#">'.$input['Top']['link_title5'].'</a></li>');
					$linkFlag = 1;
				}
				if (!empty($input['Top']['link_title6']) && !empty($input['Top']['link_id6'])) {
					$this->set('tmp_link_title6', '<li><a class="poster" href="#">'.$input['Top']['link_title6'].'</a></li>');
					$linkFlag = 1;
				}
				$this->set('linkFlag', $linkFlag);

				if (!empty($input['Top']['main_box_title1'])) {
					$this->set('tmp_main_box_title1', '<h2>'.$input['Top']['main_box_title1'].'</h2>');
				}
				if (!empty($input['Top']['main_box_title2'])) {
					$this->set('tmp_main_box_title2', '<h2>'.$input['Top']['main_box_title2'].'</h2>');
				}

				$this->set('tmp_main_box_text1', $input['Top']['main_box_text1']);
				$this->set('tmp_main_box_text2', $input['Top']['main_box_text2']);

				$this->set('tmp_sub_box_title1', $input['Top']['sub_box_title1']);
				$this->set('tmp_sub_box_title2', $input['Top']['sub_box_title2']);
				$this->set('tmp_sub_box_title3', $input['Top']['sub_box_title3']);
				$this->set('tmp_sub_box_title4', $input['Top']['sub_box_title4']);

				$this->set('tmp_sub_box_text1', $input['Top']['sub_box_text1']);
				$this->set('tmp_sub_box_text2', $input['Top']['sub_box_text2']);
				$this->set('tmp_sub_box_text3', $input['Top']['sub_box_text3']);
				$this->set('tmp_sub_box_text4', $input['Top']['sub_box_text4']);

				$this->render('top_confirm');
			} else {
				$this->set('posterList', $this->Poster->find('list', array('conditions' => array('Poster.member_id' => $member['Member']['id']))));
				$imageFlag = $this->request->data['Top']['image_flag'];
				$this->set('imageFlag', h($imageFlag));

				$editFlag = $this->request->data['Top']['edit_flag'];
				$this->set('editFlag', h($editFlag));
				if ($editFlag == 1) {
					$this->render('html_edit');
				} else {
					$this->render('html_regist');
				}
			}
		}
	}

	/**
	 * ページを生成する
	 */
	public function create() {

		// Top情報の取得
		$top = $this->Session->read($this->SESSION_KEY_TOP);

		if (!empty($top)) {

			$member = $this->getMember();

			$topId = $this->Session->read('topId');
			if (!empty($topId)) {
				$top['Top']['id'] = $topId;
				$this->Top->Image->deleteAll(array('Image.page_id' => $topId, 'Image.page_type' => 2, 'Image.member_id' => $member['Member']['id']));
				$this->Top->Link->deleteAll(array('Link.page_id' => $topId, 'Link.page_type' => 2, 'Link.member_id' => $member['Member']['id']));
				$this->Top->Box->deleteAll(array('Box.page_id' => $topId, 'Box.page_type' => 2, 'Box.member_id' => $member['Member']['id']));
			}
			$this->Top->save($top);

			// 本番用ディレクトリを作成する
			if (!is_dir(WWW_ROOT.'members/'.$member['Member']['domain'])) {
				mkdir(WWW_ROOT.'members/'.$member['Member']['domain'], 0775, true);
			}

			// HTMLテンプレートの読込
			$templateHtml = file_get_contents(ROOT.DS.APP_DIR.'/Template/top_template.txt');

			// 画像処理
			$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';
			if ($this->request->data['Top']['image_flag'] == 1) {

				$imageTag = '<img src="./top_image.jpg" width="950" />';
				$templateHtml = str_replace('{primocco:template_top:image}' , $imageTag, $templateHtml);
				// 一時フォルダの中身を移動
				if (file_exists(WWW_ROOT.$imagePath)) {
					// 画像のコピー
					copy(WWW_ROOT.$imagePath, WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image.jpg');
					// サムネイルの作成
					$this->Image->resizeJpegFile(WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image.jpg', WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image_thumb.jpg', 180);
				}

				$imageData = array();
				$imageData['Image']['member_id']  = $top['Top']['member_id'];
				$imageData['Image']['page_id']    = $this->Top->id;
				$imageData['Image']['page_type']  = 2;
				$imageData['Image']['area']       = 1;
				$imageData['Image']['image_name'] = 'top_image.jpg';
				$this->Top->Image->save($imageData);
			} else {
				$templateHtml = str_replace('{primocco:template_top:image}' , '', $templateHtml);
				// 画像のコピー
				copy(WWW_ROOT.'img/top_image_thumb.jpg', WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image_thumb.jpg');
			}

			// リンク処理
			$linkFlag = 0;
			$linkData = array();
			$linkData['Link']['member_id'] = $top['Top']['member_id'];
			$linkData['Link']['page_id'] = $this->Top->id;
			$linkData['Link']['page_type'] = 2;

			if (!empty($top['Top']['link_title1']) && !empty($top['Top']['link_id1'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id1'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link1}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title1'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id1']);
				$linkData['Link']['area'] = 1;
				$linkData['Link']['title'] = $top['Top']['link_title1'];
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link1}' , '', $templateHtml);
			}

			if (!empty($top['Top']['link_title2']) && !empty($top['Top']['link_id2'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id2'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link2}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title2'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id2']);
				$linkData['Link']['area'] = 2;
				$linkData['Link']['title'] = $top['Top']['link_title2'];
				$this->Top->Link->create();
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link2}' , '', $templateHtml);
			}

			if (!empty($top['Top']['link_title3']) && !empty($top['Top']['link_id3'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id3'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link3}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title3'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id3']);
				$linkData['Link']['area'] = 3;
				$linkData['Link']['title'] = $top['Top']['link_title3'];
				$this->Top->Link->create();
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link3}' , '', $templateHtml);
			}

			if (!empty($top['Top']['link_title4']) && !empty($top['Top']['link_id4'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id4'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link4}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title4'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id4']);
				$linkData['Link']['area'] = 4;
				$linkData['Link']['title'] = $top['Top']['link_title4'];
				$this->Top->Link->create();
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link4}' , '', $templateHtml);
			}

			if (!empty($top['Top']['link_title5']) && !empty($top['Top']['link_id5'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id5'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link5}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title5'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id5']);
				$linkData['Link']['area'] = 5;
				$linkData['Link']['title'] = $top['Top']['link_title5'];
				$this->Top->Link->create();
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link5}' , '', $templateHtml);
			}

			if (!empty($top['Top']['link_title6']) && !empty($top['Top']['link_id6'])) {
				$poster = $this->Poster->findByIdAndMemberId($top['Top']['link_id6'], $member['Member']['id'], array('Poster.poster_path'));
				$templateHtml = str_replace('{primocco:template_top:link6}' , '<li><a class="poster" href="'.Router::url('/', true).$poster['Poster']['poster_path'].'">'.$top['Top']['link_title6'].'</a></li>', $templateHtml);
				$linkData['Link']['link_id'] = h($top['Top']['link_id6']);
				$linkData['Link']['area'] = 6;
				$linkData['Link']['title'] = $top['Top']['link_title6'];
				$this->Top->Link->create();
				$this->Top->Link->save($linkData);
				$linkFlag = 1;
			} else {
				$templateHtml = str_replace('{primocco:template_top:link6}' , '', $templateHtml);
			}

			if ($linkFlag == 1) {
				$templateHtml = str_replace('{primocco:template_top:linkStart}' , '<div id="linkArea"><ul id="bxslider">', $templateHtml);
				$templateHtml = str_replace('{primocco:template_top:linkEnd}' , '</ul></div>', $templateHtml);
			} else {
				$templateHtml = str_replace('{primocco:template_top:linkStart}' , '', $templateHtml);
				$templateHtml = str_replace('{primocco:template_top:linkEnd}' , '', $templateHtml);
			}

			// ボックス処理
			$boxData = array();
			$boxData['Box']['member_id']  = $top['Top']['member_id'];
			$boxData['Box']['page_id']    = $this->Top->id;
			$boxData['Box']['page_type']  = 2;

			if (empty($top['Top']['main_box_title1'])) {
				$templateHtml = str_replace('{primocco:template_top:mainBoxTitle1}' , '', $templateHtml);
			} else {
				$templateHtml = str_replace('{primocco:template_top:mainBoxTitle1}' , '<h2>'.$top['Top']['main_box_title1'].'</h2>', $templateHtml);
			}
			$templateHtml = str_replace('{primocco:template_top:mainBoxText1}' , nl2br($top['Top']['main_box_text1']), $templateHtml);
			if (!empty($top['Top']['main_box_title1']) || !empty($top['Top']['main_box_text1'])) {
				$boxData['Box']['area'] = 1;
				$boxData['Box']['title'] = $top['Top']['main_box_title1'];
				$boxData['Box']['text'] = $top['Top']['main_box_text1'];
				$this->Top->Box->save($boxData);
			}

			if (empty($top['Top']['main_box_title2'])) {
				$templateHtml = str_replace('{primocco:template_top:mainBoxTitle2}' , '', $templateHtml);
			} else {
				$templateHtml = str_replace('{primocco:template_top:mainBoxTitle2}' , '<h2>'.$top['Top']['main_box_title2'].'</h2>', $templateHtml);
			}
			$templateHtml = str_replace('{primocco:template_top:mainBoxText2}' , nl2br($top['Top']['main_box_text2']), $templateHtml);
			if (!empty($top['Top']['main_box_title2']) || !empty($top['Top']['main_box_text2'])) {
				$boxData['Box']['area'] = 2;
				$boxData['Box']['title'] = $top['Top']['main_box_title2'];
				$boxData['Box']['text'] = $top['Top']['main_box_text2'];
				$this->Top->Box->create();
				$this->Top->Box->save($boxData);
			}

			$templateHtml = str_replace('{primocco:template_top:subBoxTitle1}' , $top['Top']['sub_box_title1'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:subBoxText1}' , nl2br($top['Top']['sub_box_text1']), $templateHtml);
			if (!empty($top['Top']['sub_box_title1']) || !empty($top['Top']['sub_box_text1'])) {
				$boxData['Box']['area'] = 3;
				$boxData['Box']['title'] = $top['Top']['sub_box_title1'];
				$boxData['Box']['text'] = $top['Top']['sub_box_text1'];
				$this->Top->Box->create();
				$this->Top->Box->save($boxData);
			}

			$templateHtml = str_replace('{primocco:template_top:subBoxTitle2}' , $top['Top']['sub_box_title2'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:subBoxText2}' , nl2br($top['Top']['sub_box_text2']), $templateHtml);
			if (!empty($top['Top']['sub_box_title2']) || !empty($top['Top']['sub_box_text2'])) {
				$boxData['Box']['area'] = 4;
				$boxData['Box']['title'] = $top['Top']['sub_box_title2'];
				$boxData['Box']['text'] = $top['Top']['sub_box_text2'];
				$this->Top->Box->create();
				$this->Top->Box->save($boxData);
			}

			$templateHtml = str_replace('{primocco:template_top:subBoxTitle3}' , $top['Top']['sub_box_title3'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:subBoxText3}' , nl2br($top['Top']['sub_box_text3']), $templateHtml);
			if (!empty($top['Top']['sub_box_title3']) || !empty($top['Top']['sub_box_text3'])) {
				$boxData['Box']['area'] = 5;
				$boxData['Box']['title'] = $top['Top']['sub_box_title3'];
				$boxData['Box']['text'] = $top['Top']['sub_box_text3'];
				$this->Top->Box->create();
				$this->Top->Box->save($boxData);
			}

			$templateHtml = str_replace('{primocco:template_top:subBoxTitle4}' , $top['Top']['sub_box_title4'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:subBoxText4}' , nl2br($top['Top']['sub_box_text4']), $templateHtml);
			if (!empty($top['Top']['sub_box_title4']) || !empty($top['Top']['sub_box_text4'])) {
				$boxData['Box']['area'] = 6;
				$boxData['Box']['title'] = $top['Top']['sub_box_title4'];
				$boxData['Box']['text'] = $top['Top']['sub_box_text4'];
				$this->Top->Box->create();
				$this->Top->Box->save($boxData);
			}

			// HTML作成
			$templateHtml = str_replace('{primocco:template_top:url}' , Router::url('/', true), $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:title}', $top['Top']['title'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:keywords}' , $top['Top']['keywords'], $templateHtml);
			$templateHtml = str_replace('{primocco:template_top:description}' , $top['Top']['description'], $templateHtml);
			$fno = fopen(WWW_ROOT.'members/'.$member['Member']['domain'].'/index.html', 'w');
			mb_language('Japanese');
			fwrite($fno, mb_convert_encoding($templateHtml, 'UTF-8','AUTO'));
			fclose($fno);

			// 添付画像の削除
			if (file_exists(WWW_ROOT.$imagePath)) {
				unlink(WWW_ROOT.$imagePath);
			}

			// セッショントップ情報削除
			$this->Session->delete($this->SESSION_KEY_TOP);

			$this->set('top_url', 'members/'.$member['Member']['domain']);
			$this->render('complete');
		}
	}

	/*
	 * HTML編集画面へ遷移する
	 */
	public function editHtml() {

		$member = $this->getMember();
		$topData = $this->Top->findByMemberId($member['Member']['id']);

		$this->Session->write('topId', $topData['Top']['id']);
		$editData = $topData;
		if (!empty($topData['Link'])) {
			foreach ($topData['Link'] as $link) {
				$area = $link['area'];
				$editData['Top']['link_title'.$area] = $link['title'];
				$editData['Top']['link_id'.$area] = $link['link_id'];
			}
		}

		if (!empty($topData['Box'])) {
			foreach ($topData['Box'] as $box) {
				$area = $box['area'];
				if ($area == 1 || $area == 2) {
					$editData['Top']['main_box_title'.$area] = $box['title'];
					$editData['Top']['main_box_text'.$area] = $box['text'];
				}
				if ($area == 3) {
					$editData['Top']['sub_box_title1'] = $box['title'];
					$editData['Top']['sub_box_text1'] = $box['text'];
				}
				if ($area == 4) {
					$editData['Top']['sub_box_title2'] = $box['title'];
					$editData['Top']['sub_box_text2'] = $box['text'];
				}
				if ($area == 5) {
					$editData['Top']['sub_box_title3'] = $box['title'];
					$editData['Top']['sub_box_text3'] = $box['text'];
				}
				if ($area == 6) {
					$editData['Top']['sub_box_title4'] = $box['title'];
					$editData['Top']['sub_box_text4'] = $box['text'];
				}
			}
		}

		if (empty($topData['Image'])) {
			$this->set('imageFlag', '0');
		} else {
			$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';
			copy(WWW_ROOT.'members/'.$member['Member']['domain'].'/top_image.jpg', WWW_ROOT.$imagePath);
			$this->set('imageFlag', '1');
		}
		$this->set('editFlag', 1);

		$this->set('posterList', $this->Poster->find('list', array('conditions' => array('Poster.member_id' => $member['Member']['id']))));
		$this->request->data = $editData;
		$this->render('html_edit');

	}

	/*
	 * 削除確認画面へ遷移する
	 */
	public function delete() {

		$member = $this->getMember();
		$topData = $this->Top->findByMemberId($member['Member']['id']);

		if($this->request->isDelete()) {

			$imagePath = 'members/'.$member['Member']['domain'].'/top_image.jpg';
			if (file_exists(WWW_ROOT.$imagePath)) {
				unlink(WWW_ROOT.$imagePath);
			}
			$imagePath = 'members/'.$member['Member']['domain'].'/top_image_thumb.jpg';
			if (file_exists(WWW_ROOT.$imagePath)) {
				unlink(WWW_ROOT.$imagePath);
			}
			copy(WWW_ROOT.'members/index.html', WWW_ROOT.'members/'.$member['Member']['domain'].'/index.html');

			if (!empty($topData['Image'])) {
				$this->Top->Image->deleteAll(array('Image.page_id' => $topData['Top']['id'], 'Image.page_type' => 2, 'Image.member_id' => $member['Member']['id']));
			}
			if (!empty($topData['Link'])) {
				$this->Top->Link->deleteAll(array('Link.page_id' => $topData['Top']['id'], 'Link.page_type' => 2, 'Link.member_id' => $member['Member']['id']));
			}
			if (!empty($topData['Box'])) {
				$this->Top->Box->deleteAll(array('Box.page_id' => $topData['Top']['id'], 'Box.page_type' => 2, 'Box.member_id' => $member['Member']['id']));
			}

			$this->Top->delete($topData['Top']['id']);
			$this->redirect(array('controller' => 'Mypage'));
		}

		$this->set('tmp_keywords', $topData['Top']['keywords']);
		$this->set('tmp_description', $topData['Top']['description']);
		$this->set('tmp_title', $topData['Top']['title']);

		if (empty($topData['Image'])) {
			$this->set('tmp_image', '');
		} else {
			$this->set('tmp_image', '<img src="'.Router::url('/members/'.$member['Member']['domain'].'/top_image.jpg', true).'" width="100%"/>');
		}

		$linkFlag = 0;
		if (!empty($topData['Link'])) {
			foreach ($topData['Link'] as $link) {
				$this->set('tmp_link_title'.$link['area'], '<li><a class="poster" href="#">'.$link['title'].'</a></li>');
				$linkFlag = 1;
			}
		}
		$this->set('linkFlag', $linkFlag);

		if (!empty($topData['Box'])) {
			foreach ($topData['Box'] as $box) {
				$area = $box['area'];
				if ($area == 1 || $area == 2) {
					if (!empty($box['title'])) {
						$this->set('tmp_main_box_title'.$area, '<h2>'.$box['title'].'</h2>');
					}
					$this->set('tmp_main_box_text'.$area, $box['text']);
				}
				if ($area == 3) {
					$this->set('tmp_sub_box_title1', $box['title']);
					$this->set('tmp_sub_box_text1', $box['text']);
				}
				if ($area == 4) {
					$this->set('tmp_sub_box_title2', $box['title']);
					$this->set('tmp_sub_box_text2', $box['text']);
				}
				if ($area == 5) {
					$this->set('tmp_sub_box_title3', $box['title']);
					$this->set('tmp_sub_box_text3', $box['text']);
				}
				if ($area == 6) {
					$this->set('tmp_sub_box_title4', $box['title']);
					$this->set('tmp_sub_box_text4', $box['text']);
				}
			}
		}

		$this->render('top_delete');
	}

	public function backRegisterImage() {

		$this->Session->delete($this->SESSION_KEY_TOP);
		// 添付画像の削除
		$member = $this->getMember();
		$imagePath = '/tmp/'.$member['Member']['domain'].'_top_image.jpg';
		if (file_exists(WWW_ROOT.$imagePath)) {
			unlink(WWW_ROOT.$imagePath);
		}
		$this->render('image_regist');
	}

	public function backRegisterHtml() {

		$member = $this->getMember();
		$this->data = $this->Session->read($this->SESSION_KEY_TOP);

		$this->set('posterList', $this->Poster->find('list', array('conditions' => array('Poster.member_id' => $member['Member']['id']))));
		$imageFlag = $this->request->data['Top']['image_flag'];
		$this->set('imageFlag', h($imageFlag));
		$editFlag = $this->request->data['Top']['edit_flag'];
		$this->set('editFlag', h($editFlag));
		if ($editFlag == 1) {
			$this->render('html_edit');
		} else {
			$this->render('html_regist');
		}
	}
}