# ipl.s

# ブート開始アドレス。
boot_begin = 0x7c00

# IPLのサイズ。
ipl_size = 0x200

# 1トラック当たりのセクタ数。
fd_sector_per_track = 0x12

# リアルモード用コードを生成する。
.code16

    # BPBを飛び越える。
    jmp begin
    nop

# BPB
name:           .ascii  "Name    "
sector_size:    .word   0x0200
cluster_size:   .byte   0x01
fat_pos:        .word   0x0001
fat_cnt:        .byte   0x02
root_size:      .word   0x00e0
sector_cnt:     .word   0x0b40
media_type:     .byte   0xf0
fat_size:       .word   0x0009
sector_cnt_pt:  .word   0x0012
head_cnt:       .word   0x0002
bpb_pos:        .long   0x0000
sector_cnt_l:   .long   0x00000b40
drive_no:       .byte   0x00
reserved:       .byte   0x00
ext_boot_code:  .byte   0x29
volume_serial:  .long   0xffffffff
disk_name:      .ascii  "DISK       "
fat_name:       .ascii  "FAT12   "

    # 起動処理の開始。
begin:

    # レジスタ初期化
    cld
    xorw    %ax, %ax
    movw    %ax, %ss
    movw    %ax, %es
    movw    %ax, %fs
    
    # スタック・ポインタ初期化
    movw    $_kernel_begin, %sp
    
    # IPL全体をカーネル開始アドレスへ。
    xor     %ax, %ax
	
    # コピー元。
    movw %ax, %ds
    movw $boot_begin, %si
	
    # コピー先。
    movw %ax, %es
    movw $_kernel_begin, %di
	
    # ワード数。
    movw $(ipl_size / 2), %cx
	
    # コピーする。
    rep movsw
	
    # コードセグメント設定。
    ljmp    $0x0000, $set_cs
set_cs:

    # 起動メッセージ表示。
    movw    $BOOT_MSG, %si
    call    print

# 文字列の表示
#   params:
#       si = NULL終端文字列の先頭アドレス。
print:
    # 文字表示コマンドの指定。
    xorw    %bx, %bx
    movb    $0x0e, %ah
    
    # 1文字表示する処理。
print_char:
    # 1バイト読み込み。
    lodsb
    # NULL文字だったら終了。
    orb     %al, %al
    jz      print_end
    
    # BIOSファンクションコール。
    int     $0x10
    
    # 次の文字へ。
    jmp     print_char
    
    # 文字列表示の終了。
print_end:
    ret

# 表示するメッセージ。
BOOT_MSG: .string "Hello,World!\r\n"

# ブートセクタの印。
. = 510
.short 0xaa55

# IPLの終端。
ipl_end:
