﻿/**
 *	ボタン関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.button;

import win32.windows;
import outland.dmajor.application;
import outland.dmajor.shape;
import outland.dmajor.window;

/// ボタンコントロール。
class Button : Window {
	
	/// ウィンドウクラス名。
	const TCHAR[] WINDOW_CLASS = "BUTTON";
	
	/// ボタンを生成する。
	static Button create(char[] caption, Rect r, Window parent, uint id, DWORD style, DWORD styleEx = 0) {
		Button btn = new Button();
		btn.createWindow(caption, r, parent, id, style, styleEx);
		return btn;
	}
	
	/// サブクラス化する。
	static Button subclassWindow(HWND wnd) {
		Button btn = new Button();
		btn.subclass(wnd);
		return btn;
	}
	
public:
	
	/// クリックの動作を行う。
	void click() {sendMessage(BM_CLICK);}
	
	/// チェック状態。
	uint checkState() {return sendMessage(BM_GETCHECK);}
	
	/// ditto
	void checkState(uint s) {sendMessage(BM_SETCHECK, s);}
	
	/// 状態。
	bool state() {return sendMessage(BM_GETSTATE) != FALSE;}
	
	/// ditto
	void state(bool s) {sendMessage(BM_SETSTATE, s ? TRUE : FALSE);}
	
	/// スタイル変更。
	void setStyle(DWORD style, bool redraw = true) {sendMessage(BM_SETSTYLE, style, redraw ? TRUE : FALSE);}
	
	/// ビットマップ。
	HBITMAP bitmap() {return cast(HBITMAP) sendMessage(BM_GETIMAGE, IMAGE_BITMAP);}
	
	/// ditto
	void bitmap(HBITMAP bmp) {sendMessage(BM_SETIMAGE, IMAGE_BITMAP, cast(LPARAM) bmp);}
	
	/// アイコン。
	HICON icon() {return cast(HICON) sendMessage(BM_GETIMAGE, IMAGE_ICON);}
	
	/// ditto
	void icon(HICON i) {sendMessage(BM_SETIMAGE, IMAGE_ICON, cast(LPARAM) i);}
	
	/// クリック時の処理。
	void onClick(CommandDelegate h) {onReflectCommand(BN_CLICKED, h);}
	
	/// ダブルクリック時の処理。
	void onDoubleClick(CommandDelegate h) {onReflectCommand(BN_DBLCLK, h);}
	
	/// 無効化時の処理。
	void onDisable(CommandDelegate h) {onReflectCommand(BN_DISABLE, h);}
	
	/// 選択時の処理。
	void onHilite(CommandDelegate h) {onReflectCommand(BN_HILITE, h);}
	
	/// 押下時の処理。
	void onPushed(CommandDelegate h) {onReflectCommand(BN_PUSHED, h);}
	
	/// 押下解除時の処理。
	void onUnpushed(CommandDelegate h) {onReflectCommand(BN_UNPUSHED, h);}
	
	// 以下は不要？
	// BN_KILLFOCUS
	// BN_PAINT
	
protected:
	
	/// ウィンドウ生成。
	void createWindow(char[] caption, Rect r, Window parent, uint id, DWORD style, DWORD styleEx) {
		HINSTANCE inst = (parent) ? parent.getInstanceHandle() : Application.instance.handle;
		super.createWindow(
			WINDOW_CLASS.ptr,
			caption,
			style | WS_CHILD,
			styleEx,
			r,
			parent ? parent.handle : cast(HWND) null,
			cast(HMENU) id,
			inst,
			null);
	}
}
