﻿/**
 *	ラベル関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.label;

import win32.windows;

import outland.dmajor.application;
import outland.dmajor.shape;
import outland.dmajor.window;

/// スタティックラベルコントロール。
class Label : Window {
	
	/// ウィンドウクラス名。
	const TCHAR[] WINDOW_CLASS = "STATIC";
	
	/// デフォルトの拡張スタイル。
	const DWORD STYLE_EX = 0;
	
	/// スタティックラベルを生成する。
	static Label create(char[] title, Rect r, Window parent, uint id, DWORD style, DWORD styleEx = STYLE_EX) {
		auto l = new Label();
		l.createWindow(title, r, parent, id, style, styleEx);
		return l;
	}
	
	/// サブクラス化する。
	static Label subclassWindow(HWND wnd) {
		auto l = new Label();
		l.subclass(wnd);
		return l;
	}
	
public:
	
	/// アイコン。
	HICON icon() {return cast(HICON) sendMessage(STM_GETICON);}
	
	/// ditto
	void icon(HICON ic) {sendMessage(STM_SETICON, cast(WPARAM) ic);}
	
	/// カーソル。
	HCURSOR cursor() {return cast(HCURSOR) sendMessage(STM_GETIMAGE, IMAGE_CURSOR);}
	
	/// ditto
	void cursor(HCURSOR h) {sendMessage(STM_SETIMAGE, IMAGE_CURSOR, cast(LPARAM) h);}
	
	/// ビットマップ。
	HBITMAP bitmap() {return cast(HBITMAP) sendMessage(STM_GETIMAGE, IMAGE_BITMAP);}
	
	/// ditto
	void bitmap(HBITMAP h) {sendMessage(STM_SETIMAGE, IMAGE_BITMAP, cast(LPARAM) h);}
	
	/// メタファイル。
	HENHMETAFILE metaFile() {return cast(HENHMETAFILE) sendMessage(STM_GETIMAGE, IMAGE_ENHMETAFILE);}
	
	/// ditto
	void metaFile(HENHMETAFILE h) {sendMessage(STM_GETIMAGE, IMAGE_ENHMETAFILE, cast(LPARAM) h);}

	/// クリック時の処理。
	void onClick(CommandDelegate d) {onReflectCommand(STN_CLICKED, d);}
	
	/// ダブルクリック時の処理。
	void onDoubleClick(CommandDelegate d) {onReflectCommand(STN_DBLCLK, d);}

	// 以下は不要？
	// STN_DISABLE  
	// STN_ENABLE 
	
protected:
	
	/// ウィンドウ生成。
	void createWindow(char[] title, Rect r, Window parent, uint id, DWORD style, DWORD styleEx) {
		super.createWindow(
			WINDOW_CLASS.ptr,
			title,
			style | WS_CHILD,
			styleEx,
			r,
			parent ? parent.handle : cast(HWND) null,
			cast(HMENU) id,
			(parent) ? parent.getInstanceHandle() : Application.instance.handle,
			null);
	}
}
