﻿/**
 *	スレッドローカルストレージ。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.threadlocal;

import win32.windows;
import outland.dmajor.exception;

/** スレッドローカルストレージ。
 *
 *	同じThreadLocalオブジェクトを複数のスレッドで共有できる。
 *	valueに値を格納した後、他スレッドが同じオブジェクトを使って値の格納を行っても、
 *	自スレッドが格納した値が取り出される。格納値が他のスレッドにより書き込み・参照されない。
 */
class ThreadLocal(T) {
	
	/// TLSに格納する時の型。
	private {
		template StorageType(T) {alias T* StorageType;}
		template StorageType(T:char) {alias char StorageType;}
		template StorageType(T:wchar) {alias wchar StorageType;}
		template StorageType(T:dchar) {alias dchar StorageType;}
		template StorageType(T:byte) {alias byte StorageType;}
		template StorageType(T:ubyte) {alias ubyte StorageType;}
		template StorageType(T:short) {alias short StorageType;}
		template StorageType(T:ushort) {alias ushort StorageType;}
		template StorageType(T:int) {alias int StorageType;}
		template StorageType(T:uint) {alias uint StorageType;}
	}
	
	/// デフォルトコンストラクタ。
	this() {
		index_ = TlsAlloc();
		if(index_ == 0xFFFFFFFF) {
			throwLastError();
		}
	}
	
	/// デストラクタ。
	~this() {TlsFree(index_);}
	
	/// 格納されている値。
	StorageType!(T) value() {return cast(StorageType!(T)) TlsGetValue(index_);}
	
	/// ditto
	void value(StorageType!(T) val) {checkApi(TlsSetValue(index_, val));}
	
private:
	
	/// インデックス。
	DWORD index_;
}
