﻿/**
 *	バイトコード関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.script.bytecode;

/// バイトコード。
enum ByteCode : ubyte {
	NOP,	/// 何もしない。
	COPY,	/// スタックでのコピー。
	PUSH,	/// スタックへのプッシュ。
	POP,	/// スタックからのポップ。
	LOAD,	/// データ領域からのロード。
	SAVE,	/// データ領域へのセーブ。
	ADD,	/// 加算。
	SUB,	/// 減算。
	MUL,	/// 乗算。
	DIV,	/// 除算。
	MOD,	/// 余剰。
	SHL,	/// 左シフト。
	SHR,	/// 右シフト。
	SHRL,	/// 論理右シフト。
	CAT,	/// 連結。
	JMP,	/// ジャンプ。
	JE,		/// 等しければジャンプ。
	JNE,	/// 等しくなければジャンプ。
	JL,		/// 小さければジャンプ。
	JG,		/// 大きければジャンプ。
	JLE,	/// 以下ならばジャンプ。
	JGE,	/// 以上ならばジャンプ。
	CALL,	/// 関数呼び出し。
	RET,	/// 戻り。
	TRY,	/// 例外キャッチ。
	THROW,	/// 例外スロー。
}
