﻿/**
 *	値関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.script.error;
module outland.script.value;

/// スクリプト内の値。
struct Value {
	
	/// 型。
	enum Type {
		NULL,		/// NULL型。
		INTEGER,	/// 整数型。
		REAL,		/// 実数型。
		STRING,		/// 文字列型。
		ARRAY,		/// 配列型。
		TABLE,		/// テーブル型。
		PROCEDURE,	/// プロシージャ型。
		OBJECT,		/// オブジェクト型。
		CONTEXT,	/// コンテキスト型。
		EXCEPTION,	/// 例外型。
	}
	
	/// 型。
	Type type = Type.NULL;
	
	// 値。
	union {
		/// 整数。
		int integer_;
		
		/// 実数。
		double real_;
		
		/// 文字列。
		char[] string_;
		
		/// 配列。
		Value[] array_;
	}
}
