﻿/**
 *	メモリ・マップ関連。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		NYSL Version 0.9982
 *	History:
 *		$Log$
 */

module outlandish.os.memorymap;

import std.stdint;

/// メモリ・マップ・エントリ。
struct MemoryMapEntry {
	
	/// メモリ範囲の型。
	enum Type : uint32_t {
		MEMORY = 1,		/// 通常のメモリ。
		RESERVED = 2,	/// 予約領域。
		ACPI = 3,		/// ACPI領域。
		NVS = 4,		/// ACPI NVS領域。
		UNUSUABLE = 5,	/// 使えない。
	}
	
	/// メモリ範囲の属性。
	enum Attribute : uint32_t {
		ENABLED = 0b001,		/// 有効。
		NON_VOLATILE = 0b010,	/// 不揮発メモリ。
	}
	
	/// メモリ範囲のベース・アドレス。
	uint64_t base;
	
	/// メモリ範囲の長さ。
	uint64_t length;
	
	/// メモリ範囲の型。
	Type type;
	
	/// メモリ範囲の属性。
	Attribute attribute;
	
	/// メモリ範囲終点。
	uint64_t end() {return base + length;}
}

/// メモリ・マップ。
extern(C) const MemoryMapEntry[] MEMORY_MAP;
