/**
 * Part of the D programming language runtime library.
 */

/*
 *  Copyright (C) 2004-2007 by Digital Mars, www.digitalmars.com
 *  Written by Walter Bright
 *
 *  This software is provided 'as-is', without any express or implied
 *  warranty. In no event will the authors be held liable for any damages
 *  arising from the use of this software.
 *
 *  Permission is granted to anyone to use this software for any purpose,
 *  including commercial applications, and to alter it and redistribute it
 *  freely, subject to the following restrictions:
 *
 *  o  The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *  o  Altered source versions must be plainly marked as such, and must not
 *     be misrepresented as being the original software.
 *  o  This notice may not be removed or altered from any source
 *     distribution.
 */

/* NOTE: This file is Hatena OS version.

   Modified by Akira Yamaguchi, June 2007
*/

// Storage allocation

module std.gc;

extern (D) alias void (*fp_t)(Object);		// generic function pointer

extern (C) {

struct Array {
    size_t length;
    byte *data;
}

Object _d_newclass(ClassInfo ci) {return null;}	// not implemented!

void _d_delinterface(void** p) {}	// not implemented!

void _d_delclass(Object *p) {}	// not implemented!

/******************************************
 * Allocate a new array of length elements.
 * ti is the type of the resulting array, or pointer to element.
 */

/* For when the array is initialized to 0 */
Array _d_newarrayT(TypeInfo ti, size_t length) {
	// not implemented!
    Array result;
    return result;
}

/* For when the array has a non-zero initializer.
 */
Array _d_newarrayiT(TypeInfo ti, size_t length) {
	// not implemented!
    Array result;
    return result;
}

void[] _d_newarraymTp(TypeInfo ti, int ndims, size_t* pdim) {
	// not implemented!
    void[] result;
    return result;
}

void[] _d_newarraymiTp(TypeInfo ti, int ndims, size_t* pdim) {
	// not implemented!
    void[] result;
    return result;
}

// Perhaps we should get a a size argument like _d_new(), so we
// can zero out the array?

void _d_delarray(Array *p) {}	// not implemented!

void _d_delmemory(void* *p) {}	// not implemented!

void _d_callfinalizer(void *p) {
    //printf("_d_callfinalizer(p = %p)\n", p);
    if (p)	// not necessary if called from gc
    {
	ClassInfo **pc = cast(ClassInfo **)p;
	if (*pc)
	{
	    ClassInfo c = **pc;

	    try
	    {
		do
		{
		    if (c.destructor)
		    {
			fp_t fp = cast(fp_t)c.destructor;
			(*fp)(cast(Object)p);		// call destructor
		    }
		    c = c.base;
		} while (c);
	    /+ not implemented!
		if ((cast(void**)p)[1])	// if monitor is not null
		    _d_monitorrelease(cast(Object)p);
	    +/
	    }
	    finally
	    {
		*pc = null;			// zero vptr
	    }
	}
    }
}
	
}
