﻿/**
 *	IOポート。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		NYSL Version 0.9982
 *	History:
 *		$Log$
 */

module outlandish.os.io;

/// IO読み込み。
ubyte inp(uint port_address) {
	ubyte result;
	asm {
		mov DX, word ptr port_address;
		in AL, DX;
		mov result, AL;
	}
	return result;
}

/// ditto
ushort inpw(uint port_address) {
	ushort result;
	asm {
		mov DX, word ptr port_address;
		in AX, DX;
		mov result, AX;
	}
	return result;
}

/// ditto
uint inpl(uint port_address) {
	uint result;
	asm {
		mov DX, word ptr port_address;
		in EAX, DX;
		mov result, EAX;
	}
	return result;
}

/// 書き込み。
ubyte outp(uint port_address, ubyte value) {
	asm {
		mov DX, word ptr port_address;
		mov AL, value;
		out DX, AL;
	}
	return value;
}

/// ditto
ushort outpw(uint port_address, ushort value) {
	asm {
		mov DX, word ptr port_address;
		mov AX, value;
		out DX, AX;
	}
	return value;
}

/// ditto
uint outpl(uint port_address, uint value) {
	asm {
		mov DX, word ptr port_address;
		mov EAX, value;
		out DX, EAX;
	}
	return value;
}
