﻿/**
 *	system call related codes.
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module os.i386.systemcall;

import std.stdint;

import os.i386.interrupt;
import os.i386.errorcode;

enum SystemCallNumber : size_t {
	NULL,
	FORK_THREAD,
}

/// system call argument type.
alias uint32_t SysArg;

/// system call result type.
alias uint32_t SysRes;

/// system call function type.
alias SysRes function(SysArg n, SysArg a1, SysArg a2, SysArg a3, SysArg a4, SysArg a5) SystemCall;

/// set system call function.
void setSystemCall(size_t n, SystemCall fn) {systemCallTable_[n] = fn;}

/// get system call function.
SystemCall getSystemCall(size_t n) {return systemCallTable_[n];}

/// call system call functions.
void onSystemCall(inout InterruptContext ctx) {
	if(ctx.eax < systemCallTable_.length && systemCallTable_[ctx.eax] !is null) {
		ctx.eax = systemCallTable_[ctx.eax](ctx.eax, ctx.ecx, ctx.edx, ctx.ebx, ctx.esi, ctx.edi);
	} else {
		ctx.eax = Errno.INVALID_SYSTEM_CALL;
	}
}

SysRes callSystemCall(SysArg n, SysArg a1 = 0, SysArg a2 = 0, SysArg a3 = 0, SysArg a4 = 0, SysArg a5 = 0) {
	SysRes result;
	asm {
		mov EAX, n;
		mov ECX, a1;
		mov EDX, a2;
		mov EBX, a3;
		mov ESI, a4;
		mov EDI, a5;
		int Interrupt.SYSTEM_CALL;
		mov result, EAX;
	}
	return result;
}

/// system call function table.
private SystemCall[256] systemCallTable_;
