﻿/*
 *  Copyright (C) 1999-2006 by Digital Mars, www.digitalmars.com
 *  Written by Walter Bright
 *
 *  This software is provided 'as-is', without any express or implied
 *  warranty. In no event will the authors be held liable for any damages
 *  arising from the use of this software.
 *
 *  Permission is granted to anyone to use this software for any purpose,
 *  including commercial applications, and to alter it and redistribute it
 *  freely, subject to the following restrictions:
 *
 *  o  The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *  o  Altered source versions must be plainly marked as such, and must not
 *     be misrepresented as being the original software.
 *  o  This notice may not be removed or altered from any source
 *     distribution.
 */

// Modified by Akira Yamaguchi, June 2007

module std.gc;

// generic function pointer
extern (D) alias void function(Object) fp_t;

extern (C) void _d_callfinalizer(void* p) {
    if(p) {
		ClassInfo **pc = cast(ClassInfo **)p;
		if(*pc) {
			ClassInfo c = **pc;

			//try {
				do {
					if(c.destructor) {
						fp_t fp = cast(fp_t)c.destructor;
						(*fp)(cast(Object)p);		// call destructor
					}
					c = c.base;
				} while (c);
				
				// if monitor is not null
				//if((cast(void**)p)[1]) _d_monitorrelease(cast(Object)p);
			
			//} finally {
			//	*pc = null;			// zero vptr
			//}
		}
    }
}

/// array structure.
struct Array {
	size_t length;
	void* ptr;
}

/// not implemented yet.
extern (C) Array _d_arrayappendT(TypeInfo ti, Array *px, byte[] y) {return *px;}

/// ditto
extern (C) byte[] _d_arraycatnT(TypeInfo ti, uint n, ...) {return (byte[]).init;}

extern (C) void _d_delclass(Object *p)
{
    if (*p)
    {
	version(0)
	{
	    ClassInfo **pc = cast(ClassInfo **)*p;
	    if (*pc)
	    {
		ClassInfo c = **pc;

		if (c.deallocator)
		{
		    _d_callfinalizer(cast(void *)(*p));
		    fp_t fp = cast(fp_t)c.deallocator;
		    (*fp)(*p);			// call deallocator
		    *p = null;
		    return;
		}
	    }
	}
    	
    // not implemented GC
	//_gc.free(cast(void*)(*p));
	*p = null;
    }
}
