﻿
/* NOTE: This file has been patched from the original DMD distribution to
   work with the GDC compiler.

   Modified by David Friedman, September 2004
*/

// Modified by Akira Yamaguchi, June 2007

module std.moduleinit;

//debug = 1;

import object;
import std.string;

enum
{   MIctorstart = 1,	// we've started constructing it
    MIctordone = 2,	// finished construction
    MIstandalone = 4,	// module ctor does not depend on other module
			// ctors being done first
	MIdtorstart = 8,
	MIdtordone = 16,
}

class ModuleInfo {
    char name[];
    ModuleInfo importedModules[];
    ClassInfo localClasses[];

    uint flags;		// initialization state

    void (*ctor)();
    void (*dtor)();
    void (*unitTest)();
}

/+
class ModuleCtorError : Exception
{
    this(ModuleInfo m)
    {
	super("circular initialization dependency with module " ~ m.name);
    }
}
+/


// Win32: this gets initialized by minit.asm
// linux: this gets initialized in _moduleCtor()
extern (C) ModuleInfo[] _moduleinfo_array;

// This linked list is created by a compiler generated function inserted
// into the .ctor list by the compiler.
struct ModuleReference {
	ModuleReference* next;
	ModuleInfo mod;
}

extern(C) ModuleReference* _Dmodule_ref;	// start of linked list

/// Initialize the modules.
extern (C) void _moduleCtor() {
	for(ModuleReference* mr = _Dmodule_ref; mr; mr = mr.next) {
		ModuleInfo m = mr.mod;
		
		if(!m) continue;
		if(m.flags & MIctordone) continue;
		
		if(m.ctor || m.dtor) {
		    if(m.flags & MIctorstart) {
		    	if(m.flags & MIstandalone) continue;
		    	return;
		    }

		    m.flags |= MIctorstart;
		    _moduleCtor2(m.importedModules, 0);
		    if(m.ctor) (*m.ctor)();
		    m.flags &= ~MIctorstart;
		    m.flags |= MIctordone;
		} else {
		    m.flags |= MIctordone;
		    _moduleCtor2(m.importedModules, 1);
		}
	}
}

void _moduleCtor2(ModuleInfo[] mi, int skip) {
    for(uint i = 0; i < mi.length; i++) {
		ModuleInfo m = mi[i];

		if(!m) continue;
		if(m.flags & MIctordone) continue;

		if(m.ctor || m.dtor) {
		    if(m.flags & MIctorstart) {
		    	if(skip || m.flags & MIstandalone) continue;
		    	continue; // error!
		    }

		    m.flags |= MIctorstart;
		    _moduleCtor2(m.importedModules, 0);
		    if(m.ctor) (*m.ctor)();
		    m.flags &= ~MIctorstart;
		    m.flags |= MIctordone;
		} else {
		    m.flags |= MIctordone;
		    _moduleCtor2(m.importedModules, 1);
		}
    }
}


/// Destruct the modules.
extern (C) void _moduleDtor() {
	for(ModuleReference* mr = _Dmodule_ref; mr; mr = mr.next) {
		ModuleInfo m = mr.mod;

		if(!m) continue;
		if(m.flags & MIdtordone) continue;

		if(m.ctor || m.dtor) {
		    if(m.flags & MIdtorstart) {
		    	if(m.flags & MIstandalone) continue;
		    	continue; // error!
		    }

		    m.flags |= MIdtorstart;
		    _moduleCtor2(m.importedModules, 0);
			if(m.dtor) (*m.dtor)();
		    m.flags &= ~MIdtorstart;
		    m.flags |= MIdtordone;
		} else {
		    m.flags |= MIdtordone;
		    _moduleDtor2(m.importedModules, 1);
		}
    }
}

void _moduleDtor2(ModuleInfo[] mi, int skip) {
    for(uint i = 0; i < mi.length; i++) {
		ModuleInfo m = mi[i];

		if(!m) continue;
		if(m.flags & MIdtordone) continue;

		if(m.ctor || m.dtor) {
		    if(m.flags & MIdtorstart) {
		    	if(skip || m.flags & MIstandalone) continue;
		    	continue; // error!
		    }

		    m.flags |= MIdtorstart;
		    _moduleCtor2(m.importedModules, 0);
			if(m.dtor) (*m.dtor)();
		    m.flags &= ~MIdtorstart;
		    m.flags |= MIdtordone;
		} else {
		    m.flags |= MIdtordone;
		    _moduleDtor2(m.importedModules, 1);
		}
    }
}


/// Run unit tests.
extern (C) void _moduleUnitTests() {
	/+
    debug printf("_moduleUnitTests()\n");
    for (uint i = 0; i < _moduleinfo_array.length; i++)
    {
	ModuleInfo m = _moduleinfo_array[i];

	if (!m)
	    continue;

	debug printf("\tmodule[%d] = '%.*s'\n", i, m.name);
	if (m.unitTest)
	{
	    (*m.unitTest)();
	}
    }
	+/
}
