﻿
// Written in the D programming language.

/**
 * String handling functions.
 *
 * To copy or not to copy?
 * When a function takes a string as a parameter, and returns a string,
 * is that string the same as the input string, modified in place, or
 * is it a modified copy of the input string? The D array convention is
 * "copy-on-write". This means that if no modifications are done, the
 * original string (or slices of it) can be returned. If any modifications
 * are done, the returned string is a copy.
 *
 * Macros:
 *	WIKI = Phobos/StdString
 * Copyright:
 *	Public Domain
 */

/* Author:
 *	Walter Bright, Digital Mars, www.digitalmars.com
 */

// The code is not optimized for speed, that will have to wait
// until the design is solidified.

// Modified by Akira Yamaguchi, June 2007

module std.string;

import std.c.string;

const char[16] hexdigits = "0123456789ABCDEF";
const char[10] digits    = "0123456789";
const char[8]  octdigits = "01234567";
const char[26] lowercase = "abcdefghijklmnopqrstuvwxyz";
const char[26] uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char[52] letters   = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
const char[6] whitespace = " \t\v\r\n\f";
const dchar LS = '\u2028';
const dchar PS = '\u2029';

const char[1] newline = "\n";

/// compare string.
int cmp(char[] s1, char[] s2) {
    size_t len = s1.length;
	if(s2.length < len) {
		len = s2.length;
	}
	
	if(int result = memcmp(s1.ptr, s2.ptr, len)) {
		return result;
	}
	
	return cast(int)s1.length - cast(int)s2.length;    
}

/// ignore case cmp.
int icmp(char[] s1, char[] s2) {
    size_t len = s1.length;
	if(s2.length < len) {
		len = s2.length;
	}
	
	for(size_t i = 0; i < len; ++i) {
		char c1 = s1[i];
		if('A' <= c1 && c1 <= 'Z') {
			c1 += ('a' - 'A');
		}
		char c2 = s2[i];
		if('A' <= c2 && c2 <= 'Z') {
			c2 += ('a' - 'A');
		}
		if(int result = c1 - c2) {
			return result;
		}
	}
	
	return cast(int)s1.length - cast(int)s2.length;    
}
