﻿/**
 *	全モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module tutorial;

import std.stdio;
import std.cstream;

import outland.parser.all;
import outland.tl.stack;

int main(char[][] args) {
    
    // 反復子の型。
    alias ArrayIterator!(char) Iterator;

    // 構文規則のプレースホルダ。定義は必須。
    alias .Rule!(Iterator) Rule;
    
    // Ruleの戻り値の型。
    alias Rule.ResultType!(Iterator) Result;
    
    // 整数の戻り値の型。
    alias IntegerParser.ResultType!(Iterator) IntResult;
    
    // 計算用スタック。
    auto stack = new Stack!(int)();
    
    // 整数に当たった時のアクション。
    void onInt(IntResult result) {
        stack.pushBack(cast(int)(result.negative ? -result.value : +result.value));
    }
    
    // 掛け算。
    void onMul(Result result) {
        int rhs = stack.back;
        stack.popBack();
        int lhs = stack.back;
        stack.popBack();
        stack.pushBack(lhs * rhs);
    }
    
    // 割り算。
    void onDiv(Result result) {
        int rhs = stack.back;
        stack.popBack();
        int lhs = stack.back;
        stack.popBack();
        stack.pushBack(lhs / rhs);
    }
    
    // 足し算。
    void onAdd(Result result) {
        int rhs = stack.back;
        stack.popBack();
        int lhs = stack.back;
        stack.popBack();
        stack.pushBack(lhs + rhs);
    }
    
    // 引き算。
    void onSub(Result result) {
        int rhs = stack.back;
        stack.popBack();
        int lhs = stack.back;
        stack.popBack();
        stack.pushBack(lhs - rhs);
    }
    
    // 構文規則のコンパイル。
    mixin(compileRule(import("tutorial.peg")));
    
    // 入力ループ。
    foreach(char[] line; std.cstream.din) {
        // exit入力で終了。
        if(line == "exit") {
            break;
        }
        
        // 式の解析・計算。
        auto r = expression.parse(iterator(line));
        
        // マッチしなかったか全入力を処理できなかったらエラー。
        if(!r.match || line.length != r.length) {
            writefln("error!");
        } else {
            // 計算結果の表示。
            writefln("= %d", stack.back);
        }
        
        // 次の計算に備えてクリア。
        stack.clear();
    }
    
    return 0;
}
