﻿/**
 *	各種アルゴリズムを納めたモジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.tl.algorithm;

/// 置換。
void swap(T)(inout T lhs, inout T rhs) {
	T tmp = lhs;
	lhs = rhs;
	rhs = tmp;
}

/// 小さいほうを返す。
T min(T)(T lhs, T rhs) {return (lhs < rhs) ? lhs : rhs;}

/// 大きいほうを返す。
T max(T)(T lhs, T rhs) {return (lhs < rhs) ? rhs : lhs;}

/// 配列から要素を検索する。見つからなかった場合はlengthが返る。
size_t find(T)(T[] array, T val) {
	foreach(i, v; array) if(v is val) return i;
	return array.length;
}

/// 配列から要素を削除する。
T[] remove(T)(inout T[] array, T val) {
	return removeIf(array, (T v) {return v is val;});
}

/// 配列から要素を削除する。条件式に一致したものが破棄される。
T[] removeIf(T, P)(inout T[] array, P pred) {
	size_t dest = 0;
	foreach(i, v; array) {
		if(pred(v)) continue;
		array[dest++] = v;
	}
	array.length = dest;
	return array;
}
