﻿module outlandkarasu.widget.keyboard;

import outlandkarasu.widget.event;
import outlandkarasu.widget.shape;
import outlandkarasu.widget.widget;

/// キーコード。
typedef uint KeyCode;

/// キーボードイベント基本クラス。
class KeyEvent : Event {
	/**	 イベントコードを指定して生成する。
	 *	Params:
	 *		code	= イベントコード。
	 */
	this(EventCode code) {super(EVENT_ID_USER, code);}
}

/// キーボード操作イベント基本クラス。
class KeyOperationEvent : KeyEvent {
	/**	キーコードを指定して生成する。
	 *	Params:
	 *		code	= イベントコード。
	 *		key	= キーコード。
	 *		rep	= リピートされているかどうか。
	 */
	this(EventCode code, KeyCode key, bool rep) {
		super(code);
		this.key = key;
		this.repeat = rep;
	}
	
	/// キーコード。
	final KeyCode key;
	
	/// リピート。
	final bool repeat;
}

/// キーボード押下イベント。
class KeyDownEvent : KeyOperationEvent {
	/**	生成する。
	 *	Params:
	 *		key	= キーコード。
	 *		rep	= リピートされているかどうか。
	 */
	this(KeyCode key, bool rep) {super(EVENT_CODE_KEY_DOWN, key, rep);}
}

/// キーボード押下イベント。
class KeyUpEvent : KeyOperationEvent {
	/**	生成する。
	 *	Params:
	 *		key	= キーコード。
	 *		rep	= リピートされているかどうか。
	 */
	this(KeyCode key, bool rep) {super(EVENT_CODE_KEY_UP, key, rep);}
}

/// キーボードフォーカス状態イベント基本クラス。
class KeyFocusMoveEvent : KeyEvent {
	/**	フォーカスの移動するウィジェットを指定して生成する。
	 *	Params:
	 *		code	= イベントコード。
	 *		prev	= 以前にフォーカスの当たっていたウィジェット。
	 *		next	= 次にフォーカスの当たるウィジェット。
	 */
	this(EventCode code, IWidget prev, IWidget next) {
		super(code);
		this.preview = prev;
		this.next = next;
	}
	
	/// 以前にフォーカスの当たっていたウィジェット。
	final IWidget preview;
	
	/// 次にフォーカスの当たるウィジェット。
	final IWidget next;
}

/// キーボードフォーカスイベント。
class KeyFocusEvent : KeyFocusMoveEvent {
	/**	生成する。
	 *	Params:
	 *		prev	= 以前にフォーカスの当たっていたウィジェット。
	 *		next	= 次にフォーカスの当たるウィジェット。
	 */
	this(IWidget prev, IWidget next) {
		super(EVENT_CODE_KEY_FOCUS, prev, next);
	}
}

/// キーボードフォーカス解除イベント。
class KeyUnfocusEvent : KeyFocusMoveEvent {
	/**	生成する。
	 *	Params:
	 *		prev	= 以前にフォーカスの当たっていたウィジェット。
	 *		next	= 次にフォーカスの当たるウィジェット。
	 */
	this(IWidget prev, IWidget next) {
		super(EVENT_CODE_KEY_UNFOCUS, prev, next);
	}
}
