﻿module outland.widget.win32.string;

import std.string;
import std.utf;
import std.windows.charset;

import win32.windows;

/// Win32文字列に変換する。
LPCTSTR toTString(char[] str) {
	version(Unicode) {
		return toUTF16z(str);
	} else version(MBCS) {
		return toMBSz(str, CP_OEMCP);
	} else {
		return toStringz(str);
	}
}

/// Win32文字列から変換する。
char[] fromTString(LPCTSTR str) {
	version(Unicode) {
		return toUTF8(str[0 .. lstrlen(str)]);
	} else version(MBCS) {
		return fromMBSz(str, CP_OEMCP);
	} else {
		return str[0 .. lstrlen(str)];
	}
}
