/***********************************************************************\
*                              d3d9types.d                              *
*                                                                       *
*                       Windows API header module                       *
*                                                                       *
*                 Translated from MinGW Windows headers                 *
*                           by Stewart Gordon                           *
*                                                                       *
*                       Placed into public domain                       *
\***********************************************************************/
module win32.d3d9types;

private import win32.basetyps, win32.windef;

// FIXME: check types and grouping of constants
// FIXME: check types of translated macros

align(4):

const D3DCLEAR_TARGET  = 0x01;
const D3DCLEAR_ZBUFFER = 0x02;
const D3DCLEAR_STENCIL = 0x04;
const D3DCLIPPLANE0    = 0x01;
const D3DCLIPPLANE1    = 0x02;
const D3DCLIPPLANE2    = 0x04;
const D3DCLIPPLANE3    = 0x08;
const D3DCLIPPLANE4    = 0x10;
const D3DCLIPPLANE5    = 0x20;

D3DCOLOR D3DCOLOR_ARGB(ubyte a, ubyte r, ubyte g, ubyte b) {
	return (a << 24) | (r << 16) | (g << 8) | b;
}

D3DCOLOR D3DCOLOR_COLORVALUE(real r, real g, real b, real a) {
	return D3DCOLOR_ARGB(cast(ubyte) (a * 255), cast(ubyte) (r * 255),
	  cast(ubyte) (g * 255), cast(ubyte) (b * 255));
}

D3DCOLOR D3DCOLOR_RGBA(ubyte r, ubyte g, ubyte b, ubyte a) {
	return D3DCOLOR_ARGB(a, r, g, b);
}

D3DCOLOR D3DCOLOR_XRGB(ubyte r, ubyte g, ubyte b) {
	return D3DCOLOR_ARGB(0xFF, r, g, b);
}

alias D3DCOLOR_XRGB D3DCOLOR_XYUV;
alias D3DCOLOR_ARGB D3DCOLOR_AYUV;

const D3DCOLORWRITEENABLE_RED   = 0x01;
const D3DCOLORWRITEENABLE_GREEN = 0x02;
const D3DCOLORWRITEENABLE_BLUE  = 0x04;
const D3DCOLORWRITEENABLE_ALPHA = 0x08;

const D3DCS_LEFT   = 0x0001;
const D3DCS_RIGHT  = 0x0002;
const D3DCS_TOP    = 0x0004;
const D3DCS_BOTTOM = 0x0008;
const D3DCS_FRONT  = 0x0010;
const D3DCS_BACK   = 0x0020;
const D3DCS_PLANE0 = 0x0040;
const D3DCS_PLANE1 = 0x0080;
const D3DCS_PLANE2 = 0x0100;
const D3DCS_PLANE3 = 0x0200;
const D3DCS_PLANE4 = 0x0400;
const D3DCS_PLANE5 = 0x0800;
const D3DCS_ALL    = 0x0FFF;

// FIXME: what's this?
//#define D3DDECL_END()  {0xff,0,D3DDECLTYPE_UNUSED,0,0,0}

const D3DDP_MAXTEXCOORD   = 8;
const D3DPV_DONOTCOPYDATA = 1;

enum {
	D3DTA_DIFFUSE,
	D3DTA_CURRENT,
	D3DTA_TEXTURE,
	D3DTA_TFACTOR,
	D3DTA_SPECULAR,
	D3DTA_TEMP,
	D3DTA_CONSTANT,   // =    6
	D3DTA_SELECTMASK     = 0x0f,
	D3DTA_COMPLEMENT     = 0x10,
	D3DTA_ALPHAREPLICATE = 0x20
}


const D3DFVF_RESERVED0     = 0x000001;
const D3DFVF_POSITION_MASK = 0x04000E;

enum {
	D3DFVF_XYZ    = 0x02,
	D3DFVF_XYZRHW = 0x04,
	D3DFVF_XYZB1  = 0x06,
	D3DFVF_XYZB2  = 0x08,
	D3DFVF_XYZB3  = 0x0a,
	D3DFVF_XYZB4  = 0x0c,
	D3DFVF_XYZB5  = 0x0e
}

const D3DFVF_XYZW = 0x4002;

const D3DFVF_NORMAL   = 0x10;
const D3DFVF_PSIZE    = 0x20;
const D3DFVF_DIFFUSE  = 0x40;
const D3DFVF_SPECULAR = 0x80;

const D3DFVF_TEXCOUNT_MASK  = 0x0f00;
const D3DFVF_TEXCOUNT_SHIFT = 8;

enum {
	D3DFVF_TEX0 = 0x0000,
	D3DFVF_TEX1 = 0x0100,
	D3DFVF_TEX2 = 0x0200,
	D3DFVF_TEX3 = 0x0300,
	D3DFVF_TEX4 = 0x0400,
	D3DFVF_TEX5 = 0x0500,
	D3DFVF_TEX6 = 0x0600,
	D3DFVF_TEX7 = 0x0700,
	D3DFVF_TEX8 = 0x0800
}

// FIXME: check types
/+
D3DFVF_TEXCOORDSIZE1(i) {
	return D3DFVF_TEXTUREFORMAT1 << (i * 2 + 16);
}

D3DFVF_TEXCOORDSIZE2(i) {
	return D3DFVF_TEXTUREFORMAT2;
}

D3DFVF_TEXCOORDSIZE3(i) {
	return D3DFVF_TEXTUREFORMAT3 << (i * 2 + 16);
}

D3DFVF_TEXCOORDSIZE4(i) {
	return D3DFVF_TEXTUREFORMAT4 << (i * 2 + 16);
}
+/

enum {
	D3DFVF_TEXTUREFORMAT1 = 3,
	D3DFVF_TEXTUREFORMAT2 = 0,
	D3DFVF_TEXTUREFORMAT3 = 1,
	D3DFVF_TEXTUREFORMAT4 = 2
}

const D3DFVF_LASTBETA_UBYTE4   = 0x1000;
const D3DFVF_LASTBETA_D3DCOLOR = 0x8000;
const D3DFVF_RESERVED2         = 0x6000;

enum {
	D3DDMAPSAMPLER = 256,
	D3DVERTEXTEXTURESAMPLER0,
	D3DVERTEXTEXTURESAMPLER1,
	D3DVERTEXTEXTURESAMPLER2,
	D3DVERTEXTEXTURESAMPLER3
}

const D3DVS_ADDRESSMODE_SHIFT = 13;
const D3DVS_ADDRESSMODE_MASK  = 1 << D3DVS_ADDRESSMODE_SHIFT;
const D3DVS_SWIZZLE_SHIFT     = 16;
const D3DVS_SWIZZLE_MASK      = 0x00FF0000;

enum {
	D3DVS_X_X = 0,
	D3DVS_X_Y = 1 << D3DVS_SWIZZLE_SHIFT,
	D3DVS_X_Z = 2 << D3DVS_SWIZZLE_SHIFT,
	D3DVS_X_W = 3 << D3DVS_SWIZZLE_SHIFT
}

enum {
	D3DVS_Y_X = 0,
	D3DVS_Y_Y = 1 << (D3DVS_SWIZZLE_SHIFT + 2),
	D3DVS_Y_Z = 2 << (D3DVS_SWIZZLE_SHIFT + 2),
	D3DVS_Y_W = 3 << (D3DVS_SWIZZLE_SHIFT + 2)
}

enum {
	D3DVS_Z_X = 0,
	D3DVS_Z_Y = 1 << (D3DVS_SWIZZLE_SHIFT + 4),
	D3DVS_Z_Z = 2 << (D3DVS_SWIZZLE_SHIFT + 4),
	D3DVS_Z_W = 3 << (D3DVS_SWIZZLE_SHIFT + 4)
}

enum {
	D3DVS_W_X = 0,
	D3DVS_W_Y = 1 << (D3DVS_SWIZZLE_SHIFT + 6),
	D3DVS_W_Z = 2 << (D3DVS_SWIZZLE_SHIFT + 6),
	D3DVS_W_W = 3 << (D3DVS_SWIZZLE_SHIFT + 6)
}

const D3DVS_NOSWIZZLE         = D3DVS_X_X | D3DVS_Y_Y | D3DVS_Z_Z | D3DVS_W_W;
const D3DPRESENT_RATE_DEFAULT = 0;
const uint D3DRENDERSTATE_WRAPBIAS = 128;

// FIXME: what are these?
/+
#define D3DSINCOSCONST1  -1.5500992e-006f, -2.1701389e-005f, 0.0026041667f, 0.00026041668f
#define D3DSINCOSCONST2  -0.020833334f, -0.12500000f, 1.0f, 0.50000000f
+/

const D3DSP_OPCODESPECIFICCONTROL_MASK  = 0x00ff0000;
const D3DSP_OPCODESPECIFICCONTROL_SHIFT = 16;
const D3DSP_DCL_USAGE_SHIFT             = 0;
const D3DSP_DCL_USAGE_MASK              = 0x0000000f;
const D3DSP_DCL_USAGEINDEX_SHIFT        = 16;
const D3DSP_DCL_USAGEINDEX_MASK         = 0x000f0000;
const D3DSP_TEXTURETYPE_SHIFT           = 27;
const D3DSP_TEXTURETYPE_MASK            = 0x78000000;
const D3DSP_REGNUM_MASK                 = 0x000007ff;
const D3DSP_WRITEMASK_0                 = 0x00010000;
const D3DSP_WRITEMASK_1                 = 0x00020000;
const D3DSP_WRITEMASK_2                 = 0x00040000;
const D3DSP_WRITEMASK_3                 = 0x00080000;
const D3DSP_WRITEMASK_ALL               = 0x000f0000;
const D3DSP_DSTMOD_SHIFT                = 20;
const D3DSP_DSTMOD_MASK                 = 0x00f00000;

const D3DSHADER_ADDRESSMODE_SHIFT      = 13;
const D3DSHADER_ADDRESSMODE_MASK       = 1 << D3DSHADER_ADDRESSMODE_SHIFT;
const D3DSHADER_COMPARISON_SHIFT       = D3DSP_OPCODESPECIFICCONTROL_SHIFT;
const D3DSHADER_COMPARISON_MASK        = 7 << D3DSHADER_COMPARISON_SHIFT;
const D3DSHADER_INSTRUCTION_PREDICATED = 0x10000000;

const D3DSI_COISSUE            = 0x40000000;
const D3DSI_COMMENTSIZE_SHIFT  = 16;
const D3DSI_COMMENTSIZE_MASK   = 0x7fff0000;
const D3DSI_OPCODE_MASK        = 0x0000ffff;
const D3DSI_INSTLENGTH_MASK    = 0x0f000000;
const D3DSI_INSTLENGTH_SHIFT   = 24;
const D3DSI_TEXLD_PROJECT      = 0x01 << D3DSP_OPCODESPECIFICCONTROL_SHIFT;
const D3DSI_TEXLD_BIAS         = 0x02 << D3DSP_OPCODESPECIFICCONTROL_SHIFT;

enum {
	D3DSPDM_NONE             = 0,
	D3DSPDM_SATURATE         = 1 << D3DSP_DSTMOD_SHIFT,
	D3DSPDM_PARTIALPRECISION = 2 << D3DSP_DSTMOD_SHIFT,
	D3DSPDM_MSAMPCENTROID    = 4 << D3DSP_DSTMOD_SHIFT
}

const D3DSP_DSTSHIFT_SHIFT = 24;
const D3DSP_DSTSHIFT_MASK  = 0x0f000000;
const D3DSP_REGTYPE_SHIFT  = 28;
const D3DSP_REGTYPE_SHIFT2 =  8;
const D3DSP_REGTYPE_MASK   = 0x70000000;
const D3DSP_REGTYPE_MASK2  = 0x00001800;
const D3DSP_SRCMOD_SHIFT   = 24;
const D3DSP_SRCMOD_MASK    = 0x0f000000;
const D3DSP_SWIZZLE_SHIFT  = 16;
const D3DSP_SWIZZLE_MASK   = 0x00ff0000;
const D3DSP_NOSWIZZLE      = (1 << (D3DSP_SWIZZLE_SHIFT + 2))
                           | (2 << (D3DSP_SWIZZLE_SHIFT + 4))
                           | (3 << (D3DSP_SWIZZLE_SHIFT + 6));
const D3DSP_REPLICATERED   = 0;
const D3DSP_REPLICATEGREEN = (1 <<  D3DSP_SWIZZLE_SHIFT)
                           | (1 << (D3DSP_SWIZZLE_SHIFT + 2))
                           | (1 << (D3DSP_SWIZZLE_SHIFT + 4))
                           | (1 << (D3DSP_SWIZZLE_SHIFT + 6));
const D3DSP_REPLICATEBLUE  = (2 <<  D3DSP_SWIZZLE_SHIFT)
                           | (2 << (D3DSP_SWIZZLE_SHIFT + 2))
                           | (2 << (D3DSP_SWIZZLE_SHIFT + 4))
                           | (2 << (D3DSP_SWIZZLE_SHIFT + 6));
const D3DSP_REPLICATEALPHA = (3 <<  D3DSP_SWIZZLE_SHIFT)
                           | (3 << (D3DSP_SWIZZLE_SHIFT + 2))
                           | (3 << (D3DSP_SWIZZLE_SHIFT + 4))
                           | (3 << (D3DSP_SWIZZLE_SHIFT + 6));

enum {
	D3DTSS_TCI_PASSTHRU                    = 0,
	D3DTSS_TCI_CAMERASPACENORMAL           = 0x10000,
	D3DTSS_TCI_CAMERASPACEPOSITION         = 0x20000,
	D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR = 0x30000,
	D3DTSS_TCI_SPHEREMAP                   = 0x40000
}

const D3DUSAGE_RENDERTARGET                   = 0x000001;
const D3DUSAGE_DEPTHSTENCIL                   = 0x000002;
const D3DUSAGE_WRITEONLY                      = 0x000008;
const D3DUSAGE_SOFTWAREPROCESSING             = 0x000010;
const D3DUSAGE_DONOTCLIP                      = 0x000020;
const D3DUSAGE_POINTS                         = 0x000040;
const D3DUSAGE_RTPATCHES                      = 0x000080;
const D3DUSAGE_NPATCHES                       = 0x000100;
const D3DUSAGE_DYNAMIC                        = 0x000200;
const D3DUSAGE_AUTOGENMIPMAP                  = 0x000400;
const D3DUSAGE_DMAP                           = 0x004000;
const D3DUSAGE_QUERY_LEGACYBUMPMAP            = 0x008000;
const D3DUSAGE_QUERY_SRGBREAD                 = 0x010000;
const D3DUSAGE_QUERY_FILTER                   = 0x020000;
const D3DUSAGE_QUERY_SRGBWRITE                = 0x040000;
const D3DUSAGE_QUERY_POSTPIXELSHADER_BLENDING = 0x080000;
const D3DUSAGE_QUERY_VERTEXTEXTURE            = 0x100000;

const D3DWRAP_U = 1;
const D3DWRAP_V = 2;
const D3DWRAP_W = 4;

const D3DWRAPCOORD_0 = 1;
const D3DWRAPCOORD_1 = 2;
const D3DWRAPCOORD_2 = 4;
const D3DWRAPCOORD_3 = 8;

const MAX_DEVICE_IDENTIFIER_STRING       = 512;
const MAXD3DDECLLENGTH                   =  64;
const MAXD3DDECLUSAGEINDEX               =  15;
const D3DMAXUSERCLIPPLANES               =  32;
const D3D_MAX_SIMULTANEOUS_RENDERTARGETS =   4;

uint D3DPS_VERSION(ubyte major, ubyte minor) {
	return 0xFFFF0000 | (major << 8) | minor;
}

uint D3DVS_VERSION(ubyte major, ubyte minor) {
	return 0xFFFE0000 | (major << 8) | minor;
}

ubyte D3DSHADER_VERSION_MAJOR(uint vers) {
	return cast(ubyte) (vers >> 8);
}

ubyte D3DSHADER_VERSION_MINOR(uint vers) {
	return cast(ubyte) vers;
}

// FIXME: check types
/+
D3DSHADER_COMMENT(s) {
	return ((s << D3DSI_COMMENTSIZE_SHIFT) & D3DSI_COMMENTSIZE_MASK)
	  | D3DSIO_COMMENT;
}
+/

// originally macros with ()
const D3DPS_END = 0xFFFF;
const D3DVS_END = 0xFFFF;

const D3DPRESENTFLAG_LOCKABLE_BACKBUFFER  = 0x01;
const D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL = 0x02;
const D3DPRESENTFLAG_DEVICECLIP           = 0x04;
const D3DPRESENTFLAG_VIDEO                = 0x10;

const D3DLOCK_READONLY        = 0x0010;
const D3DLOCK_NOSYSLOCK       = 0x0800;
const D3DLOCK_NOOVERWRITE     = 0x1000;
const D3DLOCK_DISCARD         = 0x2000;
const D3DLOCK_DONOTWAIT       = 0x4000;
const D3DLOCK_NO_DIRTY_UPDATE = 0x8000;

const D3DISSUE_END   = 1;
const D3DISSUE_BEGIN = 2;

const D3DGETDATA_FLUSH = 1;

DWORD MAKEFOURCC(char a, char b, char c, char d) {
	return a | (b << 8) | (c << 16) | (d << 24);
}

alias DWORD D3DCOLOR;

enum D3DBACKBUFFER_TYPE {
	D3DBACKBUFFER_TYPE_MONO,
	D3DBACKBUFFER_TYPE_LEFT,
	D3DBACKBUFFER_TYPE_RIGHT,
	D3DBACKBUFFER_TYPE_FORCE_DWORD = 0xffffffff
}

enum D3DBASISTYPE {
	D3DBASIS_BEZIER,
	D3DBASIS_BSPLINE,
	D3DBASIS_INTERPOLATE,
	D3DBASIS_FORCE_DWORD = 0xffffffff
}

enum D3DBLEND {
	D3DBLEND_ZERO       = 1,
	D3DBLEND_ONE,
	D3DBLEND_SRCCOLOR,
	D3DBLEND_INVSRCCOLOR,
	D3DBLEND_SRCALPHA,
	D3DBLEND_INVSRCALPHA,
	D3DBLEND_DESTALPHA,
	D3DBLEND_INVDESTALPHA,
	D3DBLEND_DESTCOLOR,
	D3DBLEND_INVDESTCOLOR,
	D3DBLEND_SRCALPHASAT,
	D3DBLEND_BOTHSRCALPHA,
	D3DBLEND_BOTHINVSRCALPHA,
	D3DBLEND_BLENDFACTOR,
	D3DBLEND_INVBLENDFACTOR, // = 15
	D3DBLEND_FORCE_DWORD = 0xffffffff
}

enum D3DBLENDOP {
	D3DBLENDOP_ADD      = 1,
	D3DBLENDOP_SUBTRACT,
	D3DBLENDOP_REVSUBTRACT,
	D3DBLENDOP_MIN,
	D3DBLENDOP_MAX,     // = 5
	D3DBLENDOP_FORCE_DWORD = 0x7fffffff
}

enum D3DCMPFUNC {
	D3DCMP_NEVER       = 1,
	D3DCMP_LESS,
	D3DCMP_EQUAL,
	D3DCMP_LESSEQUAL,
	D3DCMP_GREATER,
	D3DCMP_NOTEQUAL,
	D3DCMP_GREATEREQUAL,
	D3DCMP_ALWAYS,  // = 8
	D3DCMP_FORCE_DWORD = 0xffffffff
}

enum D3DCUBEMAP_FACES {
	D3DCUBEMAP_FACE_POSITIVE_X,
	D3DCUBEMAP_FACE_NEGATIVE_X,
	D3DCUBEMAP_FACE_POSITIVE_Y,
	D3DCUBEMAP_FACE_NEGATIVE_Y,
	D3DCUBEMAP_FACE_POSITIVE_Z,
	D3DCUBEMAP_FACE_NEGATIVE_Z, // = 5
	D3DCUBEMAP_FACE_FORCE_DWORD = 0xffffffff
}

enum D3DCULL {
	D3DCULL_NONE        = 1,
	D3DCULL_CW,
	D3DCULL_CCW,
	D3DCULL_FORCE_DWORD = 0xffffffff
}

enum D3DDEBUGMONITORTOKENS {
	D3DDMT_ENABLE,
	D3DDMT_DISABLE,
	D3DDMT_FORCE_DWORD = 0xffffffff
}

enum D3DDECLMETHOD {
	D3DDECLMETHOD_DEFAULT,
	D3DDECLMETHOD_PARTIALU,
	D3DDECLMETHOD_PARTIALV,
	D3DDECLMETHOD_CROSSUV,
	D3DDECLMETHOD_UV,
	D3DDECLMETHOD_LOOKUP,
	D3DDECLMETHOD_LOOKUPPRESAMPLED // = 6
}

enum D3DDECLTYPE {
	D3DDECLTYPE_FLOAT1,
	D3DDECLTYPE_FLOAT2,
	D3DDECLTYPE_FLOAT3,
	D3DDECLTYPE_FLOAT4,
	D3DDECLTYPE_D3DCOLOR,
	D3DDECLTYPE_UBYTE4,
	D3DDECLTYPE_SHORT2,
	D3DDECLTYPE_SHORT4,
	D3DDECLTYPE_UBYTE4N,
	D3DDECLTYPE_SHORT2N,
	D3DDECLTYPE_SHORT4N,
	D3DDECLTYPE_USHORT2N,
	D3DDECLTYPE_USHORT4N,
	D3DDECLTYPE_UDEC3,
	D3DDECLTYPE_DEC3N,
	D3DDECLTYPE_FLOAT16_2,
	D3DDECLTYPE_FLOAT16_4,
	D3DDECLTYPE_UNUSED // = 17
}

enum D3DDECLUSAGE {
	D3DDECLUSAGE_POSITION,
	D3DDECLUSAGE_BLENDWEIGHT,
	D3DDECLUSAGE_BLENDINDICES,
	D3DDECLUSAGE_NORMAL,
	D3DDECLUSAGE_PSIZE,
	D3DDECLUSAGE_TEXCOORD,
	D3DDECLUSAGE_TANGENT,
	D3DDECLUSAGE_BINORMAL,
	D3DDECLUSAGE_TESSFACTOR,
	D3DDECLUSAGE_POSITIONT,
	D3DDECLUSAGE_COLOR,
	D3DDECLUSAGE_FOG,
	D3DDECLUSAGE_DEPTH,
	D3DDECLUSAGE_SAMPLE // = 13
}

const MAXD3DDECLMETHOD = D3DDECLMETHOD.D3DDECLMETHOD_LOOKUPPRESAMPLED;
const MAXD3DDECLTYPE   = D3DDECLTYPE.D3DDECLTYPE_UNUSED;
const MAXD3DDECLUSAGE  = D3DDECLUSAGE.D3DDECLUSAGE_SAMPLE;

enum D3DDEGREETYPE {
	D3DDEGREE_LINEAR    = 1,
	D3DDEGREE_QUADRATIC,
	D3DDEGREE_CUBIC,   // = 3
	D3DDEGREE_QUINTIC   = 5,
	D3DDEGREE_FORCE_DWORD = 0xffffffff
}

enum D3DDEVTYPE {
	D3DDEVTYPE_HAL      = 1,
	D3DDEVTYPE_REF,
	D3DDEVTYPE_SW,
	D3DDEVTYPE_FORCE_DWORD = 0xffffffff
}

enum D3DFILLMODE {
	D3DFILL_POINT       = 1,
	D3DFILL_WIREFRAME,
	D3DFILL_SOLID,
	D3DFILL_FORCE_DWORD = 0xffffffff
}

enum D3DFOGMODE {
	D3DFOG_NONE,
	D3DFOG_EXP,
	D3DFOG_EXP2,
	D3DFOG_LINEAR,
	D3DFOG_FORCE_DWORD = 0xffffffff
}

enum D3DFORMAT {
	D3DFMT_UNKNOWN       =   0,
	D3DFMT_R8G8B8        =  20,
	D3DFMT_A8R8G8B8,
	D3DFMT_X8R8G8B8,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,
	D3DFMT_R3G3B2,
	D3DFMT_A8,
	D3DFMT_A8R3G3B2,
	D3DFMT_X4R4G4B4,
	D3DFMT_A2B10G10R10,
	D3DFMT_A8B8G8R8,
	D3DFMT_X8B8G8R8,
	D3DFMT_G16R16,
	D3DFMT_A2R10G10B10,
	D3DFMT_A16B16G16R16, // = 36
	D3DFMT_A8P8          =  40,
	D3DFMT_P8,        // =  41
	D3DFMT_L8            =  50,
	D3DFMT_A8L8,
	D3DFMT_A4L4,      // =  52
	D3DFMT_V8U8          =  60,
	D3DFMT_L6V5U5,
	D3DFMT_X8L8V8U8,
	D3DFMT_Q8W8V8U8,
	D3DFMT_V16U16,    // =  64
	D3DFMT_A2W10V10U10   =  67,
	D3DFMT_D16_LOCKABLE  =  70,
	D3DFMT_D32,       // =  71
	D3DFMT_D15S1         =  73,
	D3DFMT_D24S8         =  75,
	D3DFMT_D24X8         =  77,
	D3DFMT_D24X4S4       =  79,
	D3DFMT_D16,
	D3DFMT_L16,
	D3DFMT_D32F_LOCKABLE,
	D3DFMT_D24FS8,    // =  83
	D3DFMT_VERTEXDATA    = 100,
	D3DFMT_INDEX16,
	D3DFMT_INDEX32,   // = 102
	D3DFMT_Q16W16V16U16  = 110,
	D3DFMT_R16F,
	D3DFMT_G16R16F,
	D3DFMT_A16B16G16R16F,
	D3DFMT_R32F,
	D3DFMT_G32R32F,
	D3DFMT_A32B32G32R32F,
	D3DFMT_CxV8U8,    // = 117

	D3DFMT_UYVY          = 0x59565955, // = MAKEFOURCC('U','Y','V','Y')
	D3DFMT_R8G8_B8G8     = 0x47424752, // = MAKEFOURCC('R','G','B','G')
	D3DFMT_YUY2          = 0x32595559, // = MAKEFOURCC('Y','U','Y','2')
	D3DFMT_G8R8_G8B8     = 0x42475247, // = MAKEFOURCC('G','R','G','B')
	D3DFMT_DXT1          = 0x31545844, // = MAKEFOURCC('D','X','T','1')
	D3DFMT_DXT2          = 0x32545844, // = MAKEFOURCC('D','X','T','2')
	D3DFMT_DXT3          = 0x33545844, // = MAKEFOURCC('D','X','T','3')
	D3DFMT_DXT4          = 0x34545844, // = MAKEFOURCC('D','X','T','4')
	D3DFMT_DXT5          = 0x35545844, // = MAKEFOURCC('D','X','T','5')
	D3DFMT_MULTI2_ARGB8  = 0x3154454d, // = MAKEFOURCC('M','E','T','1')

	D3DFMT_FORCE_DWORD   = 0xffffffff
}

enum D3DLIGHTTYPE {
	D3DLIGHT_POINT       = 1,
	D3DLIGHT_SPOT        = 2,
	D3DLIGHT_DIRECTIONAL = 3,
	D3DLIGHT_FORCE_DWORD = 0xffffffff
}

enum D3DMATERIALCOLORSOURCE {
	D3DMCS_MATERIAL    = 0,
	D3DMCS_COLOR1      = 1,
	D3DMCS_COLOR2      = 2,
	D3DMCS_FORCE_DWORD = 0xffffffff
}

enum D3DMULTISAMPLE_TYPE {
	D3DMULTISAMPLE_NONE,
	D3DMULTISAMPLE_NONMASKABLE,
	D3DMULTISAMPLE_2_SAMPLES,
	D3DMULTISAMPLE_3_SAMPLES,
	D3DMULTISAMPLE_4_SAMPLES,
	D3DMULTISAMPLE_5_SAMPLES,
	D3DMULTISAMPLE_6_SAMPLES,
	D3DMULTISAMPLE_7_SAMPLES,
	D3DMULTISAMPLE_8_SAMPLES,
	D3DMULTISAMPLE_9_SAMPLES,
	D3DMULTISAMPLE_10_SAMPLES,
	D3DMULTISAMPLE_11_SAMPLES,
	D3DMULTISAMPLE_12_SAMPLES,
	D3DMULTISAMPLE_13_SAMPLES,
	D3DMULTISAMPLE_14_SAMPLES,
	D3DMULTISAMPLE_15_SAMPLES,
	D3DMULTISAMPLE_16_SAMPLES,
	D3DMULTISAMPLE_FORCE_DWORD = 0xffffffff
}

enum D3DORDERTYPE {
	D3DORDER_LINEAR     = 1,
	D3DORDER_QUADRATIC,
	D3DORDER_CUBIC,  // = 3
	D3DORDER_QUINTIC    = 5,
	D3DORDER_FORCE_DWORD = 0xffffffff
}

enum D3DPATCHEDGESTYLE {
	D3DPATCHEDGE_DISCRETE    = 0,
	D3DPATCHEDGE_CONTINUOUS  = 1,
	D3DPATCHEDGE_FORCE_DWORD = 0xffffffff
}

enum D3DPOOL {
	D3DPOOL_DEFAULT,
	D3DPOOL_MANAGED,
	D3DPOOL_SYSTEMMEM,
	D3DPOOL_SCRATCH,
	D3DPOOL_FORCE_DWORD = 0xffffffff
}

enum D3DPRIMITIVETYPE {
	D3DPT_POINTLIST   = 1,
	D3DPT_LINELIST,
	D3DPT_LINESTRIP,
	D3DPT_TRIANGLELIST,
	D3DPT_TRIANGLESTRIP,
	D3DPT_TRIANGLEFAN, // = 6
	D3DPT_FORCE_DWORD = 0xffffffff
}

enum D3DQUERYTYPE {
	D3DQUERYTYPE_VCACHE = 4,
	D3DQUERYTYPE_RESOURCEMANAGER = 5,
	D3DQUERYTYPE_VERTEXSTATS     = 6,
	D3DQUERYTYPE_EVENT  = 8,
	D3DQUERYTYPE_OCCLUSION       = 9
}

enum D3DRENDERSTATETYPE {
	D3DRS_ZENABLE                    =   7,
	D3DRS_FILLMODE,
	D3DRS_SHADEMODE,              // =   9
	D3DRS_ZWRITEENABLE               =  14,
	D3DRS_ALPHATESTENABLE,
	D3DRS_LASTPIXEL,              // =  16
	D3DRS_SRCBLEND                   =  19,
	D3DRS_DESTBLEND,              // =  20
	D3DRS_CULLMODE                   =  22,
	D3DRS_ZFUNC,
	D3DRS_ALPHAREF,
	D3DRS_ALPHAFUNC,
	D3DRS_DITHERENABLE,
	D3DRS_ALPHABLENDENABLE,
	D3DRS_FOGENABLE,
	D3DRS_SPECULARENABLE,         // =  29
	D3DRS_FOGCOLOR                   =  34,
	D3DRS_FOGTABLEMODE,
	D3DRS_FOGSTART,
	D3DRS_FOGEND,
	D3DRS_FOGDENSITY,             // =  38
	D3DRS_RANGEFOGENABLE             =  48,
	D3DRS_STENCILENABLE              =  52,
	D3DRS_STENCILFAIL,
	D3DRS_STENCILZFAIL,
	D3DRS_STENCILPASS,
	D3DRS_STENCILFUNC,
	D3DRS_STENCILREF,
	D3DRS_STENCILMASK,
	D3DRS_STENCILWRITEMASK,
	D3DRS_TEXTUREFACTOR,          // =  60
	D3DRS_WRAP0                      = 128,
	D3DRS_WRAP1,
	D3DRS_WRAP2,
	D3DRS_WRAP3,
	D3DRS_WRAP4,
	D3DRS_WRAP5,
	D3DRS_WRAP6,
	D3DRS_WRAP7,
	D3DRS_CLIPPING,
	D3DRS_LIGHTING,               // = 137
	D3DRS_AMBIENT                    = 139,
	D3DRS_FOGVERTEXMODE,
	D3DRS_COLORVERTEX,
	D3DRS_LOCALVIEWER,
	D3DRS_NORMALIZENORMALS,       // = 143
	D3DRS_DIFFUSEMATERIALSOURCE      = 145,
	D3DRS_SPECULARMATERIALSOURCE,
	D3DRS_AMBIENTMATERIALSOURCE,
	D3DRS_EMISSIVEMATERIALSOURCE, // = 148
	D3DRS_VERTEXBLEND                = 151,
	D3DRS_CLIPPLANEENABLE,        // = 152
	D3DRS_POINTSIZE                  = 154,
	D3DRS_POINTSIZE_MIN,
	D3DRS_POINTSPRITEENABLE,
	D3DRS_POINTSCALEENABLE,
	D3DRS_POINTSCALE_A,
	D3DRS_POINTSCALE_B,
	D3DRS_POINTSCALE_C,
	D3DRS_MULTISAMPLEANTIALIAS,
	D3DRS_MULTISAMPLEMASK,
	D3DRS_PATCHEDGESTYLE,         // = 163
	D3DRS_DEBUGMONITORTOKEN          = 165,
	D3DRS_POINTSIZE_MAX,
	D3DRS_INDEXEDVERTEXBLENDENABLE,
	D3DRS_COLORWRITEENABLE,       // = 168
	D3DRS_TWEENFACTOR                = 170,
	D3DRS_BLENDOP,
	D3DRS_POSITIONDEGREE,
	D3DRS_NORMALDEGREE,
	D3DRS_SCISSORTESTENABLE,
	D3DRS_SLOPESCALEDEPTHBIAS,
	D3DRS_ANTIALIASEDLINEENABLE,  // = 176
	D3DRS_MINTESSELLATIONLEVEL       = 178,
	D3DRS_MAXTESSELLATIONLEVEL,
	D3DRS_ADAPTIVETESS_X,
	D3DRS_ADAPTIVETESS_Y,
	D3DRS_ADAPTIVETESS_Z,
	D3DRS_ADAPTIVETESS_W,
	D3DRS_ENABLEADAPTIVETESSELLATION,
	D3DRS_TWOSIDEDSTENCILMODE,
	D3DRS_CCW_STENCILFAIL,
	D3DRS_CCW_STENCILZFAIL,
	D3DRS_CCW_STENCILPASS,
	D3DRS_CCW_STENCILFUNC,
	D3DRS_COLORWRITEENABLE1,
	D3DRS_COLORWRITEENABLE2,
	D3DRS_COLORWRITEENABLE3,
	D3DRS_BLENDFACTOR,
	D3DRS_SRGBWRITEENABLE,
	D3DRS_DEPTHBIAS,              // = 195
	D3DRS_WRAP8                      = 198,
	D3DRS_WRAP9,
	D3DRS_WRAP10,
	D3DRS_WRAP11,
	D3DRS_WRAP12,
	D3DRS_WRAP13,
	D3DRS_WRAP14,
	D3DRS_WRAP15,
	D3DRS_SEPARATEALPHABLENDENABLE,
	D3DRS_SRCBLENDALPHA,
	D3DRS_DESTBLENDALPHA,
	D3DRS_BLENDOPALPHA,           // = 209
	D3DRS_FORCE_DWORD                = 0xffffffff
}

enum D3DRESOURCETYPE {
	D3DRTYPE_SURFACE         = 1,
	D3DRTYPE_VOLUME,
	D3DRTYPE_TEXTURE,
	D3DRTYPE_VOLUMETEXTURE,
	D3DRTYPE_CUBETEXTURE,
	D3DRTYPE_VERTEXBUFFER,
	D3DRTYPE_INDEXBUFFER, // = 7
	D3DRTYPE_FORCE_DWORD     = 0xffffffff
}

const D3DRTYPECOUNT = D3DRESOURCETYPE.D3DRTYPE_INDEXBUFFER + 1;

enum D3DSAMPLER_TEXTURE_TYPE {
	D3DSTT_UNKNOWN     = 0,
	D3DSTT_2D          = 2 << D3DSP_TEXTURETYPE_SHIFT,
	D3DSTT_CUBE        = 3 << D3DSP_TEXTURETYPE_SHIFT,
	D3DSTT_VOLUME      = 4 << D3DSP_TEXTURETYPE_SHIFT,
	D3DSTT_FORCE_DWORD = 0xffffffff
}

enum D3DSAMPLERSTATETYPE {
	D3DSAMP_ADDRESSU    = 1,
	D3DSAMP_ADDRESSV,
	D3DSAMP_ADDRESSW,
	D3DSAMP_BORDERCOLOR,
	D3DSAMP_MAGFILTER,
	D3DSAMP_MINFILTER,
	D3DSAMP_MIPFILTER,
	D3DSAMP_MIPMAPLODBIAS,
	D3DSAMP_MAXMIPLEVEL,
	D3DSAMP_MAXANISOTROPY,
	D3DSAMP_SRGBTEXTURE,
	D3DSAMP_ELEMENTINDEX,
	D3DSAMP_DMAPOFFSET, // = 13
	D3DSAMP_FORCE_DWORD = 0xffffffff
}

enum D3DSHADEMODE {
	D3DSHADE_FLAT       = 1,
	D3DSHADE_GOURAUD,
	D3DSHADE_PHONG,
	D3DSHADE_FORCE_DWORD = 0xffffffff
}

enum D3DSHADER_ADDRESSMODE_TYPE {
	D3DSHADER_ADDRMODE_ABSOLUTE    = 0,
	D3DSHADER_ADDRMODE_RELATIVE    = 1 << D3DSHADER_ADDRESSMODE_SHIFT,
	D3DSHADER_ADDRMODE_FORCE_DWORD = 0xffffffff
}

enum D3DSHADER_COMPARISON {
	D3DSPC_RESERVED0 = 0,
	D3DSPC_GT,
	D3DSPC_EQ,
	D3DSPC_GE,
	D3DSPC_LT,
	D3DSPC_NE,
	D3DSPC_LE,
	D3DSPC_RESERVED1 // = 7
}

enum D3DSHADER_INSTRUCTION_OPCODE_TYPE {
	D3DSIO_NOP,
	D3DSIO_MOV,
	D3DSIO_ADD,
	D3DSIO_SUB,
	D3DSIO_MAD,
	D3DSIO_MUL,
	D3DSIO_RCP,
	D3DSIO_RSQ,
	D3DSIO_DP3,
	D3DSIO_DP4,
	D3DSIO_MIN,
	D3DSIO_MAX,
	D3DSIO_SLT,
	D3DSIO_SGE,
	D3DSIO_EXP,
	D3DSIO_LOG,
	D3DSIO_LIT,
	D3DSIO_DST,
	D3DSIO_LRP,
	D3DSIO_FRC,
	D3DSIO_M4x4,
	D3DSIO_M4x3,
	D3DSIO_M3x4,
	D3DSIO_M3x3,
	D3DSIO_M3x2,
	D3DSIO_CALL,
	D3DSIO_CALLNZ,
	D3DSIO_LOOP,
	D3DSIO_RET,
	D3DSIO_ENDLOOP,
	D3DSIO_LABEL,
	D3DSIO_DCL,
	D3DSIO_POW,
	D3DSIO_CRS,
	D3DSIO_SGN,
	D3DSIO_ABS,
	D3DSIO_NRM,
	D3DSIO_SINCOS,
	D3DSIO_REP,
	D3DSIO_ENDREP,
	D3DSIO_IF,
	D3DSIO_IFC,
	D3DSIO_ELSE,
	D3DSIO_ENDIF,
	D3DSIO_BREAK,
	D3DSIO_BREAKC,
	D3DSIO_MOVA,
	D3DSIO_DEFB,
	D3DSIO_DEFI,    // = 48
	D3DSIO_TEXCOORD    = 64,
	D3DSIO_TEXKILL,
	D3DSIO_TEX,
	D3DSIO_TEXBEM,
	D3DSIO_TEXBEML,
	D3DSIO_TEXREG2AR,
	D3DSIO_TEXREG2GB,
	D3DSIO_TEXM3x2PAD,
	D3DSIO_TEXM3x2TEX,
	D3DSIO_TEXM3x3PAD,
	D3DSIO_TEXM3x3TEX,
	D3DSIO_RESERVED0,
	D3DSIO_TEXM3x3SPEC,
	D3DSIO_TEXM3x3VSPEC,
	D3DSIO_EXPP,
	D3DSIO_LOGP,
	D3DSIO_CND,
	D3DSIO_DEF,
	D3DSIO_TEXREG2RGB,
	D3DSIO_TEXDP3TEX,
	D3DSIO_TEXM3x2DEPTH,
	D3DSIO_TEXDP3,
	D3DSIO_TEXM3x3,
	D3DSIO_TEXDEPTH,
	D3DSIO_CMP,
	D3DSIO_BEM,
	D3DSIO_DP2ADD,
	D3DSIO_DSX,
	D3DSIO_DSY,
	D3DSIO_TEXLDD,
	D3DSIO_SETP,
	D3DSIO_TEXLDL,
	D3DSIO_BREAKP,  // = 96
	D3DSIO_PHASE       = 0x0000fffd,
	D3DSIO_COMMENT,
	D3DSIO_END,
	D3DSIO_FORCE_DWORD = 0xffffffff
}

enum D3DSHADER_MISCTYPE_OFFSETS {
	D3DSMO_POSITION,
	D3DSMO_FACE
}

enum D3DSHADER_PARAM_REGISTER_TYPE {
	D3DSPR_TEMP,
	D3DSPR_INPUT,
	D3DSPR_CONST,
	D3DSPR_ADDR,
	D3DSPR_TEXTURE      = D3DSPR_ADDR,
	D3DSPR_RASTOUT,
	D3DSPR_ATTROUT,
	D3DSPR_TEXCRDOUT,
	D3DSPR_OUTPUT       = D3DSPR_TEXCRDOUT,
	D3DSPR_CONSTINT,
	D3DSPR_COLOROUT,
	D3DSPR_DEPTHOUT,
	D3DSPR_SAMPLER,
	D3DSPR_CONST2,
	D3DSPR_CONST3,
	D3DSPR_CONST4,
	D3DSPR_CONSTBOOL,
	D3DSPR_LOOP,
	D3DSPR_TEMPFLOAT16,
	D3DSPR_MISCTYPE,
	D3DSPR_LABEL,
	D3DSPR_PREDICATE, // = 19
	D3DSPR_FORCE_DWORD  = 0xffffffff
}

enum D3DSHADER_PARAM_SRCMOD_TYPE {
	D3DSPSM_NONE        = 0,
	D3DSPSM_NEG         = 1 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_BIAS        = 2 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_BIASNEG     = 3 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_SIGN        = 4 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_SIGNNEG     = 5 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_COMP        = 6 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_X2          = 7 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_X2NEG       = 8 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_DZ          = 9 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_DW          = 10 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_ABS         = 11 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_ABSNEG      = 12 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_NOT         = 13 << D3DSP_SRCMOD_SHIFT,
	D3DSPSM_FORCE_DWORD = 0xffffffff
}

enum D3DVS_ADDRESSMODE_TYPE {
	D3DVS_ADDRMODE_ABSOLUTE    = 0,
	D3DVS_ADDRMODE_RELATIVE    = 1 << D3DVS_ADDRESSMODE_SHIFT,
	D3DVS_ADDRMODE_FORCE_DWORD = 0xffffffff
}

enum D3DVS_RASTOUT_OFFSETS {
	D3DSRO_POSITION,
	D3DSRO_FOG,
	D3DSRO_POINT_SIZE,
	D3DSRO_FORCE_DWORD = 0xffffffff
}

enum D3DSTENCILOP {
	D3DSTENCILOP_KEEP        = 1,
	D3DSTENCILOP_ZERO,
	D3DSTENCILOP_REPLACE,
	D3DSTENCILOP_INCRSAT,
	D3DSTENCILOP_DECRSAT,
	D3DSTENCILOP_INVERT,
	D3DSTENCILOP_INCR,
	D3DSTENCILOP_DECR,    // = 8
	D3DSTENCILOP_FORCE_DWORD = 0x7fffffff
}

enum D3DSTATEBLOCKTYPE {
	D3DSBT_ALL         = 1,
	D3DSBT_PIXELSTATE,
	D3DSBT_VERTEXSTATE,
	D3DSBT_FORCE_DWORD = 0xffffffff
}

enum D3DSWAPEFFECT {
	D3DSWAPEFFECT_DISCARD     = 1,
	D3DSWAPEFFECT_FLIP,
	D3DSWAPEFFECT_COPY,
	D3DSWAPEFFECT_COPY_VSYNC,
	D3DSWAPEFFECT_FORCE_DWORD = 0xffffffff
}

enum D3DTEXTUREADDRESS {
	D3DTADDRESS_WRAP        = 1,
	D3DTADDRESS_MIRROR,
	D3DTADDRESS_CLAMP,
	D3DTADDRESS_BORDER,
	D3DTADDRESS_MIRRORONCE,
	D3DTADDRESS_FORCE_DWORD = 0xffffffff
}

enum D3DTEXTUREFILTERTYPE {
	D3DTEXF_NONE,
	D3DTEXF_POINT,
	D3DTEXF_LINEAR,
	D3DTEXF_ANISOTROPIC,
	D3DTEXF_PYRAMIDALQUAD = 6,
	D3DTEXF_GAUSSIANQUAD,
	D3DTEXF_FORCE_DWORD   = 0xffffffff
}

enum D3DTEXTURESTAGESTATETYPE {
	D3DTSS_COLOROP           =  1,
	D3DTSS_COLORARG1,
	D3DTSS_COLORARG2,
	D3DTSS_ALPHAOP,
	D3DTSS_ALPHAARG1,
	D3DTSS_ALPHAARG2,
	D3DTSS_BUMPENVMAT00,
	D3DTSS_BUMPENVMAT01,
	D3DTSS_BUMPENVMAT10,
	D3DTSS_BUMPENVMAT11,
	D3DTSS_TEXCOORDINDEX, // = 11
	D3DTSS_BUMPENVLSCALE     = 22,
	D3DTSS_BUMPENVLOFFSET,
	D3DTSS_TEXTURETRANSFORMFLAGS,
	D3DTSS_ADDRESSW,
	D3DTSS_COLORARG0,
	D3DTSS_ALPHAARG0,
	D3DTSS_RESULTARG,     // = 28
	D3DTSS_CONSTANT          = 32,
	D3DTSS_FORCE_DWORD       = 0xffffffff
}

enum D3DTEXTUREOP {
	D3DTOP_DISABLE     = 1,
	D3DTOP_SELECTARG1,
	D3DTOP_SELECTARG2,
	D3DTOP_MODULATE,
	D3DTOP_MODULATE2X,
	D3DTOP_MODULATE4X,
	D3DTOP_ADD,
	D3DTOP_ADDSIGNED,
	D3DTOP_ADDSIGNED2X,
	D3DTOP_SUBTRACT,
	D3DTOP_ADDSMOOTH,
	D3DTOP_BLENDDIFFUSEALPHA,
	D3DTOP_BLENDTEXTUREALPHA,
	D3DTOP_BLENDFACTORALPHA,
	D3DTOP_BLENDTEXTUREALPHAPM,
	D3DTOP_BLENDCURRENTALPHA,
	D3DTOP_PREMODULATE,
	D3DTOP_MODULATEALPHA_ADDCOLOR,
	D3DTOP_MODULATECOLOR_ADDALPHA,
	D3DTOP_MODULATEINVALPHA_ADDCOLOR,
	D3DTOP_MODULATEINVCOLOR_ADDALPHA,
	D3DTOP_BUMPENVMAP,
	D3DTOP_BUMPENVMAPLUMINANCE,
	D3DTOP_DOTPRODUCT3,
	D3DTOP_MULTIPLYADD,
	D3DTOP_LERP,
	D3DTOP_FORCE_DWORD = 0xffffffff,
}

enum D3DTEXTURETRANSFORMFLAGS {
	D3DTTFF_DISABLE,
	D3DTTFF_COUNT1,
	D3DTTFF_COUNT2,
	D3DTTFF_COUNT3,
	D3DTTFF_COUNT4,
	D3DTTFF_PROJECTED   = 256,
	D3DTTFF_FORCE_DWORD = 0xffffffff
}

enum D3DTRANSFORMSTATETYPE {
	D3DTS_VIEW         =   2,
	D3DTS_PROJECTION,
	D3DTS_TEXTURE0     =  16,
	D3DTS_TEXTURE1,
	D3DTS_TEXTURE2,
	D3DTS_TEXTURE3,
	D3DTS_TEXTURE4,
	D3DTS_TEXTURE5,
	D3DTS_TEXTURE6,
	D3DTS_TEXTURE7, // =  23
	D3DTS_WORLD        = 256, // = D3DTS_WORLDMATRIX(0)
	D3DTS_WORLD1,
	D3DTS_WORLD2,
	D3DTS_WORLD3,             // = D3DTS_WORLDMATRIX(3)
	D3DTS_FORCE_DWORD  = 0xffffffff
}

// FIXME: check type of index
D3DTRANSFORMSTATETYPE D3DTS_WORLDMATRIX(int index) {
	return cast(D3DTRANSFORMSTATETYPE) (index + 256);
}

enum D3DVERTEXBLENDFLAGS {
	D3DVBF_DISABLE,
	D3DVBF_1WEIGHTS,
	D3DVBF_2WEIGHTS,
	D3DVBF_3WEIGHTS,
	D3DVBF_TWEENING    = 255,
	D3DVBF_0WEIGHTS,
	D3DVBF_FORCE_DWORD = 0xffffffff
}

enum D3DZBUFFERTYPE {
	D3DZB_FALSE,
	D3DZB_TRUE,
	D3DZB_USEW,
	D3DZB_FORCE_DWORD = 0xffffffff
}

struct D3DADAPTER_IDENTIFIER9 {
	char[MAX_DEVICE_IDENTIFIER_STRING] Driver;
	char[MAX_DEVICE_IDENTIFIER_STRING] Description;
	char[32]      DeviceName;
	LARGE_INTEGER DriverVersion;
	DWORD         VendorId;
	DWORD         DeviceId;
	DWORD         SubSysId;
	DWORD         Revision;
	GUID          DeviceIdentifier;
	DWORD         WHQLLevel;
}

struct D3DBOX {
	UINT Left;
	UINT Top;
	UINT Right;
	UINT Bottom;
	UINT Front;
	UINT Back;
}

struct D3DCLIPSTATUS9 {
	DWORD ClipUnion;
	DWORD ClipIntersection;
}

struct D3DCOLORVALUE {
	float r;
	float g;
	float b;
	float a;
}

struct D3DRESOURCESTATS {
	BOOL  bThrashing;
	DWORD ApproxBytesDownloaded;
	DWORD NumEvicts;
	DWORD NumVidCreates;
	DWORD LastPri;
	DWORD NumUsed;
	DWORD NumUsedInVidMem;
	DWORD WorkingSet;
	DWORD WorkingSetBytes;
	DWORD TotalManaged;
	DWORD TotalBytes;
}

struct D3DDEVICE_CREATION_PARAMETERS {
	UINT       AdapterOrdinal;
	D3DDEVTYPE DeviceType;
	HWND       hFocusWindow;
	DWORD      BehaviorFlags;
}

struct D3DDEVINFO_RESOURCEMANAGER {
	D3DRESOURCESTATS[D3DRTYPECOUNT] stats;
}
alias D3DDEVINFO_RESOURCEMANAGER* LPD3DDEVINFO_RESOURCEMANAGER;

struct D3DDEVINFO_D3DVERTEXSTATS {
	DWORD NumRenderedTriangles;
	DWORD NumExtraClippingTriangles;
}
alias D3DDEVINFO_D3DVERTEXSTATS* LPD3DDEVINFO_D3DVERTEXSTATS;

struct D3DDEVINFO_VCACHE {
	DWORD Pattern;
	DWORD OptMethod;
	DWORD CacheSize;
	DWORD MagicNumber;
}
alias D3DDEVINFO_VCACHE* LPD3DDEVINFO_VCACHE;

struct D3DDISPLAYMODE {
	UINT Width;
	UINT Height;
	UINT RefreshRate;
	D3DFORMAT Format;
}

struct D3DGAMMARAMP {
	WORD[256] red;
	WORD[256] green;
	WORD[256] blue;
}

struct D3DINDEXBUFFER_DESC {
	D3DFORMAT       Format;
	D3DRESOURCETYPE Type;
	DWORD           Usage;
	D3DPOOL         Pool;
	UINT            Size;
}

struct D3DVECTOR {
	float x;
	float y;
	float z;
}

struct D3DLIGHT9 {
	D3DLIGHTTYPE  Type;
	D3DCOLORVALUE Diffuse;
	D3DCOLORVALUE Specular;
	D3DCOLORVALUE Ambient;
	D3DVECTOR     Position;
	D3DVECTOR     Direction;
	float         Range;
	float         Falloff;
	float         Attenuation0;
	float         Attenuation1;
	float         Attenuation2;
	float         Theta;
	float         Phi;
}

struct D3DLOCKED_BOX {
	INT   RowPitch;
	INT   SlicePitch;
	void* pBits;
}

struct D3DLOCKED_RECT {
	INT   Pitch;
	void* pBits;
}

struct D3DMATERIAL9 {
	D3DCOLORVALUE Diffuse;
	D3DCOLORVALUE Ambient;
	D3DCOLORVALUE Specular;
	D3DCOLORVALUE Emissive;
	float         Power;
}

struct D3DMATRIX {
	union {
		struct {
			float _11, _12, _13, _14;
			float _21, _22, _23, _24;
			float _31, _32, _33, _34;
			float _41, _42, _43, _44;
		}
		float m[4][4];
	}
}

struct D3DPRESENT_PARAMETERS {
	UINT                BackBufferWidth;
	UINT                BackBufferHeight;
	D3DFORMAT           BackBufferFormat;
	UINT                BackBufferCount;
	D3DMULTISAMPLE_TYPE MultiSampleType;
	DWORD               MultiSampleQuality;
	D3DSWAPEFFECT       SwapEffect;
	HWND                hDeviceWindow;
	BOOL                Windowed;
	BOOL                EnableAutoDepthStencil;
	D3DFORMAT           AutoDepthStencilFormat;
	DWORD               Flags;
	UINT                FullScreen_RefreshRateInHz;
	UINT                PresentationInterval;
}

struct D3DRANGE {
	UINT Offset;
	UINT Size;
}

struct D3DRASTER_STATUS {
	BOOL InVBlank;
	UINT ScanLine;
}

struct D3DRECT {
	LONG x1;
	LONG y1;
	LONG x2;
	LONG y2;
}

struct D3DRECTPATCH_INFO {
	UINT         StartVertexOffsetWidth;
	UINT         StartVertexOffsetHeight;
	UINT         Width;
	UINT         Height;
	UINT         Stride;
	D3DBASISTYPE Basis;
	D3DORDERTYPE Order;
}

struct D3DSURFACE_DESC {
	D3DFORMAT           Format;
	D3DRESOURCETYPE     Type;
	DWORD               Usage;
	D3DPOOL             Pool;
	UINT                Size;
	D3DMULTISAMPLE_TYPE MultiSampleType;
	UINT                Width;
	UINT                Height;
}

struct D3DTRIPATCH_INFO {
	UINT         StartVertexOffset;
	UINT         NumVertices;
	D3DBASISTYPE Basis;
	D3DORDERTYPE Order;
}

struct D3DVERTEXBUFFER_DESC {
	D3DFORMAT       Format;
	D3DRESOURCETYPE Type;
	DWORD           Usage;
	D3DPOOL         Pool;
	UINT            Size;
	DWORD           FVF;
}

struct D3DVERTEXELEMENT9 {
	WORD Stream;
	WORD Offset;
	BYTE Type;
	BYTE Method;
	BYTE Usage;
	BYTE UsageIndex;
}
alias D3DVERTEXELEMENT9* LPD3DVERTEXELEMENT9;

struct D3DVIEWPORT9 {
	DWORD X;
	DWORD Y;
	DWORD Width;
	DWORD Height;
	float MinZ;
	float MaxZ;
}

struct D3DVOLUME_DESC {
	D3DFORMAT       Format;
	D3DRESOURCETYPE Type;
	DWORD           Usage;
	D3DPOOL         Pool;
	UINT            Width;
	UINT            Height;
	UINT            Depth;
}
