/***********************************************************************\
*                                winnt.d                                *
*                                                                       *
*                       Windows API header module                       *
*                                                                       *
*                 Translated from MinGW Windows headers                 *
*                                                                       *
*                       Placed into public domain                       *
\***********************************************************************/
module win32.winnt;

// FIXME: Two bitfields and a macro need to be fixed.
// FIXME: clean up Windows version support

public import win32.basetsd, win32.windef, win32.winerror;
private import win32.w32api;

/* Translation Notes:
The following macros are unneeded for D:
FIELD_OFFSET(t,f), CONTAINING_RECORD(address, type, field)
*/

alias void VOID;
alias char CHAR;
alias short SHORT;
alias char CCHAR;
alias CCHAR* PCCHAR;
alias ubyte UCHAR;
alias UCHAR* PUCHAR;
alias char* PSZ;
alias void* PVOID, LPVOID;

/* FIXME(MinGW) for __WIN64 */
alias void* PVOID64;

alias wchar WCHAR;
alias WCHAR* PWCHAR, LPWCH, PWCH, LPWSTR, PWSTR;
alias CHAR* PCHAR, LPCH, PCH, LPSTR, PSTR;

// const versions
alias WCHAR* LPCWCH, PCWCH, LPCWSTR, PCWSTR;
alias CHAR* LPCCH, PCSTR, LPCSTR;

version(Unicode) {
	alias WCHAR TCHAR, _TCHAR;
} else {
	alias CHAR TCHAR, _TCHAR;
}

alias TCHAR TBYTE;
alias TCHAR* PTCH, PTBYTE, LPTCH, PTSTR, LPTSTR, LP, PTCHAR, LPCTSTR;

alias SHORT* PSHORT;
alias LONG* PLONG;

typedef void* HANDLE;

alias HANDLE* PHANDLE, LPHANDLE;
alias DWORD LCID;
alias PDWORD PLCID;
alias WORD LANGID;

alias long LONGLONG;
alias ulong DWORDLONG;

alias DWORDLONG ULONGLONG;
alias LONGLONG* PLONGLONG;
alias DWORDLONG* PDWORDLONG, PULONGLONG;
alias LONGLONG USN;

const char ANSI_NULL = '\0';
const wchar UNICODE_NULL = '\0';
alias bool BOOLEAN;
alias bool* PBOOLEAN;

alias BYTE FCHAR;
alias WORD FSHORT;
alias DWORD FLONG;


const APPLICATION_ERROR_MASK       = 0x20000000;
const ERROR_SEVERITY_SUCCESS       = 0x00000000;
const ERROR_SEVERITY_INFORMATIONAL = 0x40000000;
const ERROR_SEVERITY_WARNING       = 0x80000000;
const ERROR_SEVERITY_ERROR         = 0xC0000000;

/* also in ddk/ntifs.h */
enum {
	COMPRESSION_FORMAT_NONE     = 0x0000,
	COMPRESSION_FORMAT_DEFAULT  = 0x0001,
	COMPRESSION_FORMAT_LZNT1    = 0x0002,
	COMPRESSION_ENGINE_STANDARD = 0x0000,
	COMPRESSION_ENGINE_MAXIMUM  = 0x0100,
	COMPRESSION_ENGINE_HIBER    = 0x0200
}

// ACCESS_DENIED_OBJECT_ACE, etc
const DWORD
	ACE_OBJECT_TYPE_PRESENT           = 0x00000001,
	ACE_INHERITED_OBJECT_TYPE_PRESENT = 0x00000002;

// ACE_HEADER.AceType
/* also in ddk/ntifs.h */
enum : BYTE {
	ACCESS_ALLOWED_ACE_TYPE     = 0x0,
	ACCESS_DENIED_ACE_TYPE      = 0x1,
	SYSTEM_AUDIT_ACE_TYPE       = 0x2,
	SYSTEM_ALARM_ACE_TYPE       = 0x3
}

// ACE_HEADER.AceFlags
const BYTE
	OBJECT_INHERIT_ACE         = 1,
	CONTAINER_INHERIT_ACE      = 2,
	NO_PROPAGATE_INHERIT_ACE   = 4,
	INHERIT_ONLY_ACE           = 8,
	VALID_INHERIT_FLAGS        = 16,
	SUCCESSFUL_ACCESS_ACE_FLAG = 64,
	FAILED_ACCESS_ACE_FLAG     = 128;


const ANYSIZE_ARRAY=1;

// Access Mask Format
const ACCESS_MASK
	DELETE                   = 0x00010000,
	READ_CONTROL             = 0x00020000,
	WRITE_DAC                = 0x00040000,
	WRITE_OWNER              = 0x00080000,
	SYNCHRONIZE              = 0x00100000,
	ACCESS_SYSTEM_SECURITY   = 0x01000000,
	MAXIMUM_ALLOWED          = 0x02000000,
	GENERIC_READ             = 0x80000000,
	GENERIC_WRITE            = 0x40000000,
	GENERIC_EXECUTE          = 0x20000000,
	GENERIC_ALL              = 0x10000000,
	STANDARD_RIGHTS_REQUIRED = 0x000F0000,
	STANDARD_RIGHTS_READ     = 0x00020000,
	STANDARD_RIGHTS_WRITE    = 0x00020000,
	STANDARD_RIGHTS_EXECUTE  = 0x00020000,
	STANDARD_RIGHTS_ALL      = 0x001F0000,
	SPECIFIC_RIGHTS_ALL      = 0x0000FFFF;


const DWORD INVALID_FILE_ATTRIBUTES = -1;

/* Also in ddk/winddk.h */
const FILE_LIST_DIRECTORY=0x00000001;
const FILE_READ_DATA=0x00000001;
const FILE_ADD_FILE=0x00000002;
const FILE_WRITE_DATA=0x00000002;
const FILE_ADD_SUBDIRECTORY=0x00000004;
const FILE_APPEND_DATA=0x00000004;
const FILE_CREATE_PIPE_INSTANCE=0x00000004;
const FILE_READ_EA=0x00000008;
const FILE_READ_PROPERTIES=0x00000008;
const FILE_WRITE_EA=0x00000010;
const FILE_WRITE_PROPERTIES=0x00000010;
const FILE_EXECUTE=0x00000020;
const FILE_TRAVERSE=0x00000020;
const FILE_DELETE_CHILD=0x00000040;
const FILE_READ_ATTRIBUTES=0x00000080;
const FILE_WRITE_ATTRIBUTES=0x00000100;

const FILE_SHARE_READ=0x00000001;
const FILE_SHARE_WRITE=0x00000002;
const FILE_SHARE_DELETE=0x00000004;
const FILE_SHARE_VALID_FLAGS=0x00000007;

const FILE_ATTRIBUTE_READONLY=0x00000001;
const FILE_ATTRIBUTE_HIDDEN=0x00000002;
const FILE_ATTRIBUTE_SYSTEM=0x00000004;
const FILE_ATTRIBUTE_DIRECTORY=0x00000010;
const FILE_ATTRIBUTE_ARCHIVE=0x00000020;
const FILE_ATTRIBUTE_DEVICE=0x00000040;
const FILE_ATTRIBUTE_NORMAL=0x00000080;
const FILE_ATTRIBUTE_TEMPORARY=0x00000100;
const FILE_ATTRIBUTE_SPARSE_FILE=0x00000200;
const FILE_ATTRIBUTE_REPARSE_POINT=0x00000400;
const FILE_ATTRIBUTE_COMPRESSED=0x00000800;
const FILE_ATTRIBUTE_OFFLINE=0x00001000;
const FILE_ATTRIBUTE_NOT_CONTENT_INDEXED=0x00002000;
const FILE_ATTRIBUTE_ENCRYPTED=0x00004000;
const FILE_ATTRIBUTE_VALID_FLAGS=0x00007fb7;
const FILE_ATTRIBUTE_VALID_SET_FLAGS=0x000031a7;

const FILE_COPY_STRUCTURED_STORAGE=0x00000041;
const FILE_STRUCTURED_STORAGE=0x00000441;

const FILE_VALID_OPTION_FLAGS=0x00ffffff;
const FILE_VALID_PIPE_OPTION_FLAGS=0x00000032;
const FILE_VALID_MAILSLOT_OPTION_FLAGS=0x00000032;
const FILE_VALID_SET_FLAGS=0x00000036;

const FILE_SUPERSEDE=0x00000000;
const FILE_OPEN=0x00000001;
const FILE_CREATE=0x00000002;
const FILE_OPEN_IF=0x00000003;
const FILE_OVERWRITE=0x00000004;
const FILE_OVERWRITE_IF=0x00000005;
const FILE_MAXIMUM_DISPOSITION=0x00000005;

const FILE_DIRECTORY_FILE=0x00000001;
const FILE_WRITE_THROUGH=0x00000002;
const FILE_SEQUENTIAL_ONLY=0x00000004;
const FILE_NO_INTERMEDIATE_BUFFERING=0x00000008;
const FILE_SYNCHRONOUS_IO_ALERT=0x00000010;
const FILE_SYNCHRONOUS_IO_NONALERT=0x00000020;
const FILE_NON_DIRECTORY_FILE=0x00000040;
const FILE_CREATE_TREE_CONNECTION=0x00000080;
const FILE_COMPLETE_IF_OPLOCKED=0x00000100;
const FILE_NO_EA_KNOWLEDGE=0x00000200;
const FILE_OPEN_FOR_RECOVERY=0x00000400;
const FILE_RANDOM_ACCESS=0x00000800;
const FILE_DELETE_ON_CLOSE=0x00001000;
const FILE_OPEN_BY_FILE_ID=0x00002000;
const FILE_OPEN_FOR_BACKUP_INTENT=0x00004000;
const FILE_NO_COMPRESSION=0x00008000;
const FILE_RESERVE_OPFILTER=0x00100000;
const FILE_OPEN_REPARSE_POINT=0x00200000;
const FILE_OPEN_NO_RECALL=0x00400000;
const FILE_OPEN_FOR_FREE_SPACE_QUERY=0x00800000;


const FILE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF);
const FILE_GENERIC_EXECUTE = (STANDARD_RIGHTS_EXECUTE | FILE_READ_ATTRIBUTES
		| FILE_EXECUTE | SYNCHRONIZE);
const FILE_GENERIC_READ  = (STANDARD_RIGHTS_READ | FILE_READ_DATA
		| FILE_READ_ATTRIBUTES | FILE_READ_EA | SYNCHRONIZE);
const FILE_GENERIC_WRITE  = (STANDARD_RIGHTS_WRITE | FILE_WRITE_DATA
		| FILE_WRITE_ATTRIBUTES | FILE_WRITE_EA | FILE_APPEND_DATA | SYNCHRONIZE);

/* end winddk.h */
/* also in ddk/ntifs.h */
const FILE_NOTIFY_CHANGE_FILE_NAME=0x00000001;
const FILE_NOTIFY_CHANGE_DIR_NAME=0x00000002;
const FILE_NOTIFY_CHANGE_NAME=0x00000003;
const FILE_NOTIFY_CHANGE_ATTRIBUTES=0x00000004;
const FILE_NOTIFY_CHANGE_SIZE=0x00000008;
const FILE_NOTIFY_CHANGE_LAST_WRITE=0x00000010;
const FILE_NOTIFY_CHANGE_LAST_ACCESS=0x00000020;
const FILE_NOTIFY_CHANGE_CREATION=0x00000040;
const FILE_NOTIFY_CHANGE_EA=0x00000080;
const FILE_NOTIFY_CHANGE_SECURITY=0x00000100;
const FILE_NOTIFY_CHANGE_STREAM_NAME=0x00000200;
const FILE_NOTIFY_CHANGE_STREAM_SIZE=0x00000400;
const FILE_NOTIFY_CHANGE_STREAM_WRITE=0x00000800;
const FILE_NOTIFY_VALID_MASK=0x00000fff;

const FILE_CASE_SENSITIVE_SEARCH=0x00000001;
const FILE_CASE_PRESERVED_NAMES=0x00000002;
const FILE_UNICODE_ON_DISK=0x00000004;
const FILE_PERSISTENT_ACLS=0x00000008;
const FILE_FILE_COMPRESSION=0x00000010;
const FILE_VOLUME_QUOTAS=0x00000020;
const FILE_SUPPORTS_SPARSE_FILES=0x00000040;
const FILE_SUPPORTS_REPARSE_POINTS=0x00000080;
const FILE_SUPPORTS_REMOTE_STORAGE=0x00000100;
const FS_LFN_APIS=0x00004000;
const FILE_VOLUME_IS_COMPRESSED=0x00008000;
const FILE_SUPPORTS_OBJECT_IDS=0x00010000;
const FILE_SUPPORTS_ENCRYPTION=0x00020000;
const FILE_NAMED_STREAMS=0x00040000;

const IO_COMPLETION_QUERY_STATE=0x0001;
const IO_COMPLETION_MODIFY_STATE=0x0002;
const IO_COMPLETION_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3;
/* end ntifs.h */

/* also in ddk/winddk.h */
const DUPLICATE_CLOSE_SOURCE=0x00000001;
const DUPLICATE_SAME_ACCESS=0x00000002;
const DUPLICATE_SAME_ATTRIBUTES=0x00000004;
/* end winddk.k */

const DWORD
	MAILSLOT_NO_MESSAGE = -1,
	MAILSLOT_WAIT_FOREVER = -1;

const PROCESS_TERMINATE=1;
const PROCESS_CREATE_THREAD=2;
const PROCESS_SET_SESSIONID=4;
const PROCESS_VM_OPERATION=8;
const PROCESS_VM_READ=16;
const PROCESS_VM_WRITE=32;
const PROCESS_DUP_HANDLE=64;
const PROCESS_CREATE_PROCESS=128;
const PROCESS_SET_QUOTA=256;
const PROCESS_SET_INFORMATION=512;
const PROCESS_QUERY_INFORMATION=1024;
const PROCESS_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0xFFF;

const THREAD_TERMINATE=1;
const THREAD_SUSPEND_RESUME=2;
const THREAD_GET_CONTEXT=8;
const THREAD_SET_CONTEXT=16;
const THREAD_SET_INFORMATION=32;
const THREAD_QUERY_INFORMATION=64;
const THREAD_SET_THREAD_TOKEN=128;
const THREAD_IMPERSONATE=256;
const THREAD_DIRECT_IMPERSONATION=0x200;
const THREAD_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3FF;
const THREAD_BASE_PRIORITY_LOWRT = 15;
const THREAD_BASE_PRIORITY_MAX   = 2;
const THREAD_BASE_PRIORITY_MIN   = -2;
const THREAD_BASE_PRIORITY_IDLE  = -15;
const EXCEPTION_NONCONTINUABLE=1;
const EXCEPTION_MAXIMUM_PARAMETERS=15;
const MUTANT_QUERY_STATE=0x0001;
const MUTANT_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|MUTANT_QUERY_STATE;
const TIMER_QUERY_STATE=0x0001;
const TIMER_MODIFY_STATE=0x0002;
const TIMER_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|TIMER_QUERY_STATE|TIMER_MODIFY_STATE;
/*
* To prevent gcc compiler warnings, bracket these defines when initialising
* a  SID_IDENTIFIER_AUTHORITY, eg.
* SID_IDENTIFIER_AUTHORITY aNullSidAuthority = {SECURITY_NULL_SID_AUTHORITY};
 */

/* FIXME:
const SECURITY_NULL_SID_AUTHORITY={0,0,0,0,0,0};
const SECURITY_WORLD_SID_AUTHORITY={0,0,0,0,0,1};
const SECURITY_LOCAL_SID_AUTHORITY={0,0,0,0,0,2};
const SECURITY_CREATOR_SID_AUTHORITY={0,0,0,0,0,3};
const SECURITY_NON_UNIQUE_AUTHORITY={0,0,0,0,0,4};
const SECURITY_NT_AUTHORITY={0,0,0,0,0,5};
*/
const SECURITY_NULL_RID=0;
const SECURITY_WORLD_RID=(0x00000000L);
const SECURITY_LOCAL_RID=0;
const SECURITY_CREATOR_OWNER_RID=0;
const SECURITY_CREATOR_GROUP_RID=1;
const SECURITY_DIALUP_RID=1;
const SECURITY_NETWORK_RID=2;
const SECURITY_BATCH_RID=3;
const SECURITY_INTERACTIVE_RID=4;
const SECURITY_LOGON_IDS_RID=5;
const SECURITY_SERVICE_RID=6;
const SECURITY_LOCAL_SYSTEM_RID=18;
const SECURITY_BUILTIN_DOMAIN_RID=32;
const SECURITY_PRINCIPAL_SELF_RID=10;
const SECURITY_CREATOR_OWNER_SERVER_RID=0x2;
const SECURITY_CREATOR_GROUP_SERVER_RID=0x3;
const SECURITY_LOGON_IDS_RID_COUNT=0x3;
const SECURITY_ANONYMOUS_LOGON_RID=0x7;
const SECURITY_PROXY_RID=0x8;
const SECURITY_ENTERPRISE_CONTROLLERS_RID=0x9;
const SECURITY_SERVER_LOGON_RID = SECURITY_ENTERPRISE_CONTROLLERS_RID;
const SECURITY_AUTHENTICATED_USER_RID=0xB;
const SECURITY_RESTRICTED_CODE_RID=0xC;
const SECURITY_NT_NON_UNIQUE_RID=0x15;
const SID_REVISION=1;

enum {
	DOMAIN_USER_RID_ADMIN       = 0x1F4L,
	DOMAIN_USER_RID_GUEST       = 0x1F5L,
	DOMAIN_GROUP_RID_ADMINS     = 0x200L,
	DOMAIN_GROUP_RID_USERS      = 0x201L,
	DOMAIN_ALIAS_RID_ADMINS     = 0x220L,
	DOMAIN_ALIAS_RID_USERS      = 0x221L,
	DOMAIN_ALIAS_RID_GUESTS     = 0x222L,
	DOMAIN_ALIAS_RID_POWER_USERS= 0x223L,
	DOMAIN_ALIAS_RID_ACCOUNT_OPS= 0x224L,
	DOMAIN_ALIAS_RID_SYSTEM_OPS = 0x225L,
	DOMAIN_ALIAS_RID_PRINT_OPS  = 0x226L,
	DOMAIN_ALIAS_RID_BACKUP_OPS = 0x227L,
	DOMAIN_ALIAS_RID_REPLICATOR = 0x228L
}

const TCHAR []
	SE_CREATE_TOKEN_NAME       = "SeCreateTokenPrivilege",
	SE_ASSIGNPRIMARYTOKEN_NAME = "SeAssignPrimaryTokenPrivilege",
	SE_LOCK_MEMORY_NAME        = "SeLockMemoryPrivilege",
	SE_INCREASE_QUOTA_NAME     = "SeIncreaseQuotaPrivilege",
	SE_UNSOLICITED_INPUT_NAME  = "SeUnsolicitedInputPrivilege",
	SE_MACHINE_ACCOUNT_NAME    = "SeMachineAccountPrivilege",
	SE_TCB_NAME                = "SeTcbPrivilege",
	SE_SECURITY_NAME           = "SeSecurityPrivilege",
	SE_TAKE_OWNERSHIP_NAME     = "SeTakeOwnershipPrivilege",
	SE_LOAD_DRIVER_NAME        = "SeLoadDriverPrivilege",
	SE_SYSTEM_PROFILE_NAME     = "SeSystemProfilePrivilege",
	SE_SYSTEMTIME_NAME         = "SeSystemtimePrivilege",
	SE_PROF_SINGLE_PROCESS_NAME = "SeProfileSingleProcessPrivilege",
	SE_INC_BASE_PRIORITY_NAME   = "SeIncreaseBasePriorityPrivilege",
	SE_CREATE_PAGEFILE_NAME     = "SeCreatePagefilePrivilege",
	SE_CREATE_PERMANENT_NAME    = "SeCreatePermanentPrivilege",
	SE_BACKUP_NAME              = "SeBackupPrivilege",
	SE_RESTORE_NAME             = "SeRestorePrivilege",
	SE_SHUTDOWN_NAME            = "SeShutdownPrivilege",
	SE_DEBUG_NAME               = "SeDebugPrivilege",
	SE_AUDIT_NAME               = "SeAuditPrivilege",
	SE_SYSTEM_ENVIRONMENT_NAME  = "SeSystemEnvironmentPrivilege",
	SE_CHANGE_NOTIFY_NAME       = "SeChangeNotifyPrivilege",
	SE_REMOTE_SHUTDOWN_NAME     = "SeRemoteShutdownPrivilege",
	SE_CREATE_GLOBAL_NAME       = "SeCreateGlobalPrivilege";

const SE_GROUP_MANDATORY=1;
const SE_GROUP_ENABLED_BY_DEFAULT=2;
const SE_GROUP_ENABLED=4;
const SE_GROUP_OWNER=8;
const SE_GROUP_USE_FOR_DENY_ONLY=16;
const SE_GROUP_LOGON_ID=3221225472U;
const SE_GROUP_RESOURCE=536870912;

// Primary language identifiers
enum : USHORT {
	LANG_NEUTRAL = 0x00,
	LANG_ARABIC = 0x01,
	LANG_BULGARIAN = 0x02,
	LANG_CATALAN = 0x03,
	LANG_CHINESE = 0x04,
	LANG_CZECH = 0x05,
	LANG_DANISH = 0x06,
	LANG_GERMAN = 0x07,
	LANG_GREEK = 0x08,
	LANG_ENGLISH = 0x09,
	LANG_SPANISH = 0x0a,
	LANG_FINNISH = 0x0b,
	LANG_FRENCH = 0x0c,
	LANG_HEBREW = 0x0d,
	LANG_HUNGARIAN = 0x0e,
	LANG_ICELANDIC = 0x0f,
	LANG_ITALIAN = 0x10,
	LANG_JAPANESE = 0x11,
	LANG_KOREAN = 0x12,
	LANG_DUTCH = 0x13,
	LANG_NORWEGIAN = 0x14,
	LANG_POLISH = 0x15,
	LANG_PORTUGUESE = 0x16,
	LANG_ROMANIAN = 0x18,
	LANG_RUSSIAN = 0x19,
	LANG_CROATIAN = 0x1a,
	LANG_SERBIAN = 0x1a,
	LANG_SLOVAK = 0x1b,
	LANG_ALBANIAN = 0x1c,
	LANG_SWEDISH = 0x1d,
	LANG_THAI = 0x1e,
	LANG_TURKISH = 0x1f,
	LANG_URDU = 0x20,
	LANG_INDONESIAN = 0x21,
	LANG_UKRAINIAN = 0x22,
	LANG_BELARUSIAN = 0x23,
	LANG_SLOVENIAN = 0x24,
	LANG_ESTONIAN = 0x25,
	LANG_LATVIAN = 0x26,
	LANG_LITHUANIAN = 0x27,
	LANG_FARSI = 0x29,
	LANG_VIETNAMESE = 0x2a,
	LANG_ARMENIAN = 0x2b,
	LANG_AZERI = 0x2c,
	LANG_BASQUE = 0x2d,
	LANG_MACEDONIAN = 0x2f,

	LANG_AFRIKAANS = 0x36,
	LANG_GEORGIAN = 0x37,
	LANG_FAEROESE = 0x38,
	LANG_HINDI = 0x39,
	LANG_MALAY = 0x3e,
	LANG_KAZAK = 0x3f,
	LANG_KYRGYZ = 0x40,
	LANG_SWAHILI = 0x41,
	LANG_UZBEK = 0x43,
	LANG_TATAR = 0x44,
	LANG_BENGALI = 0x45,
	LANG_PUNJABI = 0x46,
	LANG_GUJARATI = 0x47,
	LANG_ORIYA = 0x48,
	LANG_TAMIL = 0x49,
	LANG_TELUGU = 0x4a,
	LANG_KANNADA = 0x4b,
	LANG_MALAYALAM = 0x4c,
	LANG_ASSAMESE = 0x4d,
	LANG_MARATHI = 0x4e,
	LANG_SANSKRIT = 0x4f,
	LANG_MONGOLIAN = 0x50,

	LANG_GALICIAN = 0x56,
	LANG_KONKANI = 0x57,
	LANG_MANIPURI = 0x58,
	LANG_SINDHI = 0x59,
	LANG_SYRIAC = 0x5a,

	LANG_KASHMIRI = 0x60,
	LANG_NEPALI = 0x61,
	LANG_DIVEHI = 0x65,

	LANG_INVARIANT = 0x7f
}

// Sublanguage identifiers
enum : USHORT {
	SUBLANG_NEUTRAL = 0x00,
	SUBLANG_DEFAULT = 0x01,
	SUBLANG_SYS_DEFAULT = 0x02,

	SUBLANG_ARABIC_SAUDI_ARABIA = 0x01,
	SUBLANG_ARABIC_IRAQ = 0x02,
	SUBLANG_ARABIC_EGYPT = 0x03,
	SUBLANG_ARABIC_LIBYA = 0x04,
	SUBLANG_ARABIC_ALGERIA = 0x05,
	SUBLANG_ARABIC_MOROCCO = 0x06,
	SUBLANG_ARABIC_TUNISIA = 0x07,
	SUBLANG_ARABIC_OMAN = 0x08,
	SUBLANG_ARABIC_YEMEN = 0x09,
	SUBLANG_ARABIC_SYRIA = 0x0a,
	SUBLANG_ARABIC_JORDAN = 0x0b,
	SUBLANG_ARABIC_LEBANON = 0x0c,
	SUBLANG_ARABIC_KUWAIT = 0x0d,
	SUBLANG_ARABIC_UAE = 0x0e,
	SUBLANG_ARABIC_BAHRAIN = 0x0f,
	SUBLANG_ARABIC_QATAR = 0x10,

	SUBLANG_AZERI_LATIN = 0x01,
	SUBLANG_AZERI_CYRILLIC = 0x02,

	SUBLANG_CHINESE_TRADITIONAL = 0x01,
	SUBLANG_CHINESE_SIMPLIFIED = 0x02,
	SUBLANG_CHINESE_HONGKONG = 0x03,
	SUBLANG_CHINESE_SINGAPORE = 0x04,
	SUBLANG_CHINESE_MACAU = 0x05,

	SUBLANG_DUTCH = 0x01,
	SUBLANG_DUTCH_BELGIAN = 0x02,

	SUBLANG_ENGLISH_US = 0x01,
	SUBLANG_ENGLISH_UK = 0x02,
	SUBLANG_ENGLISH_AUS = 0x03,
	SUBLANG_ENGLISH_CAN = 0x04,
	SUBLANG_ENGLISH_NZ = 0x05,
	SUBLANG_ENGLISH_EIRE = 0x06,
	SUBLANG_ENGLISH_SOUTH_AFRICA = 0x07,
	SUBLANG_ENGLISH_JAMAICA = 0x08,
	SUBLANG_ENGLISH_CARIBBEAN = 0x09,
	SUBLANG_ENGLISH_BELIZE = 0x0a,
	SUBLANG_ENGLISH_TRINIDAD = 0x0b,
	SUBLANG_ENGLISH_ZIMBABWE = 0x0c,
	SUBLANG_ENGLISH_PHILIPPINES = 0x0d,

	SUBLANG_FRENCH = 0x01,
	SUBLANG_FRENCH_BELGIAN = 0x02,
	SUBLANG_FRENCH_CANADIAN = 0x03,
	SUBLANG_FRENCH_SWISS = 0x04,
	SUBLANG_FRENCH_LUXEMBOURG = 0x05,
	SUBLANG_FRENCH_MONACO = 0x06,

	SUBLANG_GERMAN = 0x01,
	SUBLANG_GERMAN_SWISS = 0x02,
	SUBLANG_GERMAN_AUSTRIAN = 0x03,
	SUBLANG_GERMAN_LUXEMBOURG = 0x04,
	SUBLANG_GERMAN_LIECHTENSTEIN = 0x05,

	SUBLANG_ITALIAN = 0x01,
	SUBLANG_ITALIAN_SWISS = 0x02,
	SUBLANG_KASHMIRI_INDIA = 0x02,
	SUBLANG_KASHMIRI_SASIA = 0x02,
	SUBLANG_KOREAN = 0x01,
	SUBLANG_LITHUANIAN = 0x01,
	SUBLANG_MALAY_MALAYSIA = 0x01,
	SUBLANG_MALAY_BRUNEI_DARUSSALAM = 0x02,

	SUBLANG_NEPALI_INDIA = 0x02,

	SUBLANG_NORWEGIAN_BOKMAL = 0x01,
	SUBLANG_NORWEGIAN_NYNORSK = 0x02,

	SUBLANG_PORTUGUESE = 0x01,
	SUBLANG_PORTUGUESE_BRAZILIAN = 0x02,

	SUBLANG_SERBIAN_LATIN = 0x02,
	SUBLANG_SERBIAN_CYRILLIC = 0x03,

	SUBLANG_SPANISH = 0x01,
	SUBLANG_SPANISH_MEXICAN = 0x02,
	SUBLANG_SPANISH_MODERN = 0x03,
	SUBLANG_SPANISH_GUATEMALA = 0x04,
	SUBLANG_SPANISH_COSTA_RICA = 0x05,
	SUBLANG_SPANISH_PANAMA = 0x06,
	SUBLANG_SPANISH_DOMINICAN_REPUBLIC = 0x07,
	SUBLANG_SPANISH_VENEZUELA = 0x08,
	SUBLANG_SPANISH_COLOMBIA = 0x09,
	SUBLANG_SPANISH_PERU = 0x0a,
	SUBLANG_SPANISH_ARGENTINA = 0x0b,
	SUBLANG_SPANISH_ECUADOR = 0x0c,
	SUBLANG_SPANISH_CHILE = 0x0d,
	SUBLANG_SPANISH_URUGUAY = 0x0e,
	SUBLANG_SPANISH_PARAGUAY = 0x0f,
	SUBLANG_SPANISH_BOLIVIA = 0x10,
	SUBLANG_SPANISH_EL_SALVADOR = 0x11,
	SUBLANG_SPANISH_HONDURAS = 0x12,
	SUBLANG_SPANISH_NICARAGUA = 0x13,
	SUBLANG_SPANISH_PUERTO_RICO = 0x14,

	SUBLANG_SWEDISH = 0x01,
	SUBLANG_SWEDISH_FINLAND = 0x02,

	SUBLANG_URDU_PAKISTAN = 0x01,
	SUBLANG_URDU_INDIA = 0x02,

	SUBLANG_UZBEK_LATIN = 0x01,
	SUBLANG_UZBEK_CYRILLIC = 0x02
}

const NLS_VALID_LOCALE_MASK=1048575;

// Sorting identifiers
enum : WORD {
	SORT_DEFAULT              = 0,
	SORT_JAPANESE_XJIS        = 0,
	SORT_JAPANESE_UNICODE     = 1,
	SORT_CHINESE_BIG5         = 0,
	SORT_CHINESE_PRCP         = 0,
	SORT_CHINESE_UNICODE      = 1,
	SORT_CHINESE_PRC          = 2,
	SORT_CHINESE_BOPOMOFO     = 3,
	SORT_KOREAN_KSC           = 0,
	SORT_KOREAN_UNICODE       = 1,
	SORT_GERMAN_PHONE_BOOK    = 1,
	SORT_HUNGARIAN_DEFAULT    = 0,
	SORT_HUNGARIAN_TECHNICAL  = 1,
	SORT_GEORGIAN_TRADITIONAL = 0,
	SORT_GEORGIAN_MODERN      = 1
}

//MACRO #define MAKELANGID(p,s)	((((WORD)(s))<<10)|(WORD)(p))

//MACRO #define PRIMARYLANGID(l)	((WORD)(l)&0x3ff)
//MACRO #define SUBLANGID(l)	((WORD)(l)>>10)


//MACRO #define MAKELCID(l,s) ((DWORD)((((DWORD)((WORD)(s)))<<16)|((DWORD)((WORD)(l)))))

//MACRO #define SORTIDFROMLCID(l)	((WORD)((((DWORD)(l))&NLS_VALID_LOCALE_MASK)>>16))

//MACRO #define SORTVERSIONFROMLCID(l) ((WORD)((((DWORD)(l))>>20)&0xf))

//MACRO #define LANGIDFROMLCID(l)	((WORD)(l))

WORD MAKELANGID(USHORT p, USHORT s) { return (((cast(WORD)(s)) << 10) | cast(WORD)(p)); }
WORD PRIMARYLANGID(WORD lgid) { return lgid & 0x3ff; }
WORD SUBLANGID(WORD lgid) { return lgid >>> 10; }

DWORD MAKELCID(WORD lgid, WORD srtid) { return ((cast(DWORD)srtid) << 16) | (cast(DWORD)lgid); }
//DWORD MAKESORTLCID(WORD lgid, WORD srtid, WORD ver) { return (MAKELCID(lgid, srtid)) | ((cast(DWORD)ver) << 20); }
WORD LANGIDFROMLCID(LCID lcid) { return lcid; }
WORD SORTIDFROMLCID(LCID lcid) { return (cast(DWORD)lcid >>> 16) & 0xf; }
WORD SORTVERSIONFROMLCID(LCID lcid) { return (cast(DWORD)lcid >>> 20) & 0xf; }

const WORD LANG_SYSTEM_DEFAULT = (SUBLANG_SYS_DEFAULT << 10) | LANG_NEUTRAL;
const WORD LANG_USER_DEFAULT   = (SUBLANG_DEFAULT << 10) | LANG_NEUTRAL;
const DWORD LOCALE_NEUTRAL     = (SORT_DEFAULT << 16)
                                 | (SUBLANG_NEUTRAL << 10) | LANG_NEUTRAL;

// ---
const ACL_REVISION    = 2;
const ACL_REVISION_DS = 4;

enum {
	ACL_REVISION1 = 1,
	ACL_REVISION2,
	ACL_REVISION3,
	ACL_REVISION4 // = 4
}

const MIN_ACL_REVISION = 2;
const MAX_ACL_REVISION = 4;

/+
// These aren't necessary for D.
const MINCHAR=0x80;
const MAXCHAR=0x7f;
const MINSHORT=0x8000;
const MAXSHORT=0x7fff;
const MINLONG=0x80000000;
const MAXLONG=0x7fffffff;
const MAXBYTE=0xff;
const MAXWORD=0xffff;
const MAXDWORD=0xffffffff;
+/

// SYSTEM_INFO.dwProcessorType
enum : DWORD {
	PROCESSOR_INTEL_386     = 386,
	PROCESSOR_INTEL_486     = 486,
	PROCESSOR_INTEL_PENTIUM = 586,
	PROCESSOR_MIPS_R4000    = 4000,
	PROCESSOR_ALPHA_21064   = 21064,
	PROCESSOR_INTEL_IA64    = 2200
}

// SYSTEM_INFO.wProcessorArchitecture
enum : WORD {
	PROCESSOR_ARCHITECTURE_INTEL = 0,
	PROCESSOR_ARCHITECTURE_MIPS,
	PROCESSOR_ARCHITECTURE_ALPHA,
	PROCESSOR_ARCHITECTURE_PPC,
	PROCESSOR_ARCHITECTURE_SHX,
	PROCESSOR_ARCHITECTURE_ARM,
	PROCESSOR_ARCHITECTURE_IA64,
	PROCESSOR_ARCHITECTURE_ALPHA64,
	PROCESSOR_ARCHITECTURE_MSIL,
	PROCESSOR_ARCHITECTURE_AMD64,
	PROCESSOR_ARCHITECTURE_IA32_ON_WIN64, // = 10
	PROCESSOR_ARCHITECTURE_UNKNOWN = 0xFFFF
}

// IsProcessorFeaturePresent()
enum : DWORD {
	PF_FLOATING_POINT_PRECISION_ERRATA = 0,
	PF_FLOATING_POINT_EMULATED,
	PF_COMPARE_EXCHANGE_DOUBLE,
	PF_MMX_INSTRUCTIONS_AVAILABLE,
	PF_PPC_MOVEMEM_64BIT_OK,
	PF_ALPHA_BYTE_INSTRUCTIONS,
	PF_XMMI_INSTRUCTIONS_AVAILABLE,
	PF_3DNOW_INSTRUCTIONS_AVAILABLE,
	PF_RDTSC_INSTRUCTION_AVAILABLE,
	PF_PAE_ENABLED,
	PF_XMMI64_INSTRUCTIONS_AVAILABLE
}

/* also in ddk/ntifs.h */
const FILE_ACTION_ADDED=0x00000001;
const FILE_ACTION_REMOVED=0x00000002;
const FILE_ACTION_MODIFIED=0x00000003;
const FILE_ACTION_RENAMED_OLD_NAME=0x00000004;
const FILE_ACTION_RENAMED_NEW_NAME=0x00000005;
const FILE_ACTION_ADDED_STREAM=0x00000006;
const FILE_ACTION_REMOVED_STREAM=0x00000007;
const FILE_ACTION_MODIFIED_STREAM=0x00000008;
const FILE_ACTION_REMOVED_BY_DELETE=0x00000009;
const FILE_ACTION_ID_NOT_TUNNELLED=0x0000000A;
const FILE_ACTION_TUNNELLED_ID_COLLISION=0x0000000B;
/* end ntifs.h */

const HEAP_NO_SERIALIZE=1;
const HEAP_GROWABLE=2;
const HEAP_GENERATE_EXCEPTIONS=4;
const HEAP_ZERO_MEMORY=8;
const HEAP_REALLOC_IN_PLACE_ONLY=16;
const HEAP_TAIL_CHECKING_ENABLED=32;
const HEAP_FREE_CHECKING_ENABLED=64;
const HEAP_DISABLE_COALESCE_ON_FREE=128;
const HEAP_CREATE_ALIGN_16=0x0000;
const HEAP_CREATE_ENABLE_TRACING=0x20000;
const HEAP_MAXIMUM_TAG=0xFFF;
const HEAP_PSEUDO_TAG_FLAG=0x8000;
const HEAP_TAG_SHIFT=16;
//MACRO #define HEAP_MAKE_TAG_FLAGS(b,o) ((DWORD)((b)+(o)<<16)))

const KEY_QUERY_VALUE=1;
const KEY_SET_VALUE=2;
const KEY_CREATE_SUB_KEY=4;
const KEY_ENUMERATE_SUB_KEYS=8;
const KEY_NOTIFY=16;
const KEY_CREATE_LINK=32;
const KEY_WRITE=0x20006;
const KEY_EXECUTE=0x20019;
const KEY_READ=0x20019;
const KEY_ALL_ACCESS=0xf003f;
const REG_WHOLE_HIVE_VOLATILE=1;
const REG_REFRESH_HIVE=2;
const REG_NO_LAZY_FLUSH=4;
const REG_OPTION_RESERVED=0;
const REG_OPTION_NON_VOLATILE=0;
const REG_OPTION_VOLATILE=1;
const REG_OPTION_CREATE_LINK=2;
const REG_OPTION_BACKUP_RESTORE=4;
const REG_OPTION_OPEN_LINK=8;
const REG_LEGAL_OPTION=15;
const OWNER_SECURITY_INFORMATION=1;
const GROUP_SECURITY_INFORMATION=2;
const DACL_SECURITY_INFORMATION=4;
const SACL_SECURITY_INFORMATION=8;
const MAXIMUM_PROCESSORS=32;

// ---
// VirtualAlloc(), etc

enum : DWORD {
	PAGE_NOACCESS          = 0x0001,
	PAGE_READONLY          = 0x0002,
	PAGE_READWRITE         = 0x0004,
	PAGE_WRITECOPY         = 0x0008,
	PAGE_EXECUTE           = 0x0010,
	PAGE_EXECUTE_READ      = 0x0020,
	PAGE_EXECUTE_READWRITE = 0x0040,
	PAGE_EXECUTE_WRITECOPY = 0x0080,
	PAGE_GUARD             = 0x0100,
	PAGE_NOCACHE           = 0x0200
}

enum : DWORD {
	MEM_COMMIT      = 0x1000,
	MEM_RESERVE     = 0x2000,
	MEM_DECOMMIT    = 0x4000,
	MEM_RELEASE     = 0x8000,
	MEM_FREE        = 0x10000,
	MEM_PRIVATE     = 0x20000,
	MEM_MAPPED      = 0x40000,
	MEM_RESET       = 0x80000,
	MEM_TOP_DOWN    = 0x100000,
	MEM_WRITE_WATCH = 0x200000,/* 98/Me */
	MEM_PHYSICAL    = 0x400000,
	MEM_4MB_PAGES   = 0x80000000
}

// ???
/* also in ddk/ntifs.h */
const SEC_BASED=0x00200000;
const SEC_NO_CHANGE=0x00400000;
const SEC_FILE=0x00800000;
const SEC_IMAGE=0x01000000;
const SEC_VLM=0x02000000;
const SEC_RESERVE=0x04000000;
const SEC_COMMIT=0x08000000;
const SEC_NOCACHE=0x10000000;
const MEM_IMAGE = SEC_IMAGE;
/* end ntifs.h */

// ???
const SECTION_EXTEND_SIZE=16;
const SECTION_MAP_READ=4;
const SECTION_MAP_WRITE=2;
const SECTION_QUERY=1;
const SECTION_MAP_EXECUTE=8;
const SECTION_ALL_ACCESS=0xf001f;
const MESSAGE_RESOURCE_UNICODE=1;
const RTL_CRITSECT_TYPE=0;
const RTL_RESOURCE_TYPE=1;

// ---
// COFF file format

// IMAGE_FILE_HEADER.Characteristics
const WORD
	IMAGE_FILE_RELOCS_STRIPPED = 1,
	IMAGE_FILE_EXECUTABLE_IMAGE = 2,
	IMAGE_FILE_LINE_NUMS_STRIPPED = 4,
	IMAGE_FILE_LOCAL_SYMS_STRIPPED = 8,
	IMAGE_FILE_AGGRESIVE_WS_TRIM = 16,
	IMAGE_FILE_LARGE_ADDRESS_AWARE = 32,
	IMAGE_FILE_BYTES_REVERSED_LO = 128,
	IMAGE_FILE_32BIT_MACHINE = 256,
	IMAGE_FILE_DEBUG_STRIPPED = 512,
	IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP = 1024,
	IMAGE_FILE_NET_RUN_FROM_SWAP = 2048,
	IMAGE_FILE_SYSTEM = 4096,
	IMAGE_FILE_DLL = 8192,
	IMAGE_FILE_UP_SYSTEM_ONLY = 16384,
	IMAGE_FILE_BYTES_REVERSED_HI = 32768;

// IMAGE_FILE_HEADER.Machine
enum : WORD {
	IMAGE_FILE_MACHINE_UNKNOWN = 0,
	IMAGE_FILE_MACHINE_I386    = 332,
	IMAGE_FILE_MACHINE_R3000   = 354,
	IMAGE_FILE_MACHINE_R4000   = 358,
	IMAGE_FILE_MACHINE_R10000  = 360,
	IMAGE_FILE_MACHINE_ALPHA   = 388,
	IMAGE_FILE_MACHINE_POWERPC = 496
}

// ???
enum  {
	IMAGE_DOS_SIGNATURE    = 0x5A4D,
	IMAGE_OS2_SIGNATURE    = 0x454E,
	IMAGE_OS2_SIGNATURE_LE = 0x454C,
	IMAGE_VXD_SIGNATURE    = 0x454C,
	IMAGE_NT_SIGNATURE     = 0x4550
}

// IMAGE_OPTIONAL_HEADER.Magic
enum : WORD {
	IMAGE_NT_OPTIONAL_HDR_MAGIC  = 0x10b,
	IMAGE_ROM_OPTIONAL_HDR_MAGIC = 0x107
}

// IMAGE_OPTIONAL_HEADER.Subsystem
enum : WORD {
	IMAGE_SUBSYSTEM_UNKNOWN=0,
	IMAGE_SUBSYSTEM_NATIVE=1,
	IMAGE_SUBSYSTEM_WINDOWS_GUI=2,
	IMAGE_SUBSYSTEM_WINDOWS_CUI=3,
	IMAGE_SUBSYSTEM_OS2_CUI=5,
	IMAGE_SUBSYSTEM_POSIX_CUI=7,
	IMAGE_SUBSYSTEM_XBOX=14
}

const IMAGE_SEPARATE_DEBUG_SIGNATURE=0x4944;
const IMAGE_NUMBEROF_DIRECTORY_ENTRIES=16;
const IMAGE_SIZEOF_ROM_OPTIONAL_HEADER=56;
const IMAGE_SIZEOF_STD_OPTIONAL_HEADER=28;
const IMAGE_SIZEOF_NT_OPTIONAL_HEADER=224;
const IMAGE_SIZEOF_SHORT_NAME=8;
const IMAGE_SIZEOF_SECTION_HEADER=40;
const IMAGE_SIZEOF_SYMBOL=18;
const IMAGE_SIZEOF_AUX_SYMBOL=18;
const IMAGE_SIZEOF_RELOCATION=10;
const IMAGE_SIZEOF_BASE_RELOCATION=8;
const IMAGE_SIZEOF_LINENUMBER=6;
const IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR=60;
const SIZEOF_RFPO_DATA=16;

//MACRO #define IMAGE_FIRST_SECTION(h) ((PIMAGE_SECTION_HEADER) ((DWORD)h+FIELD_OFFSET(IMAGE_NT_HEADERS,OptionalHeader)+((PIMAGE_NT_HEADERS)(h))->FileHeader.SizeOfOptionalHeader))

// ImageDirectoryEntryToDataEx()
enum : USHORT {
	IMAGE_DIRECTORY_ENTRY_EXPORT = 0,
	IMAGE_DIRECTORY_ENTRY_IMPORT,
	IMAGE_DIRECTORY_ENTRY_RESOURCE,
	IMAGE_DIRECTORY_ENTRY_EXCEPTION,
	IMAGE_DIRECTORY_ENTRY_SECURITY,
	IMAGE_DIRECTORY_ENTRY_BASERELOC,
	IMAGE_DIRECTORY_ENTRY_DEBUG,
	IMAGE_DIRECTORY_ENTRY_COPYRIGHT,
	IMAGE_DIRECTORY_ENTRY_GLOBALPTR,
	IMAGE_DIRECTORY_ENTRY_TLS,
	IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG,
	IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT,
	IMAGE_DIRECTORY_ENTRY_IAT // = 12
}

// IMAGE_SECTION_HEADER.Characteristics
const DWORD
	IMAGE_SCN_TYPE_NO_PAD = 8,
	IMAGE_SCN_CNT_CODE = 32,
	IMAGE_SCN_CNT_INITIALIZED_DATA = 64,
	IMAGE_SCN_CNT_UNINITIALIZED_DATA = 128,
	IMAGE_SCN_LNK_OTHER = 256,
	IMAGE_SCN_LNK_INFO = 512,
	IMAGE_SCN_LNK_REMOVE = 2048,
	IMAGE_SCN_LNK_COMDAT = 4096,
	IMAGE_SCN_MEM_FARDATA = 0x8000,
	IMAGE_SCN_MEM_PURGEABLE = 0x20000,
	IMAGE_SCN_MEM_16BIT = 0x20000,
	IMAGE_SCN_MEM_LOCKED = 0x40000,
	IMAGE_SCN_MEM_PRELOAD = 0x80000,
	IMAGE_SCN_ALIGN_1BYTES = 0x100000,
	IMAGE_SCN_ALIGN_2BYTES = 0x200000,
	IMAGE_SCN_ALIGN_4BYTES = 0x300000,
	IMAGE_SCN_ALIGN_8BYTES = 0x400000,
	IMAGE_SCN_ALIGN_16BYTES = 0x500000,
	IMAGE_SCN_ALIGN_32BYTES = 0x600000,
	IMAGE_SCN_ALIGN_64BYTES = 0x700000,
	IMAGE_SCN_LNK_NRELOC_OVFL = 0x1000000,
	IMAGE_SCN_MEM_DISCARDABLE = 0x2000000,
	IMAGE_SCN_MEM_NOT_CACHED = 0x4000000,
	IMAGE_SCN_MEM_NOT_PAGED = 0x8000000,
	IMAGE_SCN_MEM_SHARED = 0x10000000,
	IMAGE_SCN_MEM_EXECUTE = 0x20000000,
	IMAGE_SCN_MEM_READ = 0x40000000,
	IMAGE_SCN_MEM_WRITE = 0x80000000;

const IMAGE_SYM_UNDEFINED=0;
const IMAGE_SYM_ABSOLUTE=-1;
const IMAGE_SYM_DEBUG=-2;
const IMAGE_SYM_TYPE_NULL=0;
const IMAGE_SYM_TYPE_VOID=1;
const IMAGE_SYM_TYPE_CHAR=2;
const IMAGE_SYM_TYPE_SHORT=3;
const IMAGE_SYM_TYPE_INT=4;
const IMAGE_SYM_TYPE_LONG=5;
const IMAGE_SYM_TYPE_FLOAT=6;
const IMAGE_SYM_TYPE_DOUBLE=7;
const IMAGE_SYM_TYPE_STRUCT=8;
const IMAGE_SYM_TYPE_UNION=9;
const IMAGE_SYM_TYPE_ENUM=10;
const IMAGE_SYM_TYPE_MOE=11;
const IMAGE_SYM_TYPE_BYTE=12;
const IMAGE_SYM_TYPE_WORD=13;
const IMAGE_SYM_TYPE_UINT=14;
const IMAGE_SYM_TYPE_DWORD=15;
const IMAGE_SYM_TYPE_PCODE=32768;

const IMAGE_SYM_DTYPE_NULL=0;
const IMAGE_SYM_DTYPE_POINTER=1;
const IMAGE_SYM_DTYPE_FUNCTION=2;
const IMAGE_SYM_DTYPE_ARRAY=3;

const IMAGE_SYM_CLASS_END_OF_FUNCTION= -1;
const IMAGE_SYM_CLASS_NULL=0;
const IMAGE_SYM_CLASS_AUTOMATIC=1;
const IMAGE_SYM_CLASS_EXTERNAL=2;
const IMAGE_SYM_CLASS_STATIC=3;
const IMAGE_SYM_CLASS_REGISTER=4;
const IMAGE_SYM_CLASS_EXTERNAL_DEF=5;
const IMAGE_SYM_CLASS_LABEL=6;
const IMAGE_SYM_CLASS_UNDEFINED_LABEL=7;
const IMAGE_SYM_CLASS_MEMBER_OF_STRUCT=8;
const IMAGE_SYM_CLASS_ARGUMENT=9;
const IMAGE_SYM_CLASS_STRUCT_TAG=10;
const IMAGE_SYM_CLASS_MEMBER_OF_UNION=11;
const IMAGE_SYM_CLASS_UNION_TAG=12;
const IMAGE_SYM_CLASS_TYPE_DEFINITION=13;
const IMAGE_SYM_CLASS_UNDEFINED_STATIC=14;
const IMAGE_SYM_CLASS_ENUM_TAG=15;
const IMAGE_SYM_CLASS_MEMBER_OF_ENUM=16;
const IMAGE_SYM_CLASS_REGISTER_PARAM=17;
const IMAGE_SYM_CLASS_BIT_FIELD=18;
const IMAGE_SYM_CLASS_FAR_EXTERNAL=68;
const IMAGE_SYM_CLASS_BLOCK=100;
const IMAGE_SYM_CLASS_FUNCTION=101;
const IMAGE_SYM_CLASS_END_OF_STRUCT=102;
const IMAGE_SYM_CLASS_FILE=103;
const IMAGE_SYM_CLASS_SECTION=104;
const IMAGE_SYM_CLASS_WEAK_EXTERNAL=105;

const IMAGE_COMDAT_SELECT_NODUPLICATES=1;
const IMAGE_COMDAT_SELECT_ANY=2;
const IMAGE_COMDAT_SELECT_SAME_SIZE=3;
const IMAGE_COMDAT_SELECT_EXACT_MATCH=4;
const IMAGE_COMDAT_SELECT_ASSOCIATIVE=5;
const IMAGE_COMDAT_SELECT_LARGEST=6;
const IMAGE_COMDAT_SELECT_NEWEST=7;

const IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY=1;
const IMAGE_WEAK_EXTERN_SEARCH_LIBRARY=2;
const IMAGE_WEAK_EXTERN_SEARCH_ALIAS=3;

const IMAGE_REL_I386_ABSOLUTE=0;
const IMAGE_REL_I386_DIR16=1;
const IMAGE_REL_I386_REL16=2;
const IMAGE_REL_I386_DIR32=6;
const IMAGE_REL_I386_DIR32NB=7;
const IMAGE_REL_I386_SEG12=9;
const IMAGE_REL_I386_SECTION=10;
const IMAGE_REL_I386_SECREL=11;
const IMAGE_REL_I386_REL32=20;

const IMAGE_REL_MIPS_ABSOLUTE=0;
const IMAGE_REL_MIPS_REFHALF=1;
const IMAGE_REL_MIPS_REFWORD=2;
const IMAGE_REL_MIPS_JMPADDR=3;
const IMAGE_REL_MIPS_REFHI=4;
const IMAGE_REL_MIPS_REFLO=5;
const IMAGE_REL_MIPS_GPREL=6;
const IMAGE_REL_MIPS_LITERAL=7;
const IMAGE_REL_MIPS_SECTION=10;
const IMAGE_REL_MIPS_SECREL=11;
const IMAGE_REL_MIPS_SECRELLO=12;
const IMAGE_REL_MIPS_SECRELHI=13;
const IMAGE_REL_MIPS_REFWORDNB=34;
const IMAGE_REL_MIPS_PAIR=35;

const IMAGE_REL_ALPHA_ABSOLUTE=0;
const IMAGE_REL_ALPHA_REFLONG=1;
const IMAGE_REL_ALPHA_REFQUAD=2;
const IMAGE_REL_ALPHA_GPREL32=3;
const IMAGE_REL_ALPHA_LITERAL=4;
const IMAGE_REL_ALPHA_LITUSE=5;
const IMAGE_REL_ALPHA_GPDISP=6;
const IMAGE_REL_ALPHA_BRADDR=7;
const IMAGE_REL_ALPHA_HINT=8;
const IMAGE_REL_ALPHA_INLINE_REFLONG=9;
const IMAGE_REL_ALPHA_REFHI=10;
const IMAGE_REL_ALPHA_REFLO=11;
const IMAGE_REL_ALPHA_PAIR=12;
const IMAGE_REL_ALPHA_MATCH=13;
const IMAGE_REL_ALPHA_SECTION=14;
const IMAGE_REL_ALPHA_SECREL=15;
const IMAGE_REL_ALPHA_REFLONGNB=16;
const IMAGE_REL_ALPHA_SECRELLO=17;
const IMAGE_REL_ALPHA_SECRELHI=18;

const IMAGE_REL_PPC_ABSOLUTE=0;
const IMAGE_REL_PPC_ADDR64=1;
const IMAGE_REL_PPC_ADDR32=2;
const IMAGE_REL_PPC_ADDR24=3;
const IMAGE_REL_PPC_ADDR16=4;
const IMAGE_REL_PPC_ADDR14=5;
const IMAGE_REL_PPC_REL24=6;
const IMAGE_REL_PPC_REL14=7;
const IMAGE_REL_PPC_TOCREL16=8;
const IMAGE_REL_PPC_TOCREL14=9;
const IMAGE_REL_PPC_ADDR32NB=10;
const IMAGE_REL_PPC_SECREL=11;
const IMAGE_REL_PPC_SECTION=12;
const IMAGE_REL_PPC_IFGLUE=13;
const IMAGE_REL_PPC_IMGLUE=14;
const IMAGE_REL_PPC_SECREL16=15;
const IMAGE_REL_PPC_REFHI=16;
const IMAGE_REL_PPC_REFLO=17;
const IMAGE_REL_PPC_PAIR=18;
const IMAGE_REL_PPC_TYPEMASK=255;
const IMAGE_REL_PPC_NEG=256;
const IMAGE_REL_PPC_BRTAKEN=512;
const IMAGE_REL_PPC_BRNTAKEN=1024;
const IMAGE_REL_PPC_TOCDEFN=2048;
const IMAGE_REL_BASED_ABSOLUTE=0;
const IMAGE_REL_BASED_HIGH=1;
const IMAGE_REL_BASED_LOW=2;
const IMAGE_REL_BASED_HIGHLOW=3;
const IMAGE_REL_BASED_HIGHADJ=4;
const IMAGE_REL_BASED_MIPS_JMPADDR=5;

const IMAGE_ARCHIVE_START_SIZE=8;
const TCHAR [] IMAGE_ARCHIVE_START = "!<arch>\n";
const TCHAR [] IMAGE_ARCHIVE_END  = "`\n";
const TCHAR [] IMAGE_ARCHIVE_PAD  = "\n";
const TCHAR [] IMAGE_ARCHIVE_LINKER_MEMBER = "/               ";
const TCHAR [] IMAGE_ARCHIVE_LONGNAMES_MEMBER = "//              ";

const IMAGE_ORDINAL_FLAG32 = 0x80000000;

ulong IMAGE_ORDINAL64(ulong Ordinal) { return Ordinal & 0xffff; }
uint IMAGE_ORDINAL32(uint Ordinal) { return Ordinal & 0xffff; }

bool IMAGE_SNAP_BY_ORDINAL32(uint Ordinal) { return (Ordinal & IMAGE_ORDINAL_FLAG32) != 0; }
const ulong IMAGE_ORDINAL_FLAG64 = 0x8000000000000000L;
bool IMAGE_SNAP_BY_ORDINAL64(ulong Ordinal) { return (Ordinal & IMAGE_ORDINAL_FLAG64) != 0; }

version(Win64) {
	alias IMAGE_ORDINAL_FLAG64 IMAGE_ORDINAL_FLAG;
	alias IMAGE_SNAP_BY_ORDINAL64 IMAGE_SNAP_BY_ORDINAL;
	alias IMAGE_ORDINAL64 IMAGE_ORDINAL;
} else {
	alias IMAGE_ORDINAL_FLAG32 IMAGE_ORDINAL_FLAG;
	alias IMAGE_ORDINAL32 IMAGE_ORDINAL;
	alias IMAGE_SNAP_BY_ORDINAL32 IMAGE_SNAP_BY_ORDINAL;
}

const IMAGE_RESOURCE_NAME_IS_STRING   = 0x80000000;
const IMAGE_RESOURCE_DATA_IS_DIRECTORY = 0x80000000;

const IMAGE_DEBUG_TYPE_UNKNOWN=0;
const IMAGE_DEBUG_TYPE_COFF=1;
const IMAGE_DEBUG_TYPE_CODEVIEW=2;
const IMAGE_DEBUG_TYPE_FPO=3;
const IMAGE_DEBUG_TYPE_MISC=4;
const IMAGE_DEBUG_TYPE_EXCEPTION=5;
const IMAGE_DEBUG_TYPE_FIXUP=6;
const IMAGE_DEBUG_TYPE_OMAP_TO_SRC=7;
const IMAGE_DEBUG_TYPE_OMAP_FROM_SRC=8;

const FRAME_FPO=0;
const FRAME_TRAP=1;
const FRAME_TSS=2;
const FRAME_NONFPO=3;
const IMAGE_DEBUG_MISC_EXENAME=1;

const N_BTMASK=0x000F;
const N_TMASK=0x0030;
const N_TMASK1=0x00C0;
const N_TMASK2=0x00F0;
const N_BTSHFT=4;
const N_TSHIFT=2;

const IS_TEXT_UNICODE_ASCII16=1;
const IS_TEXT_UNICODE_REVERSE_ASCII16=16;
const IS_TEXT_UNICODE_STATISTICS=2;
const IS_TEXT_UNICODE_REVERSE_STATISTICS=32;
const IS_TEXT_UNICODE_CONTROLS=4;
const IS_TEXT_UNICODE_REVERSE_CONTROLS=64;
const IS_TEXT_UNICODE_SIGNATURE=8;
const IS_TEXT_UNICODE_REVERSE_SIGNATURE=128;
const IS_TEXT_UNICODE_ILLEGAL_CHARS=256;
const IS_TEXT_UNICODE_ODD_LENGTH=512;
const IS_TEXT_UNICODE_NULL_BYTES=4096;
const IS_TEXT_UNICODE_UNICODE_MASK=15;
const IS_TEXT_UNICODE_REVERSE_MASK=240;
const IS_TEXT_UNICODE_NOT_UNICODE_MASK=3840;
const IS_TEXT_UNICODE_NOT_ASCII_MASK=61440;
const SERVICE_KERNEL_DRIVER=1;
const SERVICE_FILE_SYSTEM_DRIVER=2;
const SERVICE_ADAPTER=4;
const SERVICE_RECOGNIZER_DRIVER=8;
const SERVICE_DRIVER=(SERVICE_KERNEL_DRIVER|SERVICE_FILE_SYSTEM_DRIVER|SERVICE_RECOGNIZER_DRIVER);
const SERVICE_WIN32_OWN_PROCESS=16;
const SERVICE_WIN32_SHARE_PROCESS=32;
const SERVICE_WIN32=(SERVICE_WIN32_OWN_PROCESS|SERVICE_WIN32_SHARE_PROCESS);
const SERVICE_INTERACTIVE_PROCESS=256;
const SERVICE_TYPE_ALL=(SERVICE_WIN32|SERVICE_ADAPTER|SERVICE_DRIVER|SERVICE_INTERACTIVE_PROCESS);
const SERVICE_BOOT_START=0;
const SERVICE_SYSTEM_START=1;
const SERVICE_AUTO_START=2;
const SERVICE_DEMAND_START=3;
const SERVICE_DISABLED=4;
const SERVICE_ERROR_IGNORE=0;
const SERVICE_ERROR_NORMAL=1;
const SERVICE_ERROR_SEVERE=2;
const SERVICE_ERROR_CRITICAL=3;
const SE_OWNER_DEFAULTED=1;
const SE_GROUP_DEFAULTED=2;
const SE_DACL_PRESENT=4;
const SE_DACL_DEFAULTED=8;
const SE_SACL_PRESENT=16;
const SE_SACL_DEFAULTED=32;
const SE_DACL_AUTO_INHERIT_REQ=256;
const SE_SACL_AUTO_INHERIT_REQ=512;
const SE_DACL_AUTO_INHERITED=1024;
const SE_SACL_AUTO_INHERITED=2048;
const SE_DACL_PROTECTED=4096;
const SE_SACL_PROTECTED=8192;
const SE_SELF_RELATIVE=0x8000;

enum SECURITY_IMPERSONATION_LEVEL {
	SecurityAnonymous,
	SecurityIdentification,
	SecurityImpersonation,
	SecurityDelegation
}
alias SECURITY_IMPERSONATION_LEVEL* PSECURITY_IMPERSONATION_LEVEL;
alias BOOLEAN SECURITY_CONTEXT_TRACKING_MODE;
alias SECURITY_CONTEXT_TRACKING_MODE* PSECURITY_CONTEXT_TRACKING_MODE;




const SECURITY_DESCRIPTOR_MIN_LENGTH=20;
const SECURITY_DESCRIPTOR_REVISION=1;
const SECURITY_DESCRIPTOR_REVISION1=1;
const SE_PRIVILEGE_ENABLED_BY_DEFAULT=1;
const SE_PRIVILEGE_ENABLED=2;
const SE_PRIVILEGE_USED_FOR_ACCESS=0x80000000;
const PRIVILEGE_SET_ALL_NECESSARY=1;
const SECURITY_MAX_IMPERSONATION_LEVEL=SECURITY_IMPERSONATION_LEVEL.SecurityDelegation;
const DEFAULT_IMPERSONATION_LEVEL=SECURITY_IMPERSONATION_LEVEL.SecurityImpersonation;
const SECURITY_DYNAMIC_TRACKING = true;
const SECURITY_STATIC_TRACKING = false;
/* also in ddk/ntifs.h */
const TOKEN_ASSIGN_PRIMARY    = 0x0001;
const TOKEN_DUPLICATE         = 0x0002;
const TOKEN_IMPERSONATE       = 0x0004;
const TOKEN_QUERY             = 0x0008;
const TOKEN_QUERY_SOURCE      = 0x0010;
const TOKEN_ADJUST_PRIVILEGES = 0x0020;
const TOKEN_ADJUST_GROUPS     = 0x0040;
const TOKEN_ADJUST_DEFAULT    = 0x0080;
const TOKEN_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED |
                         TOKEN_ASSIGN_PRIMARY     |
                         TOKEN_DUPLICATE          |
                         TOKEN_IMPERSONATE        |
                         TOKEN_QUERY              |
                         TOKEN_QUERY_SOURCE       |
                         TOKEN_ADJUST_PRIVILEGES  |
                         TOKEN_ADJUST_GROUPS      |
                         TOKEN_ADJUST_DEFAULT;
const TOKEN_READ       = STANDARD_RIGHTS_READ     | TOKEN_QUERY;
const TOKEN_WRITE      = STANDARD_RIGHTS_WRITE    |
                         TOKEN_ADJUST_PRIVILEGES  |
                         TOKEN_ADJUST_GROUPS      |
                         TOKEN_ADJUST_DEFAULT;
const TOKEN_EXECUTE = STANDARD_RIGHTS_EXECUTE;
const TOKEN_SOURCE_LENGTH = 8;
/* end ddk/ntifs.h */

const DLL_PROCESS_DETACH=0;
const DLL_PROCESS_ATTACH=1;
const DLL_THREAD_ATTACH=2;
const DLL_THREAD_DETACH=3;

const DBG_CONTINUE=0x10002;
const DBG_TERMINATE_THREAD=0x40010003;
const DBG_TERMINATE_PROCESS=0x40010004;
const DBG_CONTROL_C=0x40010005;
const DBG_CONTROL_BREAK=0x40010008;
const DBG_EXCEPTION_NOT_HANDLED=0x80010001;

const TAPE_ABSOLUTE_POSITION=0;
const TAPE_LOGICAL_POSITION=1;
const TAPE_PSEUDO_LOGICAL_POSITION=2;

const TAPE_REWIND=0;
const TAPE_ABSOLUTE_BLOCK=1;
const TAPE_LOGICAL_BLOCK=2;
const TAPE_PSEUDO_LOGICAL_BLOCK=3;
const TAPE_SPACE_END_OF_DATA=4;
const TAPE_SPACE_RELATIVE_BLOCKS=5;
const TAPE_SPACE_FILEMARKS=6;
const TAPE_SPACE_SEQUENTIAL_FMKS=7;
const TAPE_SPACE_SETMARKS=8;
const TAPE_SPACE_SEQUENTIAL_SMKS=9;
const TAPE_DRIVE_FIXED=1;
const TAPE_DRIVE_SELECT=2;
const TAPE_DRIVE_INITIATOR=4;
const TAPE_DRIVE_ERASE_SHORT=16;
const TAPE_DRIVE_ERASE_LONG=32;
const TAPE_DRIVE_ERASE_BOP_ONLY=64;
const TAPE_DRIVE_ERASE_IMMEDIATE=128;
const TAPE_DRIVE_TAPE_CAPACITY=256;
const TAPE_DRIVE_TAPE_REMAINING=512;
const TAPE_DRIVE_FIXED_BLOCK=1024;
const TAPE_DRIVE_VARIABLE_BLOCK=2048;
const TAPE_DRIVE_WRITE_PROTECT=4096;
const TAPE_DRIVE_EOT_WZ_SIZE=8192;
const TAPE_DRIVE_ECC=0x10000;
const TAPE_DRIVE_COMPRESSION=0x20000;
const TAPE_DRIVE_PADDING=0x40000;
const TAPE_DRIVE_REPORT_SMKS=0x80000;
const TAPE_DRIVE_GET_ABSOLUTE_BLK=0x100000;
const TAPE_DRIVE_GET_LOGICAL_BLK=0x200000;
const TAPE_DRIVE_SET_EOT_WZ_SIZE=0x400000;
const TAPE_DRIVE_EJECT_MEDIA=0x1000000;
const TAPE_DRIVE_CLEAN_REQUESTS=0x2000000;
const TAPE_DRIVE_SET_CMP_BOP_ONLY=0x4000000;
const TAPE_DRIVE_RESERVED_BIT=0x80000000;
const TAPE_DRIVE_LOAD_UNLOAD=0x80000001;
const TAPE_DRIVE_TENSION=0x80000002;
const TAPE_DRIVE_LOCK_UNLOCK=0x80000004;
const TAPE_DRIVE_REWIND_IMMEDIATE=0x80000008;
const TAPE_DRIVE_SET_BLOCK_SIZE=0x80000010;
const TAPE_DRIVE_LOAD_UNLD_IMMED=0x80000020;
const TAPE_DRIVE_TENSION_IMMED=0x80000040;
const TAPE_DRIVE_LOCK_UNLK_IMMED=0x80000080;
const TAPE_DRIVE_SET_ECC=0x80000100;
const TAPE_DRIVE_SET_COMPRESSION=0x80000200;
const TAPE_DRIVE_SET_PADDING=0x80000400;
const TAPE_DRIVE_SET_REPORT_SMKS=0x80000800;
const TAPE_DRIVE_ABSOLUTE_BLK=0x80001000;
const TAPE_DRIVE_ABS_BLK_IMMED=0x80002000;
const TAPE_DRIVE_LOGICAL_BLK=0x80004000;
const TAPE_DRIVE_LOG_BLK_IMMED=0x80008000;
const TAPE_DRIVE_END_OF_DATA=0x80010000;
const TAPE_DRIVE_RELATIVE_BLKS=0x80020000;
const TAPE_DRIVE_FILEMARKS=0x80040000;
const TAPE_DRIVE_SEQUENTIAL_FMKS=0x80080000;
const TAPE_DRIVE_SETMARKS=0x80100000;
const TAPE_DRIVE_SEQUENTIAL_SMKS=0x80200000;
const TAPE_DRIVE_REVERSE_POSITION=0x80400000;
const TAPE_DRIVE_SPACE_IMMEDIATE=0x80800000;
const TAPE_DRIVE_WRITE_SETMARKS=0x81000000;
const TAPE_DRIVE_WRITE_FILEMARKS=0x82000000;
const TAPE_DRIVE_WRITE_SHORT_FMKS=0x84000000;
const TAPE_DRIVE_WRITE_LONG_FMKS=0x88000000;
const TAPE_DRIVE_WRITE_MARK_IMMED=0x90000000;
const TAPE_DRIVE_FORMAT=0xA0000000;
const TAPE_DRIVE_FORMAT_IMMEDIATE=0xC0000000;
const TAPE_DRIVE_HIGH_FEATURES=0x80000000;

const TAPE_FIXED_PARTITIONS=0;
const TAPE_INITIATOR_PARTITIONS=2;
const TAPE_SELECT_PARTITIONS=1;
const TAPE_FILEMARKS=1;
const TAPE_LONG_FILEMARKS=3;
const TAPE_SETMARKS=0;
const TAPE_SHORT_FILEMARKS=2;

const TAPE_ERASE_LONG=1;
const TAPE_ERASE_SHORT=0;

const TAPE_LOAD=0;
const TAPE_UNLOAD=1;
const TAPE_TENSION=2;
const TAPE_LOCK=3;
const TAPE_UNLOCK=4;
const TAPE_FORMAT=5;

static if (_WIN32_WINNT >= 0x0500) {

const VER_MINORVERSION=0x0000001;
const VER_MAJORVERSION=0x0000002;
const VER_BUILDNUMBER=0x0000004;
const VER_PLATFORMID=0x0000008;
const VER_SERVICEPACKMINOR=0x0000010;
const VER_SERVICEPACKMAJOR=0x0000020;
const VER_SUITENAME=0x0000040;
const VER_PRODUCT_TYPE=0x0000080;
const VER_EQUAL=1;
const VER_GREATER=2;
const VER_GREATER_EQUAL=3;
const VER_LESS=4;
const VER_LESS_EQUAL=5;
const VER_AND=6;
const VER_OR=7;

}
const VER_PLATFORM_WIN32s=0;
const VER_PLATFORM_WIN32_WINDOWS=1;
const VER_PLATFORM_WIN32_NT=2;
const VER_NT_WORKSTATION=1;
const VER_NT_DOMAIN_CONTROLLER=2;
const VER_NT_SERVER=3;
const VER_SUITE_SMALLBUSINESS=1;
const VER_SUITE_ENTERPRISE=2;
const VER_SUITE_BACKOFFICE=4;
const VER_SUITE_TERMINAL=16;
const VER_SUITE_SMALLBUSINESS_RESTRICTED=32;
const VER_SUITE_DATACENTER=128;
const VER_SUITE_PERSONAL=512;
const VER_SUITE_BLADE=1024;

const WT_EXECUTEDEFAULT=0x00000000;
const WT_EXECUTEINIOTHREAD=0x00000001;
const WT_EXECUTEINWAITTHREAD=0x00000004;
const WT_EXECUTEONLYONCE=0x00000008;
const WT_EXECUTELONGFUNCTION=0x00000010;
const WT_EXECUTEINTIMERTHREAD=0x00000020;
const WT_EXECUTEINPERSISTENTTHREAD=0x00000080;
const WT_TRANSFER_IMPERSONATION=0x00000100;

static if (_WIN32_WINNT >= 0x0501) {

enum {
	ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION=1,
	ACTIVATION_CONTEXT_SECTION_DLL_REDIRECTION,
	ACTIVATION_CONTEXT_SECTION_WINDOW_CLASS_REDIRECTION,
	ACTIVATION_CONTEXT_SECTION_COM_SERVER_REDIRECTION,
	ACTIVATION_CONTEXT_SECTION_COM_INTERFACE_REDIRECTION,
	ACTIVATION_CONTEXT_SECTION_COM_TYPE_LIBRARY_REDIRECTION,
	ACTIVATION_CONTEXT_SECTION_COM_PROGID_REDIRECTION, // =7
	ACTIVATION_CONTEXT_SECTION_CLR_SURROGATES = 9
}

}

// Macros
BYTE BTYPE(BYTE x) { return x & N_BTMASK; }
bool ISPTR(uint x) { return (x & N_TMASK) == (IMAGE_SYM_DTYPE_POINTER << N_BTSHFT); }
bool ISFCN(uint x) { return (x & N_TMASK) == (IMAGE_SYM_DTYPE_FUNCTION << N_BTSHFT); }
bool ISARY(uint x) { return (x & N_TMASK) == (IMAGE_SYM_DTYPE_ARRAY << N_BTSHFT); }
bool ISTAG(uint x) {
		return x == IMAGE_SYM_CLASS_STRUCT_TAG || x == IMAGE_SYM_CLASS_UNION_TAG || x == IMAGE_SYM_CLASS_ENUM_TAG; }
uint INCREF(uint x) {
	return ((x&~N_BTMASK)<<N_TSHIFT)|(IMAGE_SYM_DTYPE_POINTER<<N_BTSHFT)|(x&N_BTMASK); }
uint DECREF(uint x) { return ((x >>> N_TSHIFT) & ~N_BTMASK)|(x & N_BTMASK); }

const TLS_MINIMUM_AVAILABLE=64;
const IO_REPARSE_TAG_RESERVED_ZERO = 0;
const IO_REPARSE_TAG_RESERVED_ONE = 1;
const IO_REPARSE_TAG_RESERVED_RANGE = IO_REPARSE_TAG_RESERVED_ONE;
//MACRO #define IsReparseTagMicrosoft(x) ((x)&0x80000000)

//MACRO #define IsReparseTagHighLatency(x) ((x)&0x40000000)

//MACRO #define IsReparseTagNameSurrogate(x) ((x)&0x20000000)

const IO_REPARSE_TAG_VALID_VALUES=0xE000FFFF;
//MACRO #define IsReparseTagValid(x) (!((x)&~IO_REPARSE_TAG_VALID_VALUES)&&((x)>IO_REPARSE_TAG_RESERVED_RANGE))

const IO_REPARSE_TAG_SYMBOLIC_LINK=IO_REPARSE_TAG_RESERVED_ZERO;
const IO_REPARSE_TAG_MOUNT_POINT=0xA0000003;

alias DWORD ACCESS_MASK;
alias ACCESS_MASK *PACCESS_MASK;

public import win32.basetyps;
/* also in win32.basetyps
struct GUID {
	uint  Data1;
	ushort Data2;
	ushort Data3;
	ubyte  Data4[8];
}
alias GUID* REFGUID, LPGUID;
*/
const LUID SYSTEM_LUID = { QuadPart:999 };

struct GENERIC_MAPPING {
	ACCESS_MASK GenericRead;
	ACCESS_MASK GenericWrite;
	ACCESS_MASK GenericExecute;
	ACCESS_MASK GenericAll;
}
alias GENERIC_MAPPING* PGENERIC_MAPPING;

struct ACE_HEADER {
	BYTE AceType;
	BYTE AceFlags;
	WORD AceSize;
}
alias ACE_HEADER* PACE_HEADER;

struct ACCESS_ALLOWED_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD SidStart;
}
alias ACCESS_ALLOWED_ACE* PACCESS_ALLOWED_ACE;

struct ACCESS_DENIED_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD SidStart;
}
alias ACCESS_DENIED_ACE* PACCESS_DENIED_ACE;

struct SYSTEM_AUDIT_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD SidStart;
}
alias SYSTEM_AUDIT_ACE *PSYSTEM_AUDIT_ACE;

struct SYSTEM_ALARM_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD SidStart;
}
alias SYSTEM_ALARM_ACE* PSYSTEM_ALARM_ACE;

struct ACCESS_ALLOWED_OBJECT_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD Flags;
	GUID ObjectType;
	GUID InheritedObjectType;
	DWORD SidStart;
}
alias ACCESS_ALLOWED_OBJECT_ACE* PACCESS_ALLOWED_OBJECT_ACE;

struct ACCESS_DENIED_OBJECT_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD Flags;
	GUID ObjectType;
	GUID InheritedObjectType;
	DWORD SidStart;
}
alias ACCESS_DENIED_OBJECT_ACE* PACCESS_DENIED_OBJECT_ACE;

struct SYSTEM_AUDIT_OBJECT_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD Flags;
	GUID ObjectType;
	GUID InheritedObjectType;
	DWORD SidStart;
}
alias SYSTEM_AUDIT_OBJECT_ACE* PSYSTEM_AUDIT_OBJECT_ACE;

struct SYSTEM_ALARM_OBJECT_ACE {
	ACE_HEADER Header;
	ACCESS_MASK Mask;
	DWORD Flags;
	GUID ObjectType;
	GUID InheritedObjectType;
	DWORD SidStart;
}
alias SYSTEM_ALARM_OBJECT_ACE* PSYSTEM_ALARM_OBJECT_ACE;

struct ACL {
	BYTE AclRevision;
	BYTE Sbz1;
	WORD AclSize;
	WORD AceCount;
	WORD Sbz2;
}
alias ACL* PACL;

struct ACL_REVISION_INFORMATION {
	DWORD AclRevision;
}

struct ACL_SIZE_INFORMATION {
	DWORD   AceCount;
	DWORD   AclBytesInUse;
	DWORD   AclBytesFree;
}

version(X86) {
	const SIZE_OF_80387_REGISTERS=80;
	const CONTEXT_i386=0x10000;
	const CONTEXT_i486=0x10000;
	const CONTEXT_CONTROL=(CONTEXT_i386|0x00000001L);
	const CONTEXT_INTEGER=(CONTEXT_i386|0x00000002L);
	const CONTEXT_SEGMENTS=(CONTEXT_i386|0x00000004L);
	const CONTEXT_FLOATING_POINT=(CONTEXT_i386|0x00000008L);
	const CONTEXT_DEBUG_REGISTERS=(CONTEXT_i386|0x00000010L);
	const CONTEXT_EXTENDED_REGISTERS=(CONTEXT_i386|0x00000020L);
	const CONTEXT_FULL=(CONTEXT_CONTROL|CONTEXT_INTEGER|CONTEXT_SEGMENTS);
	const MAXIMUM_SUPPORTED_EXTENSION=512;

	struct FLOATING_SAVE_AREA {
		DWORD    ControlWord;
		DWORD    StatusWord;
		DWORD    TagWord;
		DWORD    ErrorOffset;
		DWORD    ErrorSelector;
		DWORD    DataOffset;
		DWORD    DataSelector;
		BYTE[80] RegisterArea;
		DWORD    Cr0NpxState;
	}

	struct CONTEXT {
		DWORD ContextFlags;
		DWORD Dr0;
		DWORD Dr1;
		DWORD Dr2;
		DWORD Dr3;
		DWORD Dr6;
		DWORD Dr7;
		FLOATING_SAVE_AREA FloatSave;
		DWORD SegGs;
		DWORD SegFs;
		DWORD SegEs;
		DWORD SegDs;
		DWORD Edi;
		DWORD Esi;
		DWORD Ebx;
		DWORD Edx;
		DWORD Ecx;
		DWORD Eax;
		DWORD Ebp;
		DWORD Eip;
		DWORD SegCs;
		DWORD EFlags;
		DWORD Esp;
		DWORD SegSs;
		BYTE[MAXIMUM_SUPPORTED_EXTENSION] ExtendedRegisters;
	}

} else {
	pragma(msg, "Unsupported CPU");
	static assert(0);
	// Versions for PowerPC, Alpha, SHX, and MIPS removed.
}


alias CONTEXT* PCONTEXT, LPCONTEXT;

struct EXCEPTION_RECORD {
	DWORD ExceptionCode;
	DWORD ExceptionFlags;
	EXCEPTION_RECORD *ExceptionRecord;
	PVOID ExceptionAddress;
	DWORD NumberParameters;
	DWORD ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
}
alias EXCEPTION_RECORD* PEXCEPTION_RECORD, LPEXCEPTION_RECORD;

struct EXCEPTION_POINTERS {
	PEXCEPTION_RECORD ExceptionRecord;
	PCONTEXT ContextRecord;
}
alias EXCEPTION_POINTERS* PEXCEPTION_POINTERS, LPEXCEPTION_POINTERS;

union LARGE_INTEGER {
	struct {
		uint LowPart;
		int  HighPart;
	}
	long QuadPart;
}
alias LARGE_INTEGER* PLARGE_INTEGER;

union ULARGE_INTEGER {
	struct {
		uint LowPart;
		uint HighPart;
	}
	ulong QuadPart;
}
alias ULARGE_INTEGER* PULARGE_INTEGER;

alias LARGE_INTEGER LUID;
alias LUID* PLUID;

align(4):
struct LUID_AND_ATTRIBUTES {
	LUID   Luid;
	DWORD  Attributes;
}
alias LUID_AND_ATTRIBUTES* PLUID_AND_ATTRIBUTES;

align:

alias LUID_AND_ATTRIBUTES[ANYSIZE_ARRAY] LUID_AND_ATTRIBUTES_ARRAY;
alias LUID_AND_ATTRIBUTES_ARRAY* PLUID_AND_ATTRIBUTES_ARRAY;

struct PRIVILEGE_SET {
	DWORD PrivilegeCount;
	DWORD Control;
	LUID_AND_ATTRIBUTES Privilege[ANYSIZE_ARRAY];
}
alias PRIVILEGE_SET* PPRIVILEGE_SET;

struct SECURITY_ATTRIBUTES {
	DWORD nLength;
	LPVOID lpSecurityDescriptor;
	BOOL bInheritHandle;
}
alias SECURITY_ATTRIBUTES* PSECURITY_ATTRIBUTES, LPSECURITY_ATTRIBUTES;

struct SECURITY_QUALITY_OF_SERVICE {
	DWORD Length;
	SECURITY_IMPERSONATION_LEVEL ImpersonationLevel;
	SECURITY_CONTEXT_TRACKING_MODE ContextTrackingMode;
	BOOLEAN EffectiveOnly;
}
alias SECURITY_QUALITY_OF_SERVICE* PSECURITY_QUALITY_OF_SERVICE;

alias PVOID PACCESS_TOKEN;

struct SE_IMPERSONATION_STATE {
	PACCESS_TOKEN Token;
	BOOLEAN CopyOnOpen;
	BOOLEAN EffectiveOnly;
	SECURITY_IMPERSONATION_LEVEL Level;
}
alias SE_IMPERSONATION_STATE* PSE_IMPERSONATION_STATE;

struct SID_IDENTIFIER_AUTHORITY {
	BYTE Value[6];
}
alias SID_IDENTIFIER_AUTHORITY* PSID_IDENTIFIER_AUTHORITY, LPSID_IDENTIFIER_AUTHORITY;

alias PVOID PSID;

struct SID {
	BYTE  Revision;
	BYTE  SubAuthorityCount;
	SID_IDENTIFIER_AUTHORITY IdentifierAuthority;
	DWORD SubAuthority[ANYSIZE_ARRAY];
}
alias SID* PISID;

struct SID_AND_ATTRIBUTES {
	PSID Sid;
	DWORD Attributes;
}
alias SID_AND_ATTRIBUTES* PSID_AND_ATTRIBUTES;
alias SID_AND_ATTRIBUTES[ANYSIZE_ARRAY] SID_AND_ATTRIBUTES_ARRAY;
alias SID_AND_ATTRIBUTES_ARRAY* PSID_AND_ATTRIBUTES_ARRAY;

struct TOKEN_SOURCE {
	CHAR SourceName[TOKEN_SOURCE_LENGTH];
	LUID SourceIdentifier;
}
alias TOKEN_SOURCE* PTOKEN_SOURCE;

struct TOKEN_CONTROL {
	LUID TokenId;
	LUID AuthenticationId;
	LUID ModifiedId;
	TOKEN_SOURCE TokenSource;
}
alias TOKEN_CONTROL* PTOKEN_CONTROL;

struct TOKEN_DEFAULT_DACL {
	PACL DefaultDacl;
}
alias TOKEN_DEFAULT_DACL* PTOKEN_DEFAULT_DACL;

struct TOKEN_GROUPS {
	DWORD GroupCount;
	SID_AND_ATTRIBUTES Groups[ANYSIZE_ARRAY];
}
alias TOKEN_GROUPS* PTOKEN_GROUPS, LPTOKEN_GROUPS;

struct TOKEN_OWNER {
	PSID Owner;
}
alias TOKEN_OWNER* PTOKEN_OWNER;

struct TOKEN_PRIMARY_GROUP {
	PSID PrimaryGroup;
}
alias TOKEN_PRIMARY_GROUP* PTOKEN_PRIMARY_GROUP;

struct TOKEN_PRIVILEGES {
	DWORD PrivilegeCount;
	LUID_AND_ATTRIBUTES Privileges[ANYSIZE_ARRAY];
}
alias TOKEN_PRIVILEGES* PTOKEN_PRIVILEGES, LPTOKEN_PRIVILEGES;

enum TOKEN_TYPE {
	TokenPrimary = 1,
	TokenImpersonation
}
alias TOKEN_TYPE* PTOKEN_TYPE;

struct TOKEN_STATISTICS {
	LUID TokenId;
	LUID AuthenticationId;
	LARGE_INTEGER ExpirationTime;
	TOKEN_TYPE TokenType;
	SECURITY_IMPERSONATION_LEVEL ImpersonationLevel;
	DWORD DynamicCharged;
	DWORD DynamicAvailable;
	DWORD GroupCount;
	DWORD PrivilegeCount;
	LUID ModifiedId;
}
alias TOKEN_STATISTICS* PTOKEN_STATISTICS;

struct TOKEN_USER {
	SID_AND_ATTRIBUTES User;
}
alias TOKEN_USER *PTOKEN_USER;

alias DWORD SECURITY_INFORMATION;
alias SECURITY_INFORMATION* PSECURITY_INFORMATION;
alias WORD SECURITY_DESCRIPTOR_CONTROL;
alias SECURITY_DESCRIPTOR_CONTROL* PSECURITY_DESCRIPTOR_CONTROL;

struct SECURITY_DESCRIPTOR {
	BYTE Revision;
	BYTE Sbz1;
	SECURITY_DESCRIPTOR_CONTROL Control;
	PSID Owner;
	PSID Group;
	PACL Sacl;
	PACL Dacl;
}
alias SECURITY_DESCRIPTOR* PSECURITY_DESCRIPTOR, PISECURITY_DESCRIPTOR;

enum TOKEN_INFORMATION_CLASS {
	TokenUser=1,
	TokenGroups,
	TokenPrivileges,
	TokenOwner,
	TokenPrimaryGroup,
	TokenDefaultDacl,
	TokenSource,
	TokenType,
	TokenImpersonationLevel,
	TokenStatistics,
	TokenRestrictedSids,
	TokenSessionId,
	TokenGroupsAndPrivileges,
	TokenSessionReference,
	TokenSandBoxInert,
	TokenAuditPolicy,
	TokenOrigin
}

enum SID_NAME_USE {
	SidTypeUser=1,
	SidTypeGroup,
	SidTypeDomain,
	SidTypeAlias,
	SidTypeWellKnownGroup,
	SidTypeDeletedAccount,
	SidTypeInvalid,
	SidTypeUnknown,
	SidTypeComputer
}
alias SID_NAME_USE* PSID_NAME_USE;

struct QUOTA_LIMITS {
	SIZE_T PagedPoolLimit;
	SIZE_T NonPagedPoolLimit;
	SIZE_T MinimumWorkingSetSize;
	SIZE_T MaximumWorkingSetSize;
	SIZE_T PagefileLimit;
	LARGE_INTEGER TimeLimit;
}
alias QUOTA_LIMITS* PQUOTA_LIMITS;

struct IO_COUNTERS {
	ULONGLONG  ReadOperationCount;
	ULONGLONG  WriteOperationCount;
	ULONGLONG  OtherOperationCount;
	ULONGLONG ReadTransferCount;
	ULONGLONG WriteTransferCount;
	ULONGLONG OtherTransferCount;
}
alias IO_COUNTERS* PIO_COUNTERS;

struct FILE_NOTIFY_INFORMATION {
	DWORD NextEntryOffset;
	DWORD Action;
	DWORD FileNameLength;
	WCHAR FileName[1];
}
alias FILE_NOTIFY_INFORMATION* PFILE_NOTIFY_INFORMATION;

struct TAPE_ERASE {
	DWORD Type;
	BOOLEAN Immediate;
}
alias TAPE_ERASE* PTAPE_ERASE;

struct TAPE_GET_DRIVE_PARAMETERS {
	BOOLEAN ECC;
	BOOLEAN Compression;
	BOOLEAN DataPadding;
	BOOLEAN ReportSetmarks;
	DWORD DefaultBlockSize;
	DWORD MaximumBlockSize;
	DWORD MinimumBlockSize;
	DWORD MaximumPartitionCount;
	DWORD FeaturesLow;
	DWORD FeaturesHigh;
	DWORD EOTWarningZoneSize;
}
alias TAPE_GET_DRIVE_PARAMETERS* PTAPE_GET_DRIVE_PARAMETERS;

struct TAPE_GET_MEDIA_PARAMETERS {
	LARGE_INTEGER Capacity;
	LARGE_INTEGER Remaining;
	DWORD BlockSize;
	DWORD PartitionCount;
	BOOLEAN WriteProtected;
}
alias TAPE_GET_MEDIA_PARAMETERS* PTAPE_GET_MEDIA_PARAMETERS;

struct TAPE_GET_POSITION {
	ULONG Type;
	ULONG Partition;
	ULONG OffsetLow;
	ULONG OffsetHigh;
}
alias TAPE_GET_POSITION* PTAPE_GET_POSITION;

struct TAPE_PREPARE {
	DWORD Operation;
	BOOLEAN Immediate;
}
alias TAPE_PREPARE* PTAPE_PREPARE;

struct TAPE_SET_DRIVE_PARAMETERS {
	BOOLEAN ECC;
	BOOLEAN Compression;
	BOOLEAN DataPadding;
	BOOLEAN ReportSetmarks;
	ULONG EOTWarningZoneSize;
}
alias TAPE_SET_DRIVE_PARAMETERS* PTAPE_SET_DRIVE_PARAMETERS;

struct TAPE_SET_MEDIA_PARAMETERS {
	ULONG BlockSize;
}
alias TAPE_SET_MEDIA_PARAMETERS* PTAPE_SET_MEDIA_PARAMETERS;

struct TAPE_SET_POSITION {
	DWORD Method;
	DWORD Partition;
	LARGE_INTEGER Offset;
	BOOLEAN Immediate;
}
alias TAPE_SET_POSITION* PTAPE_SET_POSITION;

struct TAPE_WRITE_MARKS {
	DWORD Type;
	DWORD Count;
	BOOLEAN Immediate;
}
alias TAPE_WRITE_MARKS* PTAPE_WRITE_MARKS;

struct TAPE_CREATE_PARTITION {
	DWORD Method;
	DWORD Count;
	DWORD Size;
}
alias TAPE_CREATE_PARTITION* PTAPE_CREATE_PARTITION;

struct MEMORY_BASIC_INFORMATION {
	PVOID BaseAddress;
	PVOID AllocationBase;
	DWORD AllocationProtect;
	DWORD RegionSize;
	DWORD State;
	DWORD Protect;
	DWORD Type;
}
alias MEMORY_BASIC_INFORMATION* PMEMORY_BASIC_INFORMATION;

struct MESSAGE_RESOURCE_ENTRY {
	WORD Length;
	WORD Flags;
	BYTE Text[1];
}
alias MESSAGE_RESOURCE_ENTRY* PMESSAGE_RESOURCE_ENTRY;

struct MESSAGE_RESOURCE_BLOCK {
	DWORD LowId;
	DWORD HighId;
	DWORD OffsetToEntries;
}
alias MESSAGE_RESOURCE_BLOCK* PMESSAGE_RESOURCE_BLOCK;

struct MESSAGE_RESOURCE_DATA {
	DWORD NumberOfBlocks;
	MESSAGE_RESOURCE_BLOCK Blocks[1];
}
alias MESSAGE_RESOURCE_DATA* PMESSAGE_RESOURCE_DATA;

struct LIST_ENTRY {
	LIST_ENTRY *Flink;
	LIST_ENTRY *Blink;
}
alias LIST_ENTRY* PLIST_ENTRY;

struct SINGLE_LIST_ENTRY {
	SINGLE_LIST_ENTRY *Next;
}
alias SINGLE_LIST_ENTRY* PSINGLE_LIST_ENTRY;


//#ifndef _SLIST_HEADER_
//#define _SLIST_HEADER_
alias  SINGLE_LIST_ENTRY SLIST_ENTRY;
alias PSINGLE_LIST_ENTRY PSLIST_ENTRY;
union SLIST_HEADER {
	ULONGLONG Alignment;
	struct {
		SLIST_ENTRY Next;
		WORD Depth;
		WORD Sequence;
	}
}
alias SLIST_HEADER* PSLIST_HEADER;
// #endif /* !_SLIST_HEADER_ */

struct RTL_CRITICAL_SECTION_DEBUG {
	WORD Type;
	WORD CreatorBackTraceIndex;
	RTL_CRITICAL_SECTION *CriticalSection;
	LIST_ENTRY ProcessLocksList;
	DWORD EntryCount;
	DWORD ContentionCount;
	DWORD Spare[2];
}
alias RTL_CRITICAL_SECTION_DEBUG* PRTL_CRITICAL_SECTION_DEBUG;

struct RTL_CRITICAL_SECTION {
	PRTL_CRITICAL_SECTION_DEBUG DebugInfo;
	LONG LockCount;
	LONG RecursionCount;
	HANDLE OwningThread;
	HANDLE LockSemaphore;
	DWORD Reserved;
}
alias RTL_CRITICAL_SECTION* PRTL_CRITICAL_SECTION;

struct EVENTLOGRECORD {
	DWORD Length;
	DWORD Reserved;
	DWORD RecordNumber;
	DWORD TimeGenerated;
	DWORD TimeWritten;
	DWORD EventID;
	WORD EventType;
	WORD NumStrings;
	WORD EventCategory;
	WORD ReservedFlags;
	DWORD ClosingRecordNumber;
	DWORD StringOffset;
	DWORD UserSidLength;
	DWORD UserSidOffset;
	DWORD DataLength;
	DWORD DataOffset;
}
alias EVENTLOGRECORD* PEVENTLOGRECORD;

struct OSVERSIONINFOA {
	DWORD dwOSVersionInfoSize;
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
	DWORD dwPlatformId;
	CHAR szCSDVersion[128];
}
alias OSVERSIONINFOA* POSVERSIONINFOA, LPOSVERSIONINFOA;

struct OSVERSIONINFOW {
	DWORD dwOSVersionInfoSize;
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
	DWORD dwPlatformId;
	WCHAR szCSDVersion[128];
}
alias OSVERSIONINFOW* POSVERSIONINFOW, LPOSVERSIONINFOW;

struct OSVERSIONINFOEXA {
	DWORD dwOSVersionInfoSize;
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
	DWORD dwPlatformId;
	CHAR szCSDVersion[128];
	WORD wServicePackMajor;
	WORD wServicePackMinor;
	WORD wSuiteMask;
	BYTE wProductType;
	BYTE wReserved;
}
alias OSVERSIONINFOEXA* POSVERSIONINFOEXA, LPOSVERSIONINFOEXA;

struct OSVERSIONINFOEXW {
	DWORD dwOSVersionInfoSize;
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
	DWORD dwPlatformId;
	WCHAR szCSDVersion[128];
	WORD wServicePackMajor;
	WORD wServicePackMinor;
	WORD wSuiteMask;
	BYTE wProductType;
	BYTE wReserved;
}
alias OSVERSIONINFOEXW* POSVERSIONINFOEXW, LPOSVERSIONINFOEXW;

align(2):
struct IMAGE_VXD_HEADER {
	WORD e32_magic;
	BYTE e32_border;
	BYTE e32_worder;
	DWORD e32_level;
	WORD e32_cpu;
	WORD e32_os;
	DWORD e32_ver;
	DWORD e32_mflags;
	DWORD e32_mpages;
	DWORD e32_startobj;
	DWORD e32_eip;
	DWORD e32_stackobj;
	DWORD e32_esp;
	DWORD e32_pagesize;
	DWORD e32_lastpagesize;
	DWORD e32_fixupsize;
	DWORD e32_fixupsum;
	DWORD e32_ldrsize;
	DWORD e32_ldrsum;
	DWORD e32_objtab;
	DWORD e32_objcnt;
	DWORD e32_objmap;
	DWORD e32_itermap;
	DWORD e32_rsrctab;
	DWORD e32_rsrccnt;
	DWORD e32_restab;
	DWORD e32_enttab;
	DWORD e32_dirtab;
	DWORD e32_dircnt;
	DWORD e32_fpagetab;
	DWORD e32_frectab;
	DWORD e32_impmod;
	DWORD e32_impmodcnt;
	DWORD e32_impproc;
	DWORD e32_pagesum;
	DWORD e32_datapage;
	DWORD e32_preload;
	DWORD e32_nrestab;
	DWORD e32_cbnrestab;
	DWORD e32_nressum;
	DWORD e32_autodata;
	DWORD e32_debuginfo;
	DWORD e32_debuglen;
	DWORD e32_instpreload;
	DWORD e32_instdemand;
	DWORD e32_heapsize;
	BYTE e32_res3[12];
	DWORD e32_winresoff;
	DWORD e32_winreslen;
	WORD e32_devid;
	WORD e32_ddkver;
}
alias IMAGE_VXD_HEADER* PIMAGE_VXD_HEADER;

align(4):
struct IMAGE_FILE_HEADER {
	WORD Machine;
	WORD NumberOfSections;
	DWORD TimeDateStamp;
	DWORD PointerToSymbolTable;
	DWORD NumberOfSymbols;
	WORD SizeOfOptionalHeader;
	WORD Characteristics;
}
alias IMAGE_FILE_HEADER* PIMAGE_FILE_HEADER;
// const IMAGE_SIZEOF_FILE_HEADER = IMAGE_FILE_HEADER.sizeof;


struct IMAGE_DATA_DIRECTORY {
	DWORD VirtualAddress;
	DWORD Size;
}
alias IMAGE_DATA_DIRECTORY* PIMAGE_DATA_DIRECTORY;

struct IMAGE_OPTIONAL_HEADER {
	WORD Magic;
	BYTE MajorLinkerVersion;
	BYTE MinorLinkerVersion;
	DWORD SizeOfCode;
	DWORD SizeOfInitializedData;
	DWORD SizeOfUninitializedData;
	DWORD AddressOfEntryPoint;
	DWORD BaseOfCode;
	DWORD BaseOfData;
	DWORD ImageBase;
	DWORD SectionAlignment;
	DWORD FileAlignment;
	WORD MajorOperatingSystemVersion;
	WORD MinorOperatingSystemVersion;
	WORD MajorImageVersion;
	WORD MinorImageVersion;
	WORD MajorSubsystemVersion;
	WORD MinorSubsystemVersion;
	DWORD Reserved1;
	DWORD SizeOfImage;
	DWORD SizeOfHeaders;
	DWORD CheckSum;
	WORD Subsystem;
	WORD DllCharacteristics;
	DWORD SizeOfStackReserve;
	DWORD SizeOfStackCommit;
	DWORD SizeOfHeapReserve;
	DWORD SizeOfHeapCommit;
	DWORD LoaderFlags;
	DWORD NumberOfRvaAndSizes;
	IMAGE_DATA_DIRECTORY DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
}
alias IMAGE_OPTIONAL_HEADER* PIMAGE_OPTIONAL_HEADER;

struct IMAGE_ROM_OPTIONAL_HEADER {
	WORD Magic;
	BYTE MajorLinkerVersion;
	BYTE MinorLinkerVersion;
	DWORD SizeOfCode;
	DWORD SizeOfInitializedData;
	DWORD SizeOfUninitializedData;
	DWORD AddressOfEntryPoint;
	DWORD BaseOfCode;
	DWORD BaseOfData;
	DWORD BaseOfBss;
	DWORD GprMask;
	DWORD CprMask[4];
	DWORD GpValue;
}
alias IMAGE_ROM_OPTIONAL_HEADER* PIMAGE_ROM_OPTIONAL_HEADER;

align(2):
struct IMAGE_DOS_HEADER {
	WORD e_magic;
	WORD e_cblp;
	WORD e_cp;
	WORD e_crlc;
	WORD e_cparhdr;
	WORD e_minalloc;
	WORD e_maxalloc;
	WORD e_ss;
	WORD e_sp;
	WORD e_csum;
	WORD e_ip;
	WORD e_cs;
	WORD e_lfarlc;
	WORD e_ovno;
	WORD e_res[4];
	WORD e_oemid;
	WORD e_oeminfo;
	WORD e_res2[10];
	LONG e_lfanew;
}
alias IMAGE_DOS_HEADER* PIMAGE_DOS_HEADER;

struct IMAGE_OS2_HEADER {
	WORD ne_magic;
	CHAR ne_ver;
	CHAR ne_rev;
	WORD ne_enttab;
	WORD ne_cbenttab;
	LONG ne_crc;
	WORD ne_flags;
	WORD ne_autodata;
	WORD ne_heap;
	WORD ne_stack;
	LONG ne_csip;
	LONG ne_sssp;
	WORD ne_cseg;
	WORD ne_cmod;
	WORD ne_cbnrestab;
	WORD ne_segtab;
	WORD ne_rsrctab;
	WORD ne_restab;
	WORD ne_modtab;
	WORD ne_imptab;
	LONG ne_nrestab;
	WORD ne_cmovent;
	WORD ne_align;
	WORD ne_cres;
	BYTE ne_exetyp;
	BYTE ne_flagsothers;
	WORD ne_pretthunks;
	WORD ne_psegrefbytes;
	WORD ne_swaparea;
	WORD ne_expver;
}
alias IMAGE_OS2_HEADER* PIMAGE_OS2_HEADER;

align(4):
struct IMAGE_NT_HEADERS {
	DWORD Signature;
	IMAGE_FILE_HEADER FileHeader;
	IMAGE_OPTIONAL_HEADER OptionalHeader;
}
alias IMAGE_NT_HEADERS* PIMAGE_NT_HEADERS;

struct IMAGE_ROM_HEADERS {
	IMAGE_FILE_HEADER FileHeader;
	IMAGE_ROM_OPTIONAL_HEADER OptionalHeader;
}
alias IMAGE_ROM_HEADERS* PIMAGE_ROM_HEADERS;

struct IMAGE_SECTION_HEADER {
	BYTE Name[IMAGE_SIZEOF_SHORT_NAME];
	union Misc {
		DWORD PhysicalAddress;
		DWORD VirtualSize;
	}
	DWORD VirtualAddress;
	DWORD SizeOfRawData;
	DWORD PointerToRawData;
	DWORD PointerToRelocations;
	DWORD PointerToLinenumbers;
	WORD NumberOfRelocations;
	WORD NumberOfLinenumbers;
	DWORD Characteristics;
}
alias IMAGE_SECTION_HEADER *PIMAGE_SECTION_HEADER;

align(2):
struct IMAGE_SYMBOL {
	union N {
		BYTE ShortName[8];
		struct Name {
			DWORD Short;
			DWORD Long;
		}
		PBYTE LongName[2];
	}
	DWORD Value;
	SHORT SectionNumber;
	WORD Type;
	BYTE StorageClass;
	BYTE NumberOfAuxSymbols;
}
alias IMAGE_SYMBOL* PIMAGE_SYMBOL;

union IMAGE_AUX_SYMBOL {
	struct  Sym {
		DWORD TagIndex;
		union Misc {
			struct LnSz {
				WORD Linenumber;
				WORD Size;
			}
		DWORD TotalSize;
		}
		union FcnAry {
			struct Function {
				DWORD PointerToLinenumber;
				DWORD PointerToNextFunction;
			}
			struct Array {
				WORD Dimension[4];
			}
		}
		WORD TvIndex;
	}
	struct File {
		BYTE Name[IMAGE_SIZEOF_SYMBOL];
	}
	struct Section {
		DWORD Length;
		WORD NumberOfRelocations;
		WORD NumberOfLinenumbers;
		DWORD CheckSum;
		SHORT Number;
		BYTE Selection;
	}
}
alias IMAGE_AUX_SYMBOL* PIMAGE_AUX_SYMBOL;

struct IMAGE_COFF_SYMBOLS_HEADER {
	DWORD NumberOfSymbols;
	DWORD LvaToFirstSymbol;
	DWORD NumberOfLinenumbers;
	DWORD LvaToFirstLinenumber;
	DWORD RvaToFirstByteOfCode;
	DWORD RvaToLastByteOfCode;
	DWORD RvaToFirstByteOfData;
	DWORD RvaToLastByteOfData;
}
alias IMAGE_COFF_SYMBOLS_HEADER* PIMAGE_COFF_SYMBOLS_HEADER;

struct IMAGE_RELOCATION {
	union {
		DWORD VirtualAddress;
		DWORD RelocCount;
	}
	DWORD SymbolTableIndex;
	WORD Type;
}
alias IMAGE_RELOCATION* PIMAGE_RELOCATION;

align(4):
struct IMAGE_BASE_RELOCATION {
	DWORD VirtualAddress;
	DWORD SizeOfBlock;
}
alias IMAGE_BASE_RELOCATION* PIMAGE_BASE_RELOCATION;

align(2):
struct IMAGE_LINENUMBER {
	union Type {
		DWORD SymbolTableIndex;
		DWORD VirtualAddress;
	}
	WORD Linenumber;
}
alias IMAGE_LINENUMBER* PIMAGE_LINENUMBER;

align(4):
struct IMAGE_ARCHIVE_MEMBER_HEADER {
	BYTE Name[16];
	BYTE Date[12];
	BYTE UserID[6];
	BYTE GroupID[6];
	BYTE Mode[8];
	BYTE Size[10];
	BYTE EndHeader[2];
}
alias IMAGE_ARCHIVE_MEMBER_HEADER* PIMAGE_ARCHIVE_MEMBER_HEADER;

struct IMAGE_EXPORT_DIRECTORY {
	DWORD Characteristics;
	DWORD TimeDateStamp;
	WORD MajorVersion;
	WORD MinorVersion;
	DWORD Name;
	DWORD Base;
	DWORD NumberOfFunctions;
	DWORD NumberOfNames;
	DWORD AddressOfFunctions;
	DWORD AddressOfNames;
	DWORD AddressOfNameOrdinals;
}
alias IMAGE_EXPORT_DIRECTORY* PIMAGE_EXPORT_DIRECTORY;

struct IMAGE_IMPORT_BY_NAME {
	WORD Hint;
	BYTE Name[1];
}
alias IMAGE_IMPORT_BY_NAME* PIMAGE_IMPORT_BY_NAME;

struct IMAGE_THUNK_DATA32 {
	union u1 {
		DWORD ForwarderString;
		DWORD Function;
		DWORD Ordinal;
		DWORD AddressOfData;
	}
}
alias IMAGE_THUNK_DATA32* PIMAGE_THUNK_DATA32;

struct IMAGE_THUNK_DATA64 {
	union u1 {
		ULONGLONG ForwarderString;
		ULONGLONG Function;
		ULONGLONG Ordinal;
		ULONGLONG AddressOfData;
	}
}
alias IMAGE_THUNK_DATA64* PIMAGE_THUNK_DATA64;

version(Win64) {
	alias IMAGE_THUNK_DATA64  IMAGE_THUNK_DATA;
	alias PIMAGE_THUNK_DATA64 PIMAGE_THUNK_DATA;
} else {
	alias IMAGE_THUNK_DATA32  IMAGE_THUNK_DATA;
	alias PIMAGE_THUNK_DATA32 PIMAGE_THUNK_DATA;
}

struct IMAGE_IMPORT_DESCRIPTOR {
	union {
		DWORD Characteristics;
		DWORD OriginalFirstThunk;
	}
	DWORD TimeDateStamp;
	DWORD ForwarderChain;
	DWORD Name;
	DWORD FirstThunk;
}
alias IMAGE_IMPORT_DESCRIPTOR* PIMAGE_IMPORT_DESCRIPTOR;

struct IMAGE_BOUND_IMPORT_DESCRIPTOR {
	DWORD TimeDateStamp;
	WORD OffsetModuleName;
	WORD NumberOfModuleForwarderRefs;
}
alias IMAGE_BOUND_IMPORT_DESCRIPTOR* PIMAGE_BOUND_IMPORT_DESCRIPTOR;

struct IMAGE_BOUND_FORWARDER_REF {
	DWORD TimeDateStamp;
	WORD OffsetModuleName;
	WORD Reserved;
}
alias IMAGE_BOUND_FORWARDER_REF* PIMAGE_BOUND_FORWARDER_REF;

extern (Windows):
alias void function (PVOID,DWORD,PVOID)  PIMAGE_TLS_CALLBACK;

struct IMAGE_TLS_DIRECTORY32 {
	DWORD StartAddressOfRawData;
	DWORD EndAddressOfRawData;
	DWORD AddressOfIndex;
	DWORD AddressOfCallBacks;
	DWORD SizeOfZeroFill;
	DWORD Characteristics;
}
alias IMAGE_TLS_DIRECTORY32* PIMAGE_TLS_DIRECTORY32;

struct IMAGE_TLS_DIRECTORY64 {
	ULONGLONG StartAddressOfRawData;
	ULONGLONG EndAddressOfRawData;
	ULONGLONG AddressOfIndex;
	ULONGLONG AddressOfCallBacks;
	DWORD SizeOfZeroFill;
	DWORD Characteristics;
}
alias IMAGE_TLS_DIRECTORY64 *PIMAGE_TLS_DIRECTORY64;

version (Win64) {
	alias IMAGE_TLS_DIRECTORY64  IMAGE_TLS_DIRECTORY;
	alias PIMAGE_TLS_DIRECTORY64 PIMAGE_TLS_DIRECTORY;
} else {
	alias IMAGE_TLS_DIRECTORY32  IMAGE_TLS_DIRECTORY;
	alias PIMAGE_TLS_DIRECTORY32 PIMAGE_TLS_DIRECTORY;
}

struct IMAGE_RESOURCE_DIRECTORY {
	DWORD Characteristics;
	DWORD TimeDateStamp;
	WORD MajorVersion;
	WORD MinorVersion;
	WORD NumberOfNamedEntries;
	WORD NumberOfIdEntries;
} IMAGE_RESOURCE_DIRECTORY* PIMAGE_RESOURCE_DIRECTORY;

struct IMAGE_RESOURCE_DIRECTORY_ENTRY {
	union {
		struct {
//			DWORD NameOffset:31;
//			DWORD NameIsString:1;
		}
		DWORD Name;
		WORD Id;
	}
	union {
		DWORD OffsetToData;
		struct {
//			DWORD OffsetToDirectory:31;
//			DWORD DataIsDirectory:1;
		}
	}
}
alias IMAGE_RESOURCE_DIRECTORY_ENTRY* PIMAGE_RESOURCE_DIRECTORY_ENTRY;

struct IMAGE_RESOURCE_DIRECTORY_STRING {
	WORD Length;
	CHAR NameString[1];
}
alias IMAGE_RESOURCE_DIRECTORY_STRING* PIMAGE_RESOURCE_DIRECTORY_STRING;

struct IMAGE_RESOURCE_DIR_STRING_U {
	WORD Length;
	WCHAR NameString[1];
}
alias IMAGE_RESOURCE_DIR_STRING_U* PIMAGE_RESOURCE_DIR_STRING_U;

struct IMAGE_RESOURCE_DATA_ENTRY {
	DWORD OffsetToData;
	DWORD Size;
	DWORD CodePage;
	DWORD Reserved;
}
alias IMAGE_RESOURCE_DATA_ENTRY* PIMAGE_RESOURCE_DATA_ENTRY;

struct IMAGE_LOAD_CONFIG_DIRECTORY {
	DWORD Characteristics;
	DWORD TimeDateStamp;
	WORD MajorVersion;
	WORD MinorVersion;
	DWORD GlobalFlagsClear;
	DWORD GlobalFlagsSet;
	DWORD CriticalSectionDefaultTimeout;
	DWORD DeCommitFreeBlockThreshold;
	DWORD DeCommitTotalFreeThreshold;
	PVOID LockPrefixTable;
	DWORD MaximumAllocationSize;
	DWORD VirtualMemoryThreshold;
	DWORD ProcessHeapFlags;
	DWORD Reserved[4];
}
alias IMAGE_LOAD_CONFIG_DIRECTORY* PIMAGE_LOAD_CONFIG_DIRECTORY;

struct IMAGE_RUNTIME_FUNCTION_ENTRY {
	DWORD BeginAddress;
	DWORD EndAddress;
	PVOID ExceptionHandler;
	PVOID HandlerData;
	DWORD PrologEndAddress;
}
alias IMAGE_RUNTIME_FUNCTION_ENTRY* PIMAGE_RUNTIME_FUNCTION_ENTRY;

struct IMAGE_DEBUG_DIRECTORY {
	DWORD Characteristics;
	DWORD TimeDateStamp;
	WORD MajorVersion;
	WORD MinorVersion;
	DWORD Type;
	DWORD SizeOfData;
	DWORD AddressOfRawData;
	DWORD PointerToRawData;
}
alias IMAGE_DEBUG_DIRECTORY* PIMAGE_DEBUG_DIRECTORY;

struct FPO_DATA {
	DWORD ulOffStart;
	DWORD cbProcSize;
	DWORD cdwLocals;
	WORD cdwParams;
	WORD bitField_FixForD; // FIXME
/* FIXME
	WORD cbProlog:8;
	WORD cbRegs:3;
	WORD fHasSEH:1;
	WORD fUseBP:1;
	WORD reserved:1;
	WORD cbFrame:2;
*/
}
alias FPO_DATA* PFPO_DATA;

struct IMAGE_DEBUG_MISC {
	DWORD DataType;
	DWORD Length;
	BOOLEAN Unicode;
	BYTE Reserved[3];
	BYTE Data[1];
}
alias IMAGE_DEBUG_MISC* PIMAGE_DEBUG_MISC;

struct IMAGE_FUNCTION_ENTRY {
	DWORD StartingAddress;
	DWORD EndingAddress;
	DWORD EndOfPrologue;
}
alias IMAGE_FUNCTION_ENTRY* PIMAGE_FUNCTION_ENTRY;

struct IMAGE_SEPARATE_DEBUG_HEADER {
	WORD Signature;
	WORD Flags;
	WORD Machine;
	WORD Characteristics;
	DWORD TimeDateStamp;
	DWORD CheckSum;
	DWORD ImageBase;
	DWORD SizeOfImage;
	DWORD NumberOfSections;
	DWORD ExportedNamesSize;
	DWORD DebugDirectorySize;
	DWORD SectionAlignment;
	DWORD Reserved[2];
}
alias IMAGE_SEPARATE_DEBUG_HEADER* PIMAGE_SEPARATE_DEBUG_HEADER;

align:

enum SERVICE_NODE_TYPE {
	DriverType               = SERVICE_KERNEL_DRIVER,
	FileSystemType           = SERVICE_FILE_SYSTEM_DRIVER,
	Win32ServiceOwnProcess   = SERVICE_WIN32_OWN_PROCESS,
	Win32ServiceShareProcess = SERVICE_WIN32_SHARE_PROCESS,
	AdapterType              = SERVICE_ADAPTER,
	RecognizerType           = SERVICE_RECOGNIZER_DRIVER
}

enum SERVICE_LOAD_TYPE {
	BootLoad    = SERVICE_BOOT_START,
	SystemLoad  = SERVICE_SYSTEM_START,
	AutoLoad    = SERVICE_AUTO_START,
	DemandLoad  = SERVICE_DEMAND_START,
	DisableLoad = SERVICE_DISABLED
}

enum SERVICE_ERROR_TYPE {
	IgnoreError   = SERVICE_ERROR_IGNORE,
	NormalError   = SERVICE_ERROR_NORMAL,
	SevereError   = SERVICE_ERROR_SEVERE,
	CriticalError = SERVICE_ERROR_CRITICAL
}
alias SERVICE_ERROR_TYPE _CM_ERROR_CONTROL_TYPE;

//DAC: According to MSJ, 'UnderTheHood', May 1996, this
// structure is not documented in any official Microsoft header file.
alias void EXCEPTION_REGISTRATION_RECORD;

struct NT_TIB {
	EXCEPTION_REGISTRATION_RECORD *ExceptionList;
	PVOID StackBase;
	PVOID StackLimit;
	PVOID SubSystemTib;
	union {
		PVOID FiberData;
		DWORD Version;
	}
	PVOID ArbitraryUserPointer;
	NT_TIB *Self;
}
alias NT_TIB* PNT_TIB;

struct REPARSE_DATA_BUFFER {
	DWORD  ReparseTag;
	WORD   ReparseDataLength;
	WORD   Reserved;
	union u {
		struct GenericReparseBuffer {
			BYTE   DataBuffer[1];
		}
		struct SymbolicLinkReparseBuffer {
			WORD   SubstituteNameOffset;
			WORD   SubstituteNameLength;
			WORD   PrintNameOffset;
			WORD   PrintNameLength;
			WCHAR PathBuffer[1];
		}
		struct MountPointReparseBuffer {
			WORD   SubstituteNameOffset;
			WORD   SubstituteNameLength;
			WORD   PrintNameOffset;
			WORD   PrintNameLength;
			WCHAR PathBuffer[1];
		}
	}
}
alias REPARSE_DATA_BUFFER *PREPARSE_DATA_BUFFER;

struct REPARSE_GUID_DATA_BUFFER {
	DWORD  ReparseTag;
	WORD   ReparseDataLength;
	WORD   Reserved;
	GUID   ReparseGuid;
	struct GenericReparseBuffer {
		BYTE DataBuffer[1];
	}
}
alias REPARSE_GUID_DATA_BUFFER* PREPARSE_GUID_DATA_BUFFER;

const REPARSE_DATA_BUFFER_HEADER_SIZE = REPARSE_DATA_BUFFER.u.GenericReparseBuffer.DataBuffer.offsetof;
const size_t REPARSE_GUID_DATA_BUFFER_HEADER_SIZE = REPARSE_GUID_DATA_BUFFER.GenericReparseBuffer.DataBuffer.offsetof;
const MAXIMUM_REPARSE_DATA_BUFFER_SIZE = 16384;


struct REPARSE_POINT_INFORMATION {
	WORD   ReparseDataLength;
	WORD   UnparsedNameLength;
}
alias REPARSE_POINT_INFORMATION* PREPARSE_POINT_INFORMATION;

union FILE_SEGMENT_ELEMENT {
	PVOID64 Buffer;
	ULONGLONG Alignment;
}
alias FILE_SEGMENT_ELEMENT* PFILE_SEGMENT_ELEMENT;

// JOBOBJECT_BASIC_LIMIT_INFORMATION.LimitFlags constants
const JOB_OBJECT_LIMIT_WORKINGSET=0x0001;
const JOB_OBJECT_LIMIT_PROCESS_TIME=0x0002;
const JOB_OBJECT_LIMIT_JOB_TIME=0x0004;
const JOB_OBJECT_LIMIT_ACTIVE_PROCESS=0x0008;
const JOB_OBJECT_LIMIT_AFFINITY=0x0010;
const JOB_OBJECT_LIMIT_PRIORITY_CLASS=0x0020;
const JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME=0x0040;
const JOB_OBJECT_LIMIT_SCHEDULING_CLASS=0x0080;
const JOB_OBJECT_LIMIT_PROCESS_MEMORY=0x0100;
const JOB_OBJECT_LIMIT_JOB_MEMORY=0x0200;
const JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION=0x0400;
const JOB_OBJECT_BREAKAWAY_OK=0x0800;
const JOB_OBJECT_SILENT_BREAKAWAY=0x1000;

// JOBOBJECT_BASIC_UI_RESTRICTIONS.UIRestrictionsClass constants
const JOB_OBJECT_UILIMIT_HANDLES=0x0001;
const JOB_OBJECT_UILIMIT_READCLIPBOARD=0x0002;
const JOB_OBJECT_UILIMIT_WRITECLIPBOARD=0x0004;
const JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS=0x0008;
const JOB_OBJECT_UILIMIT_DISPLAYSETTINGS=0x0010;
const JOB_OBJECT_UILIMIT_GLOBALATOMS=0x0020;
const JOB_OBJECT_UILIMIT_DESKTOP=0x0040;
const JOB_OBJECT_UILIMIT_EXITWINDOWS=0x0080;

// JOBOBJECT_SECURITY_LIMIT_INFORMATION.SecurityLimitFlags constants
const JOB_OBJECT_SECURITY_NO_ADMIN=0x0001;
const JOB_OBJECT_SECURITY_RESTRICTED_TOKEN=0x0002;
const JOB_OBJECT_SECURITY_ONLY_TOKEN=0x0004;
const JOB_OBJECT_SECURITY_FILTER_TOKENS=0x0008;

// JOBOBJECT_END_OF_JOB_TIME_INFORMATION.EndOfJobTimeAction constants
const JOB_OBJECT_TERMINATE_AT_END_OF_JOB=0;
const JOB_OBJECT_POST_AT_END_OF_JOB=1;

const JOB_OBJECT_MSG_END_OF_JOB_TIME=1;
const JOB_OBJECT_MSG_END_OF_PROCESS_TIME=2;
const JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT=3;
const JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO=4;
const JOB_OBJECT_MSG_NEW_PROCESS=6;
const JOB_OBJECT_MSG_EXIT_PROCESS=7;
const JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS=8;
const JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT=9;
const JOB_OBJECT_MSG_JOB_MEMORY_LIMIT=10;

enum JOBOBJECTINFOCLASS {
	JobObjectBasicAccountingInformation = 1,
	JobObjectBasicLimitInformation,
	JobObjectBasicProcessIdList,
	JobObjectBasicUIRestrictions,
	JobObjectSecurityLimitInformation,
	JobObjectEndOfJobTimeInformation,
	JobObjectAssociateCompletionPortInformation,
	JobObjectBasicAndIoAccountingInformation,
	JobObjectExtendedLimitInformation,
	JobObjectJobSetInformation,
	MaxJobObjectInfoClass
}

struct JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
	LARGE_INTEGER TotalUserTime;
	LARGE_INTEGER TotalKernelTime;
	LARGE_INTEGER ThisPeriodTotalUserTime;
	LARGE_INTEGER ThisPeriodTotalKernelTime;
	DWORD TotalPageFaultCount;
	DWORD TotalProcesses;
	DWORD ActiveProcesses;
	DWORD TotalTerminatedProcesses;
}
alias JOBOBJECT_BASIC_ACCOUNTING_INFORMATION* PJOBOBJECT_BASIC_ACCOUNTING_INFORMATION;
struct JOBOBJECT_BASIC_LIMIT_INFORMATION {
	LARGE_INTEGER PerProcessUserTimeLimit;
	LARGE_INTEGER PerJobUserTimeLimit;
	DWORD LimitFlags;
	SIZE_T MinimumWorkingSetSize;
	SIZE_T MaximumWorkingSetSize;
	DWORD ActiveProcessLimit;
	ULONG_PTR Affinity;
	DWORD PriorityClass;
	DWORD SchedulingClass;
}
alias JOBOBJECT_BASIC_LIMIT_INFORMATION* PJOBOBJECT_BASIC_LIMIT_INFORMATION;

struct JOBOBJECT_BASIC_PROCESS_ID_LIST {
	DWORD NumberOfAssignedProcesses;
	DWORD NumberOfProcessIdsInList;
	ULONG_PTR ProcessIdList[1];
}
alias JOBOBJECT_BASIC_PROCESS_ID_LIST *PJOBOBJECT_BASIC_PROCESS_ID_LIST;

struct JOBOBJECT_BASIC_UI_RESTRICTIONS {
	DWORD UIRestrictionsClass;
}
alias JOBOBJECT_BASIC_UI_RESTRICTIONS *PJOBOBJECT_BASIC_UI_RESTRICTIONS;

struct JOBOBJECT_SECURITY_LIMIT_INFORMATION {
	DWORD SecurityLimitFlags;
	HANDLE JobToken;
	PTOKEN_GROUPS SidsToDisable;
	PTOKEN_PRIVILEGES PrivilegesToDelete;
	PTOKEN_GROUPS RestrictedSids;
}
alias JOBOBJECT_SECURITY_LIMIT_INFORMATION* PJOBOBJECT_SECURITY_LIMIT_INFORMATION;

struct JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
	DWORD EndOfJobTimeAction;
}
alias JOBOBJECT_END_OF_JOB_TIME_INFORMATION* PJOBOBJECT_END_OF_JOB_TIME_INFORMATION;

struct JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
	PVOID CompletionKey;
	HANDLE CompletionPort;
}
alias JOBOBJECT_ASSOCIATE_COMPLETION_PORT* PJOBOBJECT_ASSOCIATE_COMPLETION_PORT;

struct JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
	JOBOBJECT_BASIC_ACCOUNTING_INFORMATION BasicInfo;
	IO_COUNTERS IoInfo;
}
alias JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION *PJOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION;

struct JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
	JOBOBJECT_BASIC_LIMIT_INFORMATION BasicLimitInformation;
	IO_COUNTERS IoInfo;
	SIZE_T ProcessMemoryLimit;
	SIZE_T JobMemoryLimit;
	SIZE_T PeakProcessMemoryUsed;
	SIZE_T PeakJobMemoryUsed;
}
alias JOBOBJECT_EXTENDED_LIMIT_INFORMATION* PJOBOBJECT_EXTENDED_LIMIT_INFORMATION;

struct JOBOBJECT_JOBSET_INFORMATION {
	DWORD MemberLevel;
}
alias JOBOBJECT_JOBSET_INFORMATION* PJOBOBJECT_JOBSET_INFORMATION;

/* MinGW: Making these defines conditional on WINVER will break ddk includes */
//static if (WINVER >= 0x0500) {

align(4):

const ES_SYSTEM_REQUIRED=0x00000001;
const ES_DISPLAY_REQUIRED=0x00000002;
const ES_USER_PRESENT=0x00000004;
const ES_CONTINUOUS=0x80000000;

enum LATENCY_TIME {
	LT_DONT_CARE,
	LT_LOWEST_LATENCY
}
alias LATENCY_TIME* PLATENCY_TIME;

enum SYSTEM_POWER_STATE {
	PowerSystemUnspecified,
	PowerSystemWorking,
	PowerSystemSleeping1,
	PowerSystemSleeping2,
	PowerSystemSleeping3,
	PowerSystemHibernate,
	PowerSystemShutdown,
	PowerSystemMaximum
}
alias SYSTEM_POWER_STATE* PSYSTEM_POWER_STATE;

const POWER_SYSTEM_MAXIMUM = SYSTEM_POWER_STATE.PowerSystemMaximum;

enum POWER_ACTION {
PowerActionNone,
PowerActionReserved,
PowerActionSleep,
PowerActionHibernate,
PowerActionShutdown,
PowerActionShutdownReset,
PowerActionShutdownOff,
PowerActionWarmEject
}
alias POWER_ACTION* PPOWER_ACTION;

enum DEVICE_POWER_STATE {
	PowerDeviceUnspecified,
	PowerDeviceD0,
	PowerDeviceD1,
	PowerDeviceD2,
	PowerDeviceD3,
	PowerDeviceMaximum
}
alias DEVICE_POWER_STATE* PDEVICE_POWER_STATE;

struct BATTERY_REPORTING_SCALE {
	DWORD  Granularity;
	DWORD  Capacity;
}
alias BATTERY_REPORTING_SCALE* PBATTERY_REPORTING_SCALE;

struct POWER_ACTION_POLICY {
	POWER_ACTION  Action;
	ULONG  Flags;
	ULONG  EventCode;
}
alias POWER_ACTION_POLICY *PPOWER_ACTION_POLICY;

/* POWER_ACTION_POLICY.Flags constants */
const POWER_ACTION_QUERY_ALLOWED  = 0x00000001;
const POWER_ACTION_UI_ALLOWED     = 0x00000002;
const POWER_ACTION_OVERRIDE_APPS  = 0x00000004;
const POWER_ACTION_LIGHTEST_FIRST = 0x10000000;
const POWER_ACTION_LOCK_CONSOLE   = 0x20000000;
const POWER_ACTION_DISABLE_WAKES  = 0x40000000;
const POWER_ACTION_CRITICAL       = 0x80000000;

/* POWER_ACTION_POLICY.EventCode constants */
const POWER_LEVEL_USER_NOTIFY_TEXT  = 0x00000001;
const POWER_LEVEL_USER_NOTIFY_SOUND = 0x00000002;
const POWER_LEVEL_USER_NOTIFY_EXEC  = 0x00000004;
const POWER_USER_NOTIFY_BUTTON      = 0x00000008;
const POWER_USER_NOTIFY_SHUTDOWN    = 0x00000010;
const POWER_FORCE_TRIGGER_RESET     = 0x80000000;

const DISCHARGE_POLICY_CRITICAL=0;
const DISCHARGE_POLICY_LOW=1;
const NUM_DISCHARGE_POLICIES=4;

const PO_THROTTLE_NONE=0;
const PO_THROTTLE_CONSTANT=1;
const PO_THROTTLE_DEGRADE=2;
const PO_THROTTLE_ADAPTIVE=3;
const PO_THROTTLE_MAXIMUM=4;

struct SYSTEM_POWER_LEVEL {
	BOOLEAN  Enable;
	UCHAR  Spare[3];
	ULONG  BatteryLevel;
	POWER_ACTION_POLICY  PowerPolicy;
	SYSTEM_POWER_STATE  MinSystemState;
}
alias SYSTEM_POWER_LEVEL* PSYSTEM_POWER_LEVEL;

struct SYSTEM_POWER_POLICY {
	ULONG  Revision;
	POWER_ACTION_POLICY  PowerButton;
	POWER_ACTION_POLICY  SleepButton;
	POWER_ACTION_POLICY  LidClose;
	SYSTEM_POWER_STATE  LidOpenWake;
	ULONG  Reserved;
	POWER_ACTION_POLICY  Idle;
	ULONG  IdleTimeout;
	UCHAR  IdleSensitivity;
	UCHAR  DynamicThrottle;
	UCHAR  Spare2[2];
	SYSTEM_POWER_STATE  MinSleep;
	SYSTEM_POWER_STATE  MaxSleep;
	SYSTEM_POWER_STATE  ReducedLatencySleep;
	ULONG  WinLogonFlags;
	ULONG  Spare3;
	ULONG  DozeS4Timeout;
	ULONG  BroadcastCapacityResolution;
	SYSTEM_POWER_LEVEL  DischargePolicy[NUM_DISCHARGE_POLICIES];
	ULONG  VideoTimeout;
	BOOLEAN  VideoDimDisplay;
	ULONG  VideoReserved[3];
	ULONG  SpindownTimeout;
	BOOLEAN  OptimizeForPower;
	UCHAR  FanThrottleTolerance;
	UCHAR  ForcedThrottle;
	UCHAR  MinThrottle;
	POWER_ACTION_POLICY  OverThrottled;
}
alias SYSTEM_POWER_POLICY* PSYSTEM_POWER_POLICY;

struct SYSTEM_POWER_CAPABILITIES {
	BOOLEAN  PowerButtonPresent;
	BOOLEAN  SleepButtonPresent;
	BOOLEAN  LidPresent;
	BOOLEAN  SystemS1;
	BOOLEAN  SystemS2;
	BOOLEAN  SystemS3;
	BOOLEAN  SystemS4;
	BOOLEAN  SystemS5;
	BOOLEAN  HiberFilePresent;
	BOOLEAN  FullWake;
	BOOLEAN  VideoDimPresent;
	BOOLEAN  ApmPresent;
	BOOLEAN  UpsPresent;
	BOOLEAN  ThermalControl;
	BOOLEAN  ProcessorThrottle;
	UCHAR  ProcessorMinThrottle;
	UCHAR  ProcessorMaxThrottle;
	UCHAR  spare2[4];
	BOOLEAN  DiskSpinDown;
	UCHAR  spare3[8];
	BOOLEAN  SystemBatteriesPresent;
	BOOLEAN  BatteriesAreShortTerm;
	BATTERY_REPORTING_SCALE  BatteryScale[3];
	SYSTEM_POWER_STATE  AcOnLineWake;
	SYSTEM_POWER_STATE  SoftLidWake;
	SYSTEM_POWER_STATE  RtcWake;
	SYSTEM_POWER_STATE  MinDeviceWakeState;
	SYSTEM_POWER_STATE  DefaultLowLatencyWake;
}
alias SYSTEM_POWER_CAPABILITIES* PSYSTEM_POWER_CAPABILITIES;

struct SYSTEM_BATTERY_STATE {
	BOOLEAN  AcOnLine;
	BOOLEAN  BatteryPresent;
	BOOLEAN  Charging;
	BOOLEAN  Discharging;
	BOOLEAN  Spare1[4];
	ULONG  MaxCapacity;
	ULONG  RemainingCapacity;
	ULONG  Rate;
	ULONG  EstimatedTime;
	ULONG  DefaultAlert1;
	ULONG  DefaultAlert2;
}
alias SYSTEM_BATTERY_STATE* PSYSTEM_BATTERY_STATE;

enum POWER_INFORMATION_LEVEL {
	SystemPowerPolicyAc,
	SystemPowerPolicyDc,
	VerifySystemPolicyAc,
	VerifySystemPolicyDc,
	SystemPowerCapabilities,
	SystemBatteryState,
	SystemPowerStateHandler,
	ProcessorStateHandler,
	SystemPowerPolicyCurrent,
	AdministratorPowerPolicy,
	SystemReserveHiberFile,
	ProcessorInformation,
	SystemPowerInformation,
	ProcessorStateHandler2,
	LastWakeTime,
	LastSleepTime,
	SystemExecutionState,
	SystemPowerStateNotifyHandler,
	ProcessorPowerPolicyAc,
	ProcessorPowerPolicyDc,
	VerifyProcessorPowerPolicyAc,
	VerifyProcessorPowerPolicyDc,
	ProcessorPowerPolicyCurrent
}

static if (_WIN32_WINNT >= 0x0500) {
	alias LONG function (PEXCEPTION_POINTERS)  PVECTORED_EXCEPTION_HANDLER;
}
//#if 1 /* (WIN32_WINNT >= 0x0500) */
struct SYSTEM_POWER_INFORMATION {
	ULONG  MaxIdlenessAllowed;
	ULONG  Idleness;
	ULONG  TimeRemaining;
	UCHAR  CoolingMode;
}
alias SYSTEM_POWER_INFORMATION* PSYSTEM_POWER_INFORMATION;
//#endif

static if (_WIN32_WINNT >= 0x0501) {

	enum HEAP_INFORMATION_CLASS {
		HeapCompatibilityInformation
	}

	enum ACTIVATION_CONTEXT_INFO_CLASS {
		ActivationContextBasicInformation = 1,
		ActivationContextDetailedInformation,
		AssemblyDetailedInformationInActivationContext,
		FileInformationInAssemblyOfAssemblyInActivationContext
	}

	struct ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION {
		DWORD ulFlags;
		DWORD ulEncodedAssemblyIdentityLength;
		DWORD ulManifestPathType;
		DWORD ulManifestPathLength;
		LARGE_INTEGER liManifestLastWriteTime;
		DWORD ulPolicyPathType;
		DWORD ulPolicyPathLength;
		LARGE_INTEGER liPolicyLastWriteTime;
		DWORD ulMetadataSatelliteRosterIndex;
		DWORD ulManifestVersionMajor;
		DWORD ulManifestVersionMinor;
		DWORD ulPolicyVersionMajor;
		DWORD ulPolicyVersionMinor;
		DWORD ulAssemblyDirectoryNameLength;
		PCWSTR lpAssemblyEncodedAssemblyIdentity;
		PCWSTR lpAssemblyManifestPath;
		PCWSTR lpAssemblyPolicyPath;
		PCWSTR lpAssemblyDirectoryName;
	}
	alias ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION *
		PACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION,
		PCACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION;

	struct ACTIVATION_CONTEXT_DETAILED_INFORMATION {
		DWORD dwFlags;
		DWORD ulFormatVersion;
		DWORD ulAssemblyCount;
		DWORD ulRootManifestPathType;
		DWORD ulRootManifestPathChars;
		DWORD ulRootConfigurationPathType;
		DWORD ulRootConfigurationPathChars;
		DWORD ulAppDirPathType;
		DWORD ulAppDirPathChars;
		PCWSTR lpRootManifestPath;
		PCWSTR lpRootConfigurationPath;
		PCWSTR lpAppDirPath;
	}
	alias ACTIVATION_CONTEXT_DETAILED_INFORMATION *
		PACTIVATION_CONTEXT_DETAILED_INFORMATION,
		PCACTIVATION_CONTEXT_DETAILED_INFORMATION;

	struct ACTIVATION_CONTEXT_QUERY_INDEX {
		ULONG ulAssemblyIndex;
		ULONG ulFileIndexInAssembly;
	}
	alias ACTIVATION_CONTEXT_QUERY_INDEX *
		PACTIVATION_CONTEXT_QUERY_INDEX,
		PCACTIVATION_CONTEXT_QUERY_INDEX;

	struct ASSEMBLY_FILE_DETAILED_INFORMATION {
		DWORD ulFlags;
		DWORD ulFilenameLength;
		DWORD ulPathLength;
		PCWSTR lpFileName;
		PCWSTR lpFilePath;
	}
	alias ASSEMBLY_FILE_DETAILED_INFORMATION *
		PASSEMBLY_FILE_DETAILED_INFORMATION,
		PCASSEMBLY_FILE_DETAILED_INFORMATION;

}// #endif /* (WIN32_WINNT >= 0x0501) */

struct PROCESSOR_POWER_POLICY_INFO {
	ULONG  TimeCheck;
	ULONG  DemoteLimit;
	ULONG  PromoteLimit;
	UCHAR  DemotePercent;
	UCHAR  PromotePercent;
	UCHAR  Spare[2];


	ULONG replace_for_D; // FIXME
/*
	ULONG  AllowDemotion : 1;
	ULONG  AllowPromotion : 1;
	ULONG  Reserved : 30;
*/
}
alias PROCESSOR_POWER_POLICY_INFO *PPROCESSOR_POWER_POLICY_INFO;

struct PROCESSOR_POWER_POLICY {
	ULONG  Revision;
	UCHAR  DynamicThrottle;
	UCHAR  Spare[3];
	ULONG  Reserved;
	ULONG  PolicyCount;
	PROCESSOR_POWER_POLICY_INFO  Policy[3];
}
alias PROCESSOR_POWER_POLICY* PPROCESSOR_POWER_POLICY;

struct ADMINISTRATOR_POWER_POLICY {
	SYSTEM_POWER_STATE  MinSleep;
	SYSTEM_POWER_STATE  MaxSleep;
	ULONG  MinVideoTimeout;
	ULONG  MaxVideoTimeout;
	ULONG  MinSpindownTimeout;
	ULONG  MaxSpindownTimeout;
}
alias ADMINISTRATOR_POWER_POLICY* PADMINISTRATOR_POWER_POLICY;

//}//#endif /* WINVER >= 0x0500 */

static if (_WIN32_WINNT >= 0x0500) {
	alias void function (PVOID, BOOLEAN) WAITORTIMERCALLBACKFUNC;
}

version(Unicode) {
	alias OSVERSIONINFOW OSVERSIONINFO;
	alias OSVERSIONINFOEXW OSVERSIONINFOEX;
} else {
	alias OSVERSIONINFOA OSVERSIONINFO;
	alias OSVERSIONINFOEXA OSVERSIONINFOEX;
}

alias OSVERSIONINFO*   POSVERSIONINFO,   LPOSVERSIONINFO;
alias OSVERSIONINFOEX* POSVERSIONINFOEX, LPOSVERSIONINFOEX;


static if (_WIN32_WINNT >= 0x0500) {
	ULONGLONG VerSetConditionMask(ULONGLONG,DWORD,BYTE);
}

//TODO: These are actually macros, and were introduced with Win98.
PVOID GetCurrentFiber();
PVOID GetFiberData();
