﻿module sample;

/// PEG解析器。中身はまだ秘密。
import outland.ctfe.peg.all;

/// PEG文法。これを元にPEGパーサをコンパイル時に作っちまうぜ！
const string PEG_SOURCE = `
NO_SKIP utf8Bom = "\xEF\xBB\xBF";

NO_SKIP NEW_LINE newLine = ("\r" "\n"?) / "\n";

NO_SKIP lineComment = "//" (!newLine .)* newLine;

NO_SKIP blockCommentChar = newLine / .;
NO_SKIP blockComment = "/*" (!"*/" blockCommentChar)* "*/";
NO_SKIP nestCommentContent = nestComment / (!"+/" blockCommentChar);
NO_SKIP nestComment = "/+" nestCommentContent* "+/";

NO_SKIP blankChars = " "+ / "\t"+ / "\v"+ / newLine+;
NO_SKIP SKIPPER spaces = (blankChars / lineComment / nestComment / blockComment)*;

NO_SKIP identifierHead = ['a' .. 'z'] / ['A' .. 'Z'] / "_";
NO_SKIP identifierTail = identifierHead / ['0' .. '9'];
NO_SKIP identifierStr = identifierHead identifierTail*;
TEXT_NODE identifier = identifierStr;

NO_SKIP octDigit = ['0' .. '8'];

NO_SKIP hexDigit = ['0' .. '9'] / ['a' .. 'f'] / ['A' .. 'F'];
    
NO_SKIP escHex = ("x"/"X") hexDigit hexDigit?;
NO_SKIP escOct = octDigit octDigit? octDigit?;
NO_SKIP escGroup = "\'" / "\"" / "?" / "\\" / "a" / "b" / "f" / "n" / "r" / "t" / "v" / escHex / escOct;
NO_SKIP escChar = "\\" (escGroup / E{UNKNOWN_ESC});

NO_SKIP normalChar = !"\"" .;
NO_SKIP literalStr = "\"" (escChar / normalChar)* "\"";
TEXT_NODE literal = literalStr;

NO_SKIP normalRangeChar = !"\'" .;
NO_SKIP rangeCharValue = "\'" (escChar / normalRangeChar) "\'";
TEXT_NODE rangeChar = rangeCharValue;
MAKE_NODE rangeExp = "[" rangeChar ".." rangeChar "]";

MAKE_NODE any = ".";

MAKE_NODE errorExp = "E{" identifier "}";

primaryExp = errorExp / identifier / literal / any / rangeExp / ("(" pegExp ")");

MAKE_NODE ALWAYS zeroOrMoreExp = "*";
MAKE_NODE ALWAYS oneOrMoreExp = "+";
MAKE_NODE ALWAYS optionExp = "?";

repeatExp = primaryExp (zeroOrMoreExp / oneOrMoreExp / optionExp)?;

MAKE_NODE ALWAYS andExp = "&";
MAKE_NODE ALWAYS notExp = "!";

testExp = (andExp / notExp)? repeatExp;

MAKE_NODE sequenceExp = testExp+;

MAKE_NODE choiceExp = sequenceExp ("/" sequenceExp)*;

pegExp = choiceExp;

MAKE_NODE ALWAYS declareSkipper = "SKIPPER";
MAKE_NODE ALWAYS declareNoSkip = "NO_SKIP";
MAKE_NODE ALWAYS declareNewLine = "NEW_LINE";
MAKE_NODE ALWAYS declareMakeNode = "MAKE_NODE";
MAKE_NODE ALWAYS declareTextNode = "TEXT_NODE";
MAKE_NODE ALWAYS declareAlways = "ALWAYS";

declareProperty = declareSkipper / declareNoSkip / declareNewLine / declareMakeNode / declareTextNode / declareAlways;

MAKE_NODE ALWAYS declareParser = declareProperty* identifier;

MAKE_NODE ALWAYS defineParser = declareParser "=" pegExp ";";

MAKE_NODE ALWAYS pegRoot = utf8Bom? defineParser+;
`;

// PEG文法ファイルからパーサを生成。
mixin(compilePegParser(PEG_SOURCE));

unittest {
    // 生成されたパーサで自分自身を解析してみる。《コンパイル時に》ASTが表示される。
    pragma(msg, dumpNode(pegRoot(PEG_SOURCE, 0).nodes[0]));
}
