﻿/**
 *	デバイスコンテキスト。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.dc;

import win32.windows;
import outland.dmajor.exception;
import outland.dmajor.handle;

/// デバイスコンテキスト。
class DeviceContext : HandleWrapper!(HDC) {
	
	/// DC破棄関数。
	alias void delegate(HDC) Destructor;
	
	/// DCをオブジェクトでラップして処理する。
	static void duringObject(HDC hdc, void delegate(DeviceContext) dg) {
		scope dc = new DeviceContext(hdc, null);
		dg(dc);
	}
	
	/// コンストラクタ。
	this(HDC dc, Destructor dtor) {super(dc, dtor);}
}
