﻿/**
 *	ダイアログ関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.dialog;

import win32.windows;

import outland.dmajor.application;
import outland.dmajor.exception;
import outland.dmajor.window;

/// ダイアログの基本クラス。
class Dialog : ParentWindow {
	
	/// ダイアログリソースを指定してモーダレスダイアログを生成する。
	static Dialog create(UINT id, Window parent = null) {return create(MAKEINTRESOURCE(id), parent);}
	
	/// ditto
	static Dialog create(LPCTSTR resource, Window parent = null) {
		auto dlg = new Dialog();
		auto inst = (parent) ? parent.getInstanceHandle : Application.instance.handle;
		dlg.createDialog(inst, resource, parent ? parent.handle : cast(HWND) null);
		return dlg;
	}
	
	/// ditto
	static Dialog create(LPCDLGTEMPLATE resource, Window parent = null) {
		auto dlg = new Dialog();
		auto inst = (parent) ? parent.getInstanceHandle : Application.instance.handle;
		dlg.createDialog(inst, resource, parent ? parent.handle : cast(HWND) null);
		return dlg;
	}
	
	/// モーダルダイアログを実行する。
	static INT_PTR doModel(LPCTSTR resource, Window parent = null) {
		auto dlg = new Dialog();
		auto inst = (parent) ? parent.getInstanceHandle : Application.instance.handle;
		return dlg.doModalDialog(inst, resource, parent ? parent.handle : cast(HWND) null);
	}
	
	/// ditto
	static INT_PTR doModel(LPCDLGTEMPLATE resource, Window parent = null) {
		auto dlg = new Dialog();
		auto inst = (parent) ? parent.getInstanceHandle : Application.instance.handle;
		return dlg.doModalDialog(inst, resource, parent ? parent.handle : cast(HWND) null);
	}
	
protected:
	
	/// ダイアログ生成。
	void createDialog(HINSTANCE inst, LPCTSTR resource, HWND parent) {
		duringCreateHook({
			checkApi(CreateDialog(inst, resource, parent, &dialogProcedure));
		});
	}
	
	/// ditto
	void createDialog(HINSTANCE inst, LPCDLGTEMPLATE resource, HWND parent) {
		duringCreateHook({
			checkApi(CreateDialogIndirect(inst, resource, parent, &dialogProcedure));
		});
	}
	
	/// モーダルダイアログ生成。
	INT_PTR doModalDialog(HINSTANCE inst, LPCTSTR resource, HWND parent) {
		INT_PTR result;
		duringCreateHook({
			result = DialogBox(inst, resource, parent, &dialogProcedure);
		});
		return result;
	}
	
	/// ditto
	INT_PTR doModalDialog(HINSTANCE inst, LPCDLGTEMPLATE resource, HWND parent) {
		INT_PTR result;
		duringCreateHook({
			result = DialogBoxIndirect(inst, resource, parent, &dialogProcedure);
		});
		return result;
	}
	
private:
	
	/// ダイアログプロシージャ。
	extern(Windows) static BOOL dialogProcedure(HWND wnd, UINT msg, WPARAM wp, LPARAM lp) {return FALSE;}
}
