﻿/**
 *	フレームクラス。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.frame;

import win32.windows;
import outland.dmajor.application;
import outland.dmajor.dc;
import outland.dmajor.exception;
import outland.dmajor.handle;
import outland.dmajor.menu;
import outland.dmajor.shape;
import outland.dmajor.threadlocal;
import outland.dmajor.tstring;
import outland.dmajor.trace;
import outland.dmajor.window;

/** フレームクラス。
 *
 *	メインフレームとなるクラス。
 */
class Frame : ParentWindow {
	
	/// デフォルトのウィンドウスタイル。
	const DWORD STYLE = WS_VISIBLE | WS_OVERLAPPEDWINDOW;
	
	/// デフォルトの拡張ウィンドウスタイル。
	const DWORD STYLE_EX = WS_EX_APPWINDOW | WS_EX_OVERLAPPEDWINDOW;
	
	/// デフォルトのクラススタイル。
	const DWORD CLASS_STYLE = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
	
	/// デフォルトの背景ブラシ。
	const HBRUSH BACK_BRUSH = cast(HBRUSH) COLOR_WINDOW + 1;
	
	/// デフォルトのアイコン。
	const UINT APP_ICON = IDI_APPLICATION;
	
	/// デフォルトのカーソル。
	const UINT APP_CURSOR = IDC_ARROW;
	
	/// ウィンドウを生成する。
	static Frame create(char[] title,
						Rect r,
						HICON icon = null,
						Menu menu = null,
						DWORD style = STYLE,
						DWORD styleEx = STYLE_EX,
						HICON sicon = null,
						DWORD clsStyle = CLASS_STYLE,
						HCURSOR cursor = null,
						HBRUSH back = null) {
		auto f = new Frame();
		f.createWindow(title, r, icon, menu, style, styleEx, sicon, clsStyle, cursor, back);
		return f;
	}
	
protected:
	
	/// ウィンドウを生成する。
	void createWindow(char[] title,
					  Rect r,
					  HICON icon = null,
					  Menu menu = null,
					  DWORD style = STYLE,
					  DWORD styleEx = STYLE_EX,
					  HICON sicon = null,
					  DWORD clsStyle = CLASS_STYLE,
					  HCURSOR cursor = null,
					  HBRUSH back = null) {
		// 引数がnullの場合はデフォルト設定。
		if(!icon) {
			icon = LoadIcon(cast(HINSTANCE) null, MAKEINTRESOURCE(APP_ICON));
		}

		if(!sicon) {
			sicon = icon;
		}
					  	
		if(!cursor) {
			cursor = LoadCursor(cast(HINSTANCE) null, MAKEINTRESOURCE(APP_CURSOR));
		}
					  	
		if(!back) {
			back = BACK_BRUSH;
		}
		HMENU m = (menu) ? menu.handle() : null;
		
		// ウィンドウクラス生成。
		auto cls = MAKEINTRESOURCE(WindowClassDatabase.instance.register(CLASS_STYLE, icon, sicon, cursor, BACK_BRUSH, null));
		
		// ウィンドウ生成。
		super.createWindow(cls, title, style, styleEx, r, cast(HWND) null, m, Application.instance.handle, null);
	}
}
