﻿/**
 *	スクロールバー関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.dmajor.scrollbar;

import std.bind;

import win32.windows;

import outland.dmajor.application;
import outland.dmajor.shape;
import outland.dmajor.window;

/// スクロールバーコントロール。
class ScrollBar : Window {
	
	/// ウィンドウクラス名。
	const TCHAR[] WINDOW_CLASS = "SCROLLBAR";
	
	/// デフォルトの拡張スタイル。
	const DWORD STYLE_EX = 0;
	
	/// エディットボックスを生成する。
	static ScrollBar create(Rect r, Window parent, uint id, DWORD style, DWORD styleEx = STYLE_EX) {
		auto s = new ScrollBar();
		s.createWindow(r, parent, id, style, styleEx);
		return s;
	}
	
	/// サブクラス化する。
	static ScrollBar subclassWindow(HWND wnd) {
		auto s = new ScrollBar();
		s.subclass(wnd);
		return s;
	}
	
public:
	
	/// スクロールの操作。
	mixin ScrollMixture!(SB_CTL) scroll;
	
protected:
	
	/// ウィンドウ生成。
	void createWindow(Rect r, Window parent, uint id, DWORD style, DWORD styleEx) {
		auto inst = (parent) ? parent.getInstanceHandle() : Application.instance.handle;
		super.createWindow(
			WINDOW_CLASS.ptr,
			"",
			style | WS_CHILD,
			styleEx,
			r,
			parent ? parent.handle : cast(HWND) null,
			cast(HMENU) id,
			inst,
			null);
	}
}
