﻿/**
 *	文字列変換関数。
 *
 *	Version:
 *		$Revision: 1.1 $
 *	Date:
 *		$Date: 2006/12/09 16:06:42 $
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log: tstring.d,v $
 *		Revision 1.1  2006/12/09 16:06:42  karasu
 *		add files.
 *
 */

module outland.dmajor.tstring;

import std.utf;
import std.windows.charset;

import win32.windows;

/// 文字列に変換する。
LPTSTR toTString(char[] str) {
	version(Unicode) {
		return toUTF16z(str);
	} else {
		return toMBSz(str, 1u);
	}
}

/// 文字列をUTF8文字列に変換する。
char[] fromTString(LPTSTR str) {
	version(Unicode) {
		return toUTF8(str[0 .. lstrlen(str)]);
	} else {
		return fromMBSz(str, 1u);
	}
}
