﻿/**
 *	エラー関連モジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.poet.error;

import std.c.string;
import derelict.sdl.sdl;

/// Poet内の例外。
class PoetException : Exception {
	
	/// メッセージを指定して生成する。
	this(char[] msg) {super(msg);}
	
	/// ライブラリのエラーを報告する。
	static void throwLastLibraryError() {
		char* msg = SDL_GetError();
		throw new PoetException(msg[0 .. strlen(msg)]);
	}
}

/// ライブラリのエラーメッセージを得る。
static char[] getLastSdlError() {
	char* msg = SDL_GetError();
	return msg[0 .. strlen(msg)];
}

/// SDLの例外。
class SdlException : PoetException {
	this() {super(getLastSdlError());}
}
