# setup.s

stack_begin = 0x1000

# リアルモード用コードを生成する。
.code16

begin:

    # 割り込み禁止。
    cli

    # GDTリミットのロード。
    lgdt    gdtr
    
    # プロテクトモードへ移行。
    movl    %cr0, %eax
    orl     $0x01, %eax
    movl    %eax, %cr0
    
    # パイプラインのリセット。
    jmp reset_pipeline
reset_pipeline:
    
    # コード・セグメント設定。カーネル・コードへ。
    ljmp    $0x08, $set_cs
set_cs:

# ここからは32ビットコード。
.code32

    # 各データ・セグメント設定。カーネル・データへ。
    movw    $0x10, %ax
    movw    %ax, %ds
    movw    %ax, %es
    movw    %ax, %ss
    
    # スタック・ポインタ設定。
    movl    $stack_begin, %esp

    # 止まる。
    hlt

.align 8

# GDTR。
gdtr:
gdtr_limit: .word   gdt_end - gdt - 1
gdtr_base:  .long   gdt

.align 8

# GDT。
gdt:

# 空ディスクリプタ。
gdt_null:
.word   0x00
.word   0x00
.byte   0x00
.byte   0x00
.byte   0x00
.byte   0x00

# カーネル・コード。
gdt_kernel_cs:
.word   0xffff
.word   0x00
.byte   0x00
.byte   0x98
.byte   0xdf
.byte   0x00

# カーネル・データ。
gdt_kernel_ds:
.word   0xffff
.word   0x00
.byte   0x00
.byte   0x92
.byte   0xdf
.byte   0x00

# GDT終端。
gdt_end:
