# ipl.s

# ブート開始アドレス。
boot_begin = 0x7c00

# IPLのサイズ。
ipl_size = 0x200

# 1トラック当たりのセクタ数。
fd_sector_per_track = 0x12

# 1セクタ当たりのバイト数。
fd_sector_length = 512

# カーネル開始セクタ番号。
kernel_begin_sector = 0x01

# カーネル読み込み時のesセグメント・レジスタの増分。
read_kernel_es_offset = 0x1000

# リアルモード用コードを生成する。
.code16

    # BPBを飛び越える。
    jmp begin
    nop

# BPB
name:           .ascii  "Name    "
sector_size:    .word   0x0200
cluster_size:   .byte   0x01
fat_pos:        .word   0x0001
fat_cnt:        .byte   0x02
root_size:      .word   0x00e0
sector_cnt:     .word   0x0b40
media_type:     .byte   0xf0
fat_size:       .word   0x0009
sector_cnt_pt:  .word   0x0012
head_cnt:       .word   0x0002
bpb_pos:        .long   0x0000
sector_cnt_l:   .long   0x00000b40
drive_no:       .byte   0x00
reserved:       .byte   0x00
ext_boot_code:  .byte   0x29
volume_serial:  .long   0xffffffff
disk_name:      .ascii  "DISK       "
fat_name:       .ascii  "FAT12   "

    # 起動処理の開始。
begin:

    # レジスタ初期化。
    cld
    xorw    %ax, %ax
    movw    %ax, %ss
    movw    %ax, %es
    movw    %ax, %fs
    
    # ブート時のドライブ番号を記憶。
    movb	%dl, boot_drive
    
    # スタック・ポインタ初期化。
    movw    $_kernel_begin, %sp
    
    # IPL全体をカーネル開始アドレスへ。
    xor     %ax, %ax
	
    # コピー元。
    movw %ax, %ds
    movw $boot_begin, %si
	
    # コピー先。
    movw %ax, %es
    movw $_kernel_begin, %di
	
    # ワード数。
    movw $(ipl_size / 2), %cx
	
    # コピーする。
    rep movsw
	
    # コードセグメント設定。
    ljmp    $0x0000, $set_cs
set_cs:

    # 起動メッセージ表示。
    movw    $BOOT_MSG, %si
    call    print
    
    # ディスク・システムのリセット。
    movb    %dl, boot_drive
    call    reset_disk
    jc      error
    
    # リセット成功。
    movw    $DISK_RESET_MSG, %si
    call    print

    # カーネルをディスクから読み込む。
    
    # 読込先バッファの設定。
    pushw   $0x00
    popw    %es
    xorw    %di, %di
    movw    $ipl_end, %di
    movb    boot_drive, %dl
    movw    $kernel_begin_sector, %si
    
    # 1セクタずつカーネルを読み込む。
read_kernel:
    call    read_disk_sector
    jc      error   
    addw    $fd_sector_length, %di
    jnc     advance_read_kernel_sector
    movw    %es, %ax
    addw    $read_kernel_es_offset, %ax
    movw    %ax, %es
advance_read_kernel_sector:
    incw    %si
    cmpw    $_kernel_end_sector, %si
    jb      read_kernel
    
    # 読み込み成功。
    movw    $DISK_READ_MSG, %si
    call    print
    
    # setup.sに移動。
    jmp ipl_end
    
# エラー時の処理。
error:
    # メッセージを表示して無限ループ。
    movw    $ERROR_MSG, %si
    call    print
error_end:
    jmp error_end

# 文字列の表示
#   params:
#       si = NULL終端文字列の先頭アドレス。
print:
    # 文字表示コマンドの指定。
    xorw    %bx, %bx
    movb    $0x0e, %ah
    
    # 1文字表示する処理。
print_char:
    # 1バイト読み込み。
    lodsb
    # NULL文字だったら終了。
    orb     %al, %al
    jz      print_end
    
    # BIOSファンクションコール。
    int     $0x10
    
    # 次の文字へ。
    jmp     print_char
    
    # 文字列表示の終了。
print_end:
    ret

# ディスク・システムのリセット。
#	params:
#		dl = ドライブ番号。
#	returns:
#		al = エラーコード。成功時は0。
reset_disk:
	xor		%al, %al
	xor		%ah, %ah
	int		$0x13
	ret

# ディスクからのセクタ読み込み。
#	params:
#		es:di = 読込先バッファアドレス。セグメント指定可能。
#		si = 読み込む論理セクタ番号。 (0 - 2879)
#		dl = ドライブ番号。
#	returns:
#		al = エラーコード。成功時は0。
read_disk_sector:
	# ドライブ番号をスタックに保存。
	pushw	%dx
	xorw	%dx, %dx
	movw	%si, %ax
	
	# トラック番号を計算する。
	movb	$fd_sector_per_track, %dl
	divb	%dl
	
	# トラック番号の設定。
	movb	%al, %ch
	shrb	$0x01, %ch
	
	# 余りセクタ数からヘッダ番号を計算する。
	# 余りセクタ数が奇数だった場合はヘッド番号1。
	jnc		head_0
	mov		$0x01, %dh
head_0:
	
	# セクタ番号を設定する。
	movb	%ah, %cl
	incb	%cl
	
	# コピー先バッファ。
	movw	%di, %bx
	
	# ドライブ番号。
	popw	%ax
	movb	%al, %dl
	
	# 読み込むセクタ数。1固定。
	movb	$0x01, %al
	
	# セクタ読み込みコマンド番号の指定。
	movb	$0x02, %ah
	
	# BIOS機能呼び出し。
	int		$0x13
	
	ret

# 表示するメッセージ。
BOOT_MSG: .string "Hello,World!\r\n"
DISK_RESET_MSG: .string "Success reset disk.\r\n"
DISK_READ_MSG: .string "Success read disk.\r\n"
ERROR_MSG: .string "Disk error!\r\n"

# ブート時のドライブ番号をここに記憶する。
boot_drive:	.byte	0x00

# ブートセクタの印。
. = 510
.short 0xaa55

# IPLの終端。
ipl_end:
