﻿/**
 *	初期化コード。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		NYSL Version 0.9982
 *	History:
 *		$Log$
 */

module outlandish.os.startup;

import outlandish.os.io;

/// 起動直後の処理。
extern(C) void startup() {
	const COM1 = 0x300;
	
	// ボーレートを19200bpsに設定。
	outp(COM1 + 0xfb, 0b1000_0000);
	outp(COM1 + 0xf9, 0x00);
	outp(COM1 + 0xf8, 0x06);
	
	// データビット数を8に設定。
	outp(COM1 + 0xfb, 0b0000_0011);
	
	// 割り込み・RTS・DTSを有効にする。
	outp(COM1 + 0xfc, 0b0000_1011);
	outp(COM1 + 0xf9, 0x00);
	
	// 転送完了まで待つ。
	void waitTransmit() {
		while(!(inp(COM1 + 0xfd) & 0b0100_0000)) {}
	}
	
	// 1バイト転送する。
	void transmitData(ubyte b) {
		outp(COM1 + 0xf8, b);
		waitTransmit();
	}
	
	// 文字列を転送する。
	void transmitString(char[] s) {
		foreach(c; s) {
			transmitData(cast(ubyte) c);
		}
	}
	
	// 文字列を表示。
	transmitString("Hello,World!\r\n");
	
	// 止まる。
	asm {hlt;}
}
