﻿/**
 *	初期化コード。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		NYSL Version 0.9982
 *	History:
 *		$Log$
 */

module outlandish.os.startup;

import outlandish.os.memorymap;
import outlandish.os.serial;

/// 起動直後の処理。
extern(C) void startup() {
	
	foreach(i, e; MEMORY_MAP) {
		print("memory ");
		printDec(i);
		print("\r\n");
		
		print("base ");
		printHex(cast(uint) e.base);		
		print(" length ");
		printHex(cast(uint) e.length);
		print("\r\n");
		
		print("type ");
		printDec(e.type);
		print(" attribute ");
		printDec(e.attribute);
		print("\r\n\r\n");
	}
	
	// 止まる。
	for(;;) {
		asm {hlt;}
	}
}

/// 文字列の出力。
void print(char[] str) {
	scope serial = new SerialPort(Port.COM1, Baudrate.BPS_19_2K);
	foreach(c; str) {
		serial.put(cast(ubyte) c);
	}
}

/// 10進整数の出力。
void printDec(int val) {
	const BASE = 10;
	char[32] str;
	
	str[] = '\0';
	
	int len = 0;
	do {
		str[len++] = '0' + (val % BASE);
	} while((val /= BASE) > 0)
	
	scope serial = new SerialPort(Port.COM1, Baudrate.BPS_19_2K);
	if(val < 0) {
		serial.put(cast(ubyte) '-');
	}
	foreach_reverse(c; str[0 .. len]) {
		serial.put(cast(ubyte) c);
	}
}

/// 16進整数の出力。
void printHex(uint val) {
	const BASE = 16;
	char[32] str;
	char[] digits = "0123456789ABCDEF";
	
	str[] = '\0';
	int len = 0;
	do {
		str[len++] = digits[val % BASE];
	} while((val /= BASE) > 0)
	
	scope serial = new SerialPort(Port.COM1, Baudrate.BPS_19_2K);
	serial.put(cast(ubyte) '0');
	serial.put(cast(ubyte) 'x');
	foreach_reverse(c; str[0 .. len]) {
		serial.put(cast(ubyte) c);
	}
}
