# setup.s

stack_begin = 0x1000

# メモリ・マップの1エントリ分のサイズ。
memory_map_size = 0x18

# メモリ・マップ問い合わせのファンクション・コード。
query_memory_map_fn = 0x0000e820

# メモリ・マップ問い合わせのシグネチャ。
query_memory_sign = 0x534d4150

# リアルモード用コードを生成する。
.code16

begin:

    #メモリ・マップの取得。
    
    # カーネル末尾以降にメモリ・マップを格納する。
    movl    $_kernel_end, %edi
    
    # 最初は0。
    xorl    %ebx, %ebx
    
    # メモリ・マップ・エントリの取得。
query_memory_map:
    # 引数の設定。
    movl    $query_memory_map_fn, %eax
    movl    $memory_map_size, %ecx
    movl    $query_memory_sign, %edx
    
    # 問い合わせ。
    int     $0x15
    
    # エラーが起きたら終了。
    jc      start_protect_mode
    
    # メモリ・マップ格納先のアドレスを進める。
    addw    $memory_map_size, %di
    
    # 次のエントリがあれば繰り返し。
    orl     %ebx, %ebx
    jnz     query_memory_map
    
    # 終了。
    jmp     start_protect_mode

start_protect_mode:
    # 割り込み禁止。
    cli

    # GDTリミットのロード。
    lgdt    gdtr
    
    # プロテクトモードへ移行。
    movl    %cr0, %eax
    orl     $0x01, %eax
    movl    %eax, %cr0
    
    # パイプラインのリセット。
    jmp reset_pipeline
reset_pipeline:
    
    # コード・セグメント設定。カーネル・コードへ。
    ljmp    $0x08, $set_cs
set_cs:

# ここからは32ビットコード。
.code32

    # 各データ・セグメント設定。カーネル・データへ。
    movw    $0x10, %ax
    movw    %ax, %ds
    movw    %ax, %es
    movw    %ax, %ss
    
    # スタック・ポインタ設定。
    movl    $stack_begin, %esp
    
    # メモリ・マップのエントリ数と開始アドレスをD言語の配列に設定。
    
    # エントリ数の計算。
    movl    %edi, %eax
    subl    $_kernel_end, %eax
    xorl    %edx, %edx
    movl    $memory_map_size, %ecx
    divl    %ecx
    
    # 構造体に格納。
    movl    $_MEMORY_MAP, %edi
    movl    %eax, 0(%edi)
    movl    $_kernel_end, 4(%edi)

    # D言語関数へ。
    call _startup

.align 8

# GDTR。
gdtr:
gdtr_limit: .word   gdt_end - gdt - 1
gdtr_base:  .long   gdt

.align 8

# GDT。
gdt:

# 空ディスクリプタ。
gdt_null:
.word   0x00
.word   0x00
.byte   0x00
.byte   0x00
.byte   0x00
.byte   0x00

# カーネル・コード。
gdt_kernel_cs:
.word   0xffff
.word   0x00
.byte   0x00
.byte   0x98
.byte   0xdf
.byte   0x00

# カーネル・データ。
gdt_kernel_ds:
.word   0xffff
.word   0x00
.byte   0x00
.byte   0x92
.byte   0xdf
.byte   0x00

# GDT終端。
gdt_end:

.align 8
