/*
 * ipl.ls
 *
 * IPL用リンカスクリプト。
 */

SECTIONS {
    /* カーネル開始アドレス */
    . = 0x1000;
    _kernel_begin = .;

    /* IPLを納めるセクション */
    .ipl 0x1000 : {
        ipl.o;
        setup.o;
        
        *(EXCLUDE_FILE(ipl.o setup.o)*);
        . = ALIGN(32);
        /* カーネル終端 */
        _kernel_end = .;
    }
    
    /* カーネル全体のセクタ数 */
    _kernel_end_sector = ((_kernel_end - _kernel_begin) + 511) / 512;
}
