
/**
 * C's &lt;string.h&gt;
 * Authors: Walter Bright, Digital Mars, www.digitalmars.com
 * License: Public Domain
 * Macros:
 *	WIKI=Phobos/StdCString
 */

/* NOTE: This file is Hatena OS version.

   Modified by Akira Yamaguchi, June 2007
*/

module std.c.string;

extern (C):

void* memchr(void* s, int c, size_t n) {
	asm {
		naked;
		mov ECX, n;
		mov EDI, s;
		mov AL, c;
		repne; scasb;
		je Lfound;
		xor EDI, EDI; // null
	Lfound:
		mov EAX, EDI;
		ret;
	}
}

int memcmp(void* s1, void* s2, size_t n) {
	asm {
		naked;
		mov ECX, n;
		mov EDI, s1;
		mov ESI, s2;
		repe; cmpsb;
		mov EAX, EDI;
		sub EAX, ESI;
		ret;
	}
}

void* memcpy(void *d, void *s, size_t n) {
	asm {
		mov ECX, n;
		mov EDI, d;
		mov ESI, s;
		rep; movsb;
	}
	return d;
}
