﻿/**
 *	error codes.
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module os.i386.errorcode;

import std.stdint;

enum Errno : uint32_t {
	SUCCESS,
	
	INVALID_STATE,
	NOT_ENOUGH_MEMORY,
	NOT_INITIALIZED_SYSTEM,
	INVALID_SYSTEM_CALL,
	
	/// user define error code
	USER_BEGIN = 0x8000_0000,
}

bool succeeded(Errno e) {return e == Errno.SUCCESS;}
bool failed(Errno e) {return e != Errno.SUCCESS;}
