# ipl.s
#
# $log$
# $revision$

# constants
boot_begin = 0x7c00
color_white = 0x07
kernel_begin_sector = 0x01
fd_sector_per_track = 0x12
fd_sector_length = 512
ipl_size = 512

memory_map_size = 0x14
query_memory_map = 0x0000e820
query_memory_sign = 0x534d4150

# generate real mode code
.code16

	jmp	begin
	nop

# BPB
name:			.ascii	"Poet OS "
sector_size:	.word	0x0200
cluster_size:	.byte	0x01
fat_pos:		.word	0x0001
fat_cnt:		.byte	0x02
root_size:		.word	0x00e0
sector_cnt:		.word	0x0b40
media_type:		.byte	0xf0
fat_size:		.word	0x0009
sector_cnt_pt:	.word	0x0012
head_cnt:		.word	0x0002
bpb_pos:		.long	0x0000
sector_cnt_l:	.long	0x00000b40
drive_no:		.byte	0x00
reserved:		.byte	0x00
ext_boot_code:	.byte	0x29
volume_serial:	.long	0xffffffff
disk_name:		.ascii	"POET       "
fat_name:		.ascii	"FAT12   "

	# setup registers
begin:

	# deny interrupt
	cli
	cld
	
	xorw	%ax, %ax
	movw	%ax, %ss
	movw	$_kernel_begin, %sp
	movb	%dl, boot_drive
	
	# move ipl to kernel begin
	
	# source
	movw	%ax, %ds
	movw	$boot_begin, %si
	
	#dest
	movw	%ax, %es
	movw	$_kernel_begin, %di
	
	# count
	movw	$(ipl_size / 2), %cx
	
	# move
	rep		movsw
	
	# jamp to kernel begin
	ljmp	$0, $set_cs
set_cs:
	
	# accept interrupt
	sti
	
	# boot message
	movw	$boot_msg, %si
	call print
	
	# reset disk drive
	movb	%dl, boot_drive
	call	reset_disk
	jc		failure
	
	# success
	movw	$succ_reset_msg, %si
	call	print
	
	# read kernel image from disk
	pushw	$0x00
	popw	%es
	xorw	%di, %di
	movw	$ipl_end, %di
	movb	boot_drive, %dl
	movw	$kernel_begin_sector, %si
read_kernel:
	call	read_disk_sector
	jc		failure	
	addw	$fd_sector_length, %di
	jnc		advance_read_kernel_sector
	movw	%es, %ax
	addw	$0x1000, %ax
	movw	%ax, %es
advance_read_kernel_sector:
	incw	%si
	cmpw	$_kernel_end_sector, %si
	jb		read_kernel
	
	# success
	movw	$succ_read_msg, %si
	call	print
	
	# begin setup
	jmp		ipl_end

	# process disk error
failure:
	jmp failure
	movw	$disk_err_msg, %si
	call	print

end:
	jmp		end

# print string
#	params:
#		si = string address
print:
	xorw	%bx, %bx
	movb	$0x0e, %ah
print_char:
	lodsb
	orb		%al, %al
	jz		print_end
	int		$0x10
	jmp		print_char
print_end:
	ret

# reset disk system
#	params:
#		dl = drive no
#	returns:
#		al = error code. 0 if succeeded.
reset_disk:
	xor		%al, %al
	xor		%ah, %ah
	int		$0x13
	ret

# read disk sector
#	params:
#		es:di = dest buffer address
#		si = source sector no (0 - 2879)
#		dl = drive no
#	returns:
#		al = error code. 0 if succeeded.
read_disk_sector:
	pushw	%dx
	xorw	%dx, %dx
	movw	%si, %ax
	
	# logical sector to track no
	movb	$fd_sector_per_track, %dl
	divb	%dl
	
	# track no
	movb	%al, %ch
	shrb	$0x01, %ch
	
	# head no
	jnc		head_0
	mov		$0x01, %dh
head_0:
	
	# sector no
	movb	%ah, %cl
	incb	%cl
	
	# dest buffer
	movw	%di, %bx
	
	# drive no
	popw	%ax
	movb	%al, %dl
	
	# sector count
	movb	$0x01, %al
	
	# read command
	movb	$0x02, %ah
	
	# execute
	int		$0x13
	
	ret

# get disk spec
#	params:
#		bl = drive no
#	returns:
#		bl = drive type
#		ax = sector count
#		cx = cylinder count
#		dh = header count
#		dl = drive count
get_disk_spec:
	mov		$0x08, %ah
	int		$0x13
	ret

.align 4
boot_msg:		.string	"booting Poet operating system\r\n"
disk_err_msg:	.string	"disk error!\r\n"
succ_reset_msg:	.string	"success disk reset...\r\n"
succ_read_msg:	.string	"success disk read...\r\n"
boot_drive:	.byte	0x00

# boot signature.
. = 510
.short 0xaa55

ipl_end:
