# setup.s
#
# MIT/X Consortium License
#
# $log$
# $revision$

stack_top = 0x1000
memory_map_size = 0x18
query_memory_map = 0x0000e820
query_memory_sign = 0x534d4150

.code16

# code begin
setup_start_address:

	# setup registers
	
	# deny interrupt
	cli
	cld

	movw	%cs, %ax
	movw	%ax, %ds
	movw	%ax, %es
	xorw	%ax, %ax
	movw	%ax, %ss
	movw	$stack_top, %sp
	
	# accept interrupt
	sti
	
	# query memory map
	xorl	%ebx, %ebx
	pushw	%ax
	popw	%es
	movw	$memory_map_begin, %di
next_query_memory_map:
	movl	$query_memory_map, %eax
	movl	$query_memory_sign, %edx
	movl	$memory_map_size, %ecx
	int		$0x15
	
	# check error
	jc		query_memory_map_end
	
	# point next buffer.
	addw	$memory_map_size, %di
	or		%ebx, %ebx
	jnz		next_query_memory_map
query_memory_map_end:

	# calculate memory map length.
	xorl	%ecx, %ecx
	movw	%di, %cx
	subw	$memory_map_begin, %cx

	# calculate memory map liner address.
	xorl	%ebp, %ebp
	pushw	%ds
	popw	%bp
	shlw	$4, %bp
	addw	$memory_map_begin, %bp
	
	# deny interrupt
	cli
	
	# load GDT
	lgdt	_GDT_LIMIT
	
	# to protect mode
	movl	%cr0, %eax
	orl		$0x1b, %eax
	movl	%eax, %cr0
	
	# reset pipeline
	jmp reset_pipeline
reset_pipeline:
	
	# set cs
	ljmp	$0x08, $set_cs
set_cs:

.code32

	# set segments
	movw	$0x10, %ax
	movw	%ax, %ds
	movw	%ax, %es
	movw	%ax, %ss
	movl	$stack_top, %esp
	
	pushl	%ecx
	pushl	%ebp
	call	_startup # no return
	
	hlt
	
# return kernel begin address
.global _getKernelEnd
_getKernelBegin:
	movl $_kernel_begin, %eax
	ret

# return kernel end address
.global _getKernelEnd
_getKernelEnd:
	movl $_kernel_end, %eax
	ret
