# switchto.s
#
# MIT/X Consortium License
#
# $log$
# $revision$

PAGE_MASK = 0xfffff000
PAGE_LENGTH = 0x1000

# thread context switch
.global _switchToNextThread
_switchToNextThread:
	# save current context
	movl 4(%esp), %eax
	movl %esp, (%eax)
	movl $restart, 4(%eax)
	movw %fs, 8(%eax)
	movw %gs, 10(%eax)
	
	# restore next context
	movl 8(%esp), %eax
	movl (%eax), %esp
	movl 4(%eax), %ecx
	movw 8(%eax), %fs
	movw 10(%eax), %gs

	jmp *%ecx
restart:
	ret

.global _threadEntryPoint
_threadEntryPoint:
	iret
